<?php

class M_orders extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function getNewOrders($branch_id)
  {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','pending');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  
   function getApprovedOrders($branch_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','approved');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
   
   function getActiveOrders($branch_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','processing');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }

   function getDispatchedOrders($branch_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','dispatched');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  

   function getCompletedOrders($branch_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','delivered');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }

   function getCancelledOrders($branch_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','cancelled');
        $this->db->where('branch_id',$branch_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  
  
    function getDrivers($latitude,$longitude,$date,$time)
    {
        $query = "SELECT driver_id,date,time,SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM locations WHERE location_id IN (SELECT MAX(location_id) FROM locations GROUP BY driver_id) HAVING distance<10 AND date='$date' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    } 
    
   
  
}

?>
