<?php

class M_dashboard extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }


  function getProducts($id)
  {
    $this->db->select("*");
    $this->db->from('products');
    $this->db->where('status','active');
    $this->db->where('r_id',$id);
    $this->db->limit(6);
    $this->db->order_by('p_id','desc');
    return $this->db->get()->result();
  }

  function getCategories($id)
  {
    $this->db->select("*");
    $this->db->from('menu');
    $this->db->where('status','1');
    $this->db->where('r_id',$id);
    $this->db->limit(6);
    $this->db->order_by('menu_id','desc');
    return $this->db->get()->result();
  }
  
  function getOrders($id)
  {
    $this->db->select('orders.*,restaurants.rest_name,users.firstname,users.lastname');
    $this->db->from('orders');
    $this->db->join('restaurants','restaurants.r_id=orders.r_id');
    $this->db->join('users','users.user_id=orders.user_id');
    $this->db->where('MONTH(orders.ordered_date)', date('m')); //For current month
    $this->db->where('YEAR(orders.ordered_date)', date('Y')); // For current year
    $this->db->where('orders.branch_id',$id);
    $this->db->limit(6);
    $this->db->order_by('orders.order_id','desc');
    return $this->db->get()->result();
  }

   function getOrderCount($id)
   {
        $date = date('Y-m-d');
        $this->db->select("*");
        $this->db->from('orders');
        // $this->db->where('MONTH(ordered_date)', date('d'));
        // $this->db->where('MONTH(ordered_date)', date('m')); //For current month
        // $this->db->where('YEAR(ordered_date)', date('Y')); // For current year
        $this->db->where('ordered_date', $date);
        $this->db->where('branch_id',$id);
        return $this->db->get()->num_rows();
   }
  
    function getTodaysCancelledOrderCount($id)
    {
        $date = date('Y-m-d');
        $this->db->select("*");
        $this->db->from('orders');
        $this->db->where('cancelled_date',$date);
        $this->db->where('branch_id',$id);
        return $this->db->get()->num_rows();
    }
  
}

?>
