<?php
class M_blocks extends CI_Model
{
    function __construct()
    {
        $this->load->database();
    }
    public function getBlocks($id)
    {
        $this->db->select('branch_delivery_blocks.*,blocks.block_name,blocks.place_name,places.name');
        $this->db->from('branch_delivery_blocks');
        $this->db->join('blocks','blocks.block_id=branch_delivery_blocks.block_id');
        $this->db->join('places','places.place_id=blocks.city_id');
        $this->db->where('branch_delivery_blocks.branch_id',$id);
        $this->db->where('blocks.block_status','1');
        $this->db->where('places.status','1');
        $this->db->order_by('blocks.block_id','desc');
        return $this->db->get()->result();
    }

    public function getAllBlocks()
    {
        $this->db->select('*');
        $this->db->from('blocks');
        $this->db->where('block_status','1');
        $this->db->order_by('block_id','desc');
        return $this->db->get()->result();
    }

    public function getBranchBlockStat($block_id,$branch_id)
    {
        $this->db->select('*');
        $this->db->from('branch_delivery_blocks');
        $this->db->where('block_id',$block_id);
        $this->db->where('branch_id',$branch_id);
        return $this->db->get()->num_rows();
    }
}

?>