<?php

class M_status extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  
  function getTodaysTotalSale($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('SUM(amount) as total');
    $this->db->from('user_payments');
    $this->db->where('driver_id',$id);
    $this->db->where('date',$date);
    $result = $this->db->get();
    
    //if($result->num_rows()>0)
    if($result->row()->total)
    {
        return $result->row()->total;
    }
    else
    {
        return 0;
    }
  }
  
  function getWeeksTotalSale($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('SUM(amount) as total');
    $this->db->from('user_payments');
    $this->db->where('driver_id',$id);
    $this->db->where('WEEKOFYEAR(date)=WEEKOFYEAR(NOW())');
    $result = $this->db->get();
    //if($result->num_rows()>0)
    if($result->row()->total)
    {
        return $result->row()->total;
    }
    else
    {
        return 0;
    }
  }
  
  function getMonthTotalSale($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('SUM(amount) as total');
    $this->db->from('user_payments');
    $this->db->where('driver_id',$id);
    $this->db->where('MONTH(date)', date('m')); //For current month
    $this->db->where('YEAR(date)', date('Y')); // For current year
    $result = $this->db->get();
    //if($result->num_rows()>0)
    if($result->row()->total)
    {
        return $result->row()->total;
    }
    else
    {
        return 0;
    }
  }
  
  function getTotalSale($id)
  {
    $this->db->select('SUM(amount) as total');
    $this->db->from('user_payments');
    $this->db->where('driver_id',$id);
    $result = $this->db->get();
    //if($result->num_rows()>0)
    if($result->row()->total)
    {
        return $result->row()->total;
    }
    else
    {
        return 0;
    }
  }

  function getTodaysPendingOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','processing');
      $this->db->where('DATE(driver_orders.assigned_time)', date('Y-m-d'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }

  function getTodaysStartedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','dispatched');
      $this->db->where('DATE(driver_orders.dispatched_time)', date('Y-m-d'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }

  function getTodaysCompletedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','completed');
      $this->db->where('orders.completed_date', date('Y-m-d'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }

  function getMonthlyPendingOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','processing');
      $this->db->where('MONTH(driver_orders.assigned_time)', date('n'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }  

  function getMonthlyStartedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','dispatched');
      $this->db->where('MONTH(driver_orders.dispatched_time)', date('n'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }

  function getMonthlyCompletedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','completed');
      $this->db->where('MONTH(orders.completed_date)', date('n'));
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }  

  function getTotalPendingOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','processing');
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }  

  function getTotalStartedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','assigned');
      $this->db->where('orders.status','dispatched');
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }

  

  function getTotalCompletedOrders($id) {
    $this->db->select('COUNT(orders.order_id) as count');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      $this->db->where('driver_orders.driver_id', $id);
      $this->db->where('driver_orders.status','completed');
      $result = $this->db->get();
      if($result->row()->count)
      {
          return $result->row()->count;
      }
      else
      {
          return 0;
      }
  }
  
//payment list//
 
  function getTodaysTotalPaymentList($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('orders.order_id,orders.address_id,orders.user_id,users.firstname,users.lastname,users.mobile,orders.total,restaurants.rest_name,restaurants.cover_image as rest_image,restaurants.latitude,restaurants.longitude,restaurants.rest_phone,orders.completed_date,orders.completed_time');
    $this->db->from('driver_orders');
    $this->db->join('orders','orders.order_id=driver_orders.order_id');
    $this->db->join('users','users.user_id=orders.user_id');
    $this->db->join('restaurants','restaurants.r_id=orders.r_id');
    $this->db->where('driver_orders.status','completed');
    $this->db->where('driver_orders.driver_id',$id);
    $this->db->where('orders.completed_date',$date);
    $this->db->order_by('orders.order_id','desc');
    return $this->db->get()->result();
  }
  
  function getWeeksTotalPaymentList($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('orders.order_id,,orders.address_id,orders.user_id,users.firstname,users.lastname,users.mobile,orders.total,restaurants.rest_name,restaurants.cover_image as rest_image,restaurants.latitude,restaurants.longitude,restaurants.rest_phone,orders.completed_date,orders.completed_time');
    $this->db->from('driver_orders');
    $this->db->join('orders','orders.order_id=driver_orders.order_id');
    $this->db->join('users','users.user_id=orders.user_id');
    $this->db->join('restaurants','restaurants.r_id=orders.r_id');
    $this->db->where('driver_orders.status','completed');
    $this->db->where('driver_orders.driver_id',$id);
    $this->db->where('WEEKOFYEAR(orders.completed_date)=WEEKOFYEAR(NOW())');
    $this->db->order_by('orders.order_id','desc');
    return $this->db->get()->result();
  }
  
  function getMonthTotalPaymentList($id)
  {
    $date = date('Y-m-d');  
    $this->db->select('orders.order_id,,orders.address_id,orders.user_id,users.firstname,users.lastname,users.mobile,orders.total,restaurants.rest_name,restaurants.cover_image as rest_image,restaurants.latitude,restaurants.longitude,restaurants.rest_phone,orders.completed_date,orders.completed_time');
    $this->db->from('driver_orders');
    $this->db->join('orders','orders.order_id=driver_orders.order_id');
    $this->db->join('users','users.user_id=orders.user_id');
    $this->db->join('restaurants','restaurants.r_id=orders.r_id');
    $this->db->where('driver_orders.status','completed');
    $this->db->where('driver_orders.driver_id',$id);
    $this->db->where('MONTH(orders.completed_date)', date('m')); //For current month
    $this->db->where('YEAR(orders.completed_date)', date('Y')); // For current year
    $this->db->order_by('orders.order_id','desc');
    return $this->db->get()->result();
  }
  
  function getTotalPaymentList($id)
  {
    $this->db->select('orders.order_id,,orders.address_id,orders.user_id,users.firstname,users.lastname,users.mobile,orders.total,restaurants.rest_name,restaurants.cover_image as rest_image,restaurants.latitude,restaurants.longitude,restaurants.rest_phone,orders.completed_date,orders.completed_time');
    $this->db->from('driver_orders');
    $this->db->join('orders','orders.order_id=driver_orders.order_id');
    $this->db->join('users','users.user_id=orders.user_id');
    $this->db->join('restaurants','restaurants.r_id=orders.r_id');
    $this->db->where('driver_orders.status','completed');
    $this->db->where('driver_orders.driver_id',$id);
    $this->db->order_by('orders.order_id','desc');
    return $this->db->get()->result();
  }
  
 

  
  function getProducts()
  {
      $this->db->select('product_id,product_name');
      $this->db->from('products');
      $this->db->where('product_status','1');
      return $this->db->get()->result();
  }
 
}

?>