<?php

class M_order extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function getCartData($customer_id)
  {
     $this->db->select('products.product_id,products.product_name as product_name_english,products.product_name_arabic,products.cat_id,products.price,products.product_vat,products.product_status,products.product_image,cart.quantity,cart.cart_id');
     $this->db->from('cart');
     $this->db->join('products','products.product_id=cart.product_id');
     $this->db->order_by('cart.cart_id',"desc");
     $this->db->where('cart.customer_id',$customer_id);
     return $this->db->get()->result();
  }
  
   function getOrders($id)
   {
     $this->db->select('order_id,customer_id,customer_name,customer_phone,location,latitude,longitude,payment_method,total,amount_received,credit_balance,delivery_date,delivery_time,completed_date,completed_time,status,agency_assigned,timestamp,billing_date as ordered_date,ordered_time');
     $this->db->from('customer_orders');
     $this->db->where('customer_id',$id);
     $this->db->where('type','app');
     $this->db->order_by('order_id','desc');
     return $this->db->get()->result();
   }
  
   function getOrderedProducts($order_id)
   {
     $this->db->select('ordered_products.*,products.cover_image,products.name,products.price,products.prep_time,products.cat_id,products.r_id,restaurants.cover_image as rest_logo,restaurants.rest_name,menu.name');
     $this->db->from('ordered_products');
     $this->db->join('products','products.p_id = ordered_products.product_id');
     $this->db->join('restaurants','restaurants.r_id = products.r_id');
     $this->db->join('menu','menu.menu_id = products.cat_id','left outer');
     $this->db->where('ordered_products.order_id',$order_id);
     return $this->db->get()->result();
   }
   
   function getOrderedExtras($order_id,$product_id)
   {
     $this->db->select('ordered_extras.*,extras.name');
     $this->db->from('ordered_extras');
     $this->db->join('extras','extras.extra_id = ordered_extras.extra_id');
     $this->db->where('ordered_extras.order_id',$order_id);
     $this->db->where('ordered_extras.product_id',$product_id);
     return $this->db->get()->result();
   }
  
   function getOrderDetails($id)
   {
     // $this->db->select('orders.order_id, orders.address_id, orders.user_id, users.firstname, users.lastname, users.mobile, users.email, orders.payment_method, orders.total, orders.ordered_date, orders.ordered_time, orders.completed_date, orders.completed_time, orders.cancelled_date, orders.completed_date, orders.completed_time, orders.status, restaurants.cover_image as rest_logo, restaurants.rest_name, restaurants.latitude as rest_latitude, restaurants.longitude as rest_longitude, restaurants.city, restaurants.landmark, restaurants.address1 as rest_address, restaurants.rest_phone, assigned_time, dispatched_time');
     // $this->db->from('orders');
     // $this->db->join('driver_orders','driver_orders.order_id = orders.order_id');
     // $this->db->join('users','users.user_id=orders.user_id');
     // $this->db->join('restaurants','restaurants.r_id = orders.r_id');
     // $this->db->where('orders.order_id',$id);
     // return $this->db->get()->row();

    $this->db->select('orders.order_id, orders.address_id, orders.user_id,  orders.payment_method, orders.total, orders.ordered_date, orders.ordered_time, orders.completed_date, orders.completed_time, orders.cancelled_date, orders.delivery_notes, orders.completed_time, orders.status, restaurants.cover_image as rest_logo, restaurants.rest_name, restaurants.latitude as rest_latitude, restaurants.longitude as rest_longitude, restaurants.city, restaurants.landmark, restaurants.address1 as rest_address, restaurants.rest_phone, assigned_time, dispatched_time');
     $this->db->from('orders');
     $this->db->join('driver_orders','driver_orders.order_id = orders.order_id');
     $this->db->join('restaurants','restaurants.r_id = orders.r_id');
     $this->db->where('orders.order_id',$id);
     return $this->db->get()->row();
   }
  
    function getNewRequests($latitude,$longitude,$date)
    {   
        $query = "SELECT orders.order_id,orders.user_id,orders.total,orders.address_id,orders.ordered_date,orders.ordered_time,orders.r_id,SQRT(POW(69.1 * (address.latitude - $latitude), 2) +POW(69.1 * (address.longitude - $longitude) * COS(address.latitude / 57.3), 2)) AS distance FROM orders INNER JOIN address ON address.address_id=orders.address_id WHERE orders.status='pending' HAVING distance <'10' ORDER BY distance;";
        
        $res = $this->db->query($query);
        return $res->result();
    }

    function getAllOrders($driver_id) {        
        $this->db->select('orders.order_id, orders.user_id, orders.total, orders.address_id, orders.ordered_date, orders.ordered_time,  orders.r_id, orders.status, driver_orders.status as driver_status');
        $this->db->from('driver_orders');
        $this->db->join('orders','orders.order_id=driver_orders.order_id');
        //$this->db->where('orders.status', 'processing');
        //$this->db->where('driver_orders.status', 'assigned');
        $this->db->where('driver_orders.driver_id',$driver_id);
        $this->db->order_by('ordered_date');
        return $this->db->get()->result();
    }
    
    function getPendingOrders($driver_id) {        

        $this->db->select('orders.order_id, orders.user_id, orders.total, orders.address_id, orders.ordered_date, orders.ordered_time,  orders.r_id, orders.status, driver_orders.status as driver_status');
        $this->db->from('driver_orders');
        $this->db->join('orders','orders.order_id=driver_orders.order_id');
        $this->db->where('orders.status', 'processing');
        $this->db->where('driver_orders.status', 'assigned');
        $this->db->where('driver_orders.driver_id',$driver_id);
        $this->db->order_by('ordered_date');
        return $this->db->get()->result();
    }

    function getStartedOrders($driver_id) {        

        $this->db->select('orders.order_id, orders.user_id, orders.total, orders.address_id, orders.ordered_date, orders.ordered_time,  orders.r_id, orders.status, driver_orders.status as driver_status, dispatched_time');
        $this->db->from('driver_orders');
        $this->db->join('orders','orders.order_id=driver_orders.order_id');
        $this->db->where('orders.status', 'dispatched');
        $this->db->where('driver_orders.status', 'assigned');
        $this->db->where('driver_orders.driver_id',$driver_id);
        $this->db->order_by('ordered_date');
        return $this->db->get()->result();
    }
  
   function getApprovedRequests($id)
   {
    //   $this->db->select('driver_orders.driver_id,driver_orders.status,driver_orders.assigned_time,orders.order_id,orders.r_id,orders.ordered_date,orders.ordered_time,orders.address_id,orders.user_id,orders.total,orders.delivery_date,orders.order_type,orders.delivery_time,restaurants.cover_image as rest_logo,restaurants.rest_name,restaurants.latitude,restaurants.longitude');
    //   $this->db->from('driver_orders');
    //   $this->db->join('orders','orders.order_id=driver_orders.order_id');
    // //   $this->db->join('users','users.user_id = orders.user_id');
    //   $this->db->join('restaurants','restaurants.r_id = orders.r_id');
    //   $this->db->where('driver_orders.driver_id',$id);
    //   $this->db->where('driver_orders.status','assigned');
    //   $this->db->order_by('orders.order_id','desc');
    //   return $this->db->get()->result();

    $this->db->select('orders.order_id,orders.user_id,orders.total,orders.address_id,orders.ordered_date,orders.ordered_time,orders.r_id');
        $this->db->from('orders');
        $this->db->where('orders.status', 'approved');
        $this->db->order_by('ordered_date');
        return $this->db->get()->result();
   }
  
   function getCompletedRequests($id)
   {
      // $this->db->select('orders.order_id, orders.order_id, orders.address_id, orders.user_id, driver_orders.driver_id, orders.status, driver_orders.status as driver_status, driver_orders.assigned_time, driver_orders.completed_time, users.firstname, users.lastname, users.mobile, users.email, orders.total, orders.completed_date, orders.completed_time, restaurants.rest_name, restaurants.cover_image as rest_image');
      // $this->db->from('driver_orders');
      // $this->db->join('orders','orders.order_id=driver_orders.order_id');
      // $this->db->join('users','orders.user_id=users.user_id');
      // $this->db->join('restaurants','restaurants.r_id=orders.r_id');
      // $this->db->where('driver_orders.driver_id',$id);
      // $this->db->where('driver_orders.status','completed');
      // $this->db->order_by('orders.order_id','desc');
      // return $this->db->get()->result();

    $this->db->select('orders.order_id, orders.order_id, orders.address_id, orders.user_id, driver_orders.driver_id, orders.status, driver_orders.status as driver_status, driver_orders.assigned_time, driver_orders.completed_time, orders.total, orders.completed_date, orders.completed_time,orders.delivery_time, restaurants.rest_name, restaurants.cover_image as rest_image');
      $this->db->from('driver_orders');
      $this->db->join('orders','orders.order_id=driver_orders.order_id');
      //$this->db->join('users','orders.user_id=users.user_id');
      $this->db->join('restaurants','restaurants.r_id=orders.r_id');
      $this->db->where('driver_orders.driver_id',$id);
      $this->db->where('driver_orders.status','completed');
      $this->db->order_by('orders.order_id','desc');
      return $this->db->get()->result();
   }
   
   function getDrivers($latitude,$longitude,$date,$time)
   {
        $query = "SELECT driver_id,date,time,SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM locations WHERE location_id IN (SELECT MAX(location_id) FROM locations GROUP BY driver_id) HAVING distance<10 AND date='$date' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
   } 
    
   function getPendingDrivers($latitude,$longitude,$date,$time,$agency_id)
   {
        $query = "SELECT agency_id,date,time,SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM locations WHERE location_id IN (SELECT MAX(location_id) FROM locations GROUP BY agency_id) HAVING distance<10 AND date='$date' AND agency_id!='$agency_id' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
   } 
    
   function getLatestLocation($id)
   {
        $this->db->select('*');
        $this->db->from('locations');
        $this->db->where('driver_id',$id);
        $this->db->order_by('location_id','desc');
        $this->db->limit('1');
        return $this->db->get()->row();
   }
    
    public function getCoupon($customer_id,$product_id,$date)
    {
        // $this->db->select('*');
        // $this->db->from('coupon_purchases');
        // $this->db->where('customer_id',$customer_id);
        // $this->db->where('product_id',$product_id);
        // $this->db->where('expiry_date>=',$date);
        // $this->db->where('unused_coupons>',0);
        // return $this->db->get();
        
        $this->db->select('coupon_purchases.*,coupon_packages.product_id');
        $this->db->from('coupon_purchases');
        $this->db->join('coupon_packages','coupon_packages.cpack_id=coupon_purchases.pack_id');
        $this->db->where('coupon_purchases.customer_id',$customer_id);
        $this->db->where('coupon_packages.product_id',$product_id);
        $this->db->where('coupon_purchases.expiry_date>=',$date);
        $this->db->where('coupon_purchases.unused_coupons>',0);
        $this->db->order_by('coupon_purchases.cpurchase_id','desc');
        $this->db->limit('1');
        return $this->db->get();
    }
    
    public function getPendingNewRequests()
    { 
        $date = date('Y-m-d');
        $this->db->select('*');
        $this->db->from('customer_orders');
        $this->db->where('status','pending');
        $this->db->where('delivery_date',$date);
        return $this->db->get()->result();
    }
    public function CheckStartOrders($id)
   {
        $this->db->select('driver_orders.order_id,driver_orders.do_id');
        $this->db->from('driver_orders');
        $this->db->join('orders','orders.order_id=driver_orders.order_id');
        $this->db->where('driver_orders.driver_id',$id);
        $this->db->where('orders.status','dispatched');
        $this->db->order_by('orders.order_id','desc');
        return $this->db->get();
   }
}

?>