<?php

class M_restaurant extends CI_Model
{
    function __construct()
    {
        $this->load->database();
    }

    function getRestaurants($latitude,$longitude,$radius)
    {
        $query = "SELECT restaurants.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM restaurants WHERE status='1' HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getBranches($latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT branches.b_id as branch_id,branches.r_id,branches.phone as rest_phone,branches.email as rest_email,branches.latitude,branches.longitude,branches.address as address1,branches.location as landmark,branches.city,branches.country,restaurants.rest_name,restaurants.cover_image,restaurants.rest_image,restaurants.rest_image,restaurants.thumbnail,restaurants.service_charge,restaurants.min_order,restaurants.open_time,restaurants.close_time,restaurants.delivery_charge, SQRT(POW(69.1 * (branches.latitude - $latitude), 2) +POW(69.1 * (branches.longitude - $longitude) * COS(branches.latitude / 57.3), 2)) AS distance FROM branches INNER JOIN restaurants ON restaurants.r_id=branches.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND branches.status='1' AND restaurants.status='1' GROUP BY branches.r_id ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }

    function searchRestaurant1($keyword)
    {
        $this->db->select('r_id,rest_name,rest_image');
        $this->db->from('restaurants');
        $this->db->where("rest_name LIKE '%$keyword%'");
        $this->db->where('status','1');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
    
    function searchBranches1($keyword)
    {
        $this->db->select('restaurants.r_id,restaurants.rest_name,restaurants.rest_image,b_id as branch_id');
        $this->db->from('branches');
        $this->db->join('restaurants','restaurants.r_id=branches.r_id');
        $this->db->where("restaurants.rest_name LIKE '%$keyword%'");
        $this->db->where('branches.status','1');
        $this->db->where('restaurants.status','1');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
  
    function getAllRestaurants()
    {
        $this->db->select('r_id,rest_name,rest_image');
        $this->db->from('restaurants');
        $this->db->where('status','1');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
    
    function getAllBranches()
    {
        $this->db->select('restaurants.r_id,restaurants.rest_name,restaurants.rest_image,b_id as branch_id');
        $this->db->from('branches');
        $this->db->join('restaurants','restaurants.r_id=branches.r_id');
        $this->db->where('branches.status','1');
        $this->db->where('restaurants.status','1');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
  
    function getTypes1($id)
    {
      $this->db->select('restaurant_styles.name');
      $this->db->from('restaurant_types');
      $this->db->join('restaurant_styles','restaurant_styles.rs_id=restaurant_types.rs_id');
      $this->db->where('restaurant_types.r_id',$id);
      return $this->db->get()->result();
    }
    
    function getDays($id)
    {
      $this->db->select('days.day');
      $this->db->from('product_days');
      $this->db->join('days','days.d_id=product_days.day_id');
      $this->db->where('product_days.p_id',$id);
      return $this->db->get()->result();
    }
    
    function getProductImages($id)
    {
      $this->db->select('image');
      $this->db->from('product_images');
      $this->db->where('p_id',$id);
      return $this->db->get()->result();
    }
  
    function getTypes($id)
    {
      $this->db->select('cuisines.name');
      $this->db->from('restaurant_cuisines');
      $this->db->join('cuisines','cuisines.c_id=restaurant_cuisines.c_id');
      $this->db->where('restaurant_cuisines.r_id',$id);
      return $this->db->get()->result();
    }
  
    public function totalRatings($id)
    {
        $this->db->select('SUM(rating) as total');
        $this->db->from('restaurant_reviews');
        $this->db->where('r_id',$id);
        $result = $this->db->get();
        if($result->num_rows()>0)
        {
           return $result->row()->total;
        }
        else
        {
           return false;
        }
    }
  
    function getCuisines()
    {
        $this->db->select('*');
        $this->db->from('cuisines');
        $this->db->where('status','1');
        $this->db->order_by('name','asc');
        return $this->db->get()->result();
    }
  
//   function getCuisineRestaurants($id)
//   {
//       $this->db->select('restaurants.*');
//       $this->db->from('restaurant_cuisines');
//       $this->db->join('restaurants','restaurants.r_id=restaurant_cuisines.r_id');
//       $this->db->where('restaurant_cuisines.c_id',$id);
//       $this->db->where('restaurants.status','1');
//       $this->db->order_by('restaurants.r_id','desc');
//       return $this->db->get();
//   }
  
    function getCuisineRestaurantsCount($id,$latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT restaurants.* FROM restaurant_cuisines INNER JOIN restaurants ON restaurants.r_id=restaurant_cuisines.r_id INNER JOIN branches ON branches.r_id=restaurants.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND  restaurant_cuisines.c_id='$id' AND restaurants.status='1';";
        $res = $this->db->query($query);
        return $res->num_rows();
    }
   
    function getCuisineRestaurants($id,$latitude,$longitude,$radius)
    {
        $query = "SELECT restaurants.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM restaurant_cuisines INNER JOIN restaurants ON restaurants.r_id=restaurant_cuisines.r_id WHERE restaurant_cuisines.c_id='$id' AND restaurants.status='1' HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
   
    function getCuisineBranches($id,$latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT branches.b_id as branch_id,branches.r_id,branches.phone as rest_phone,branches.email as rest_email,branches.latitude,branches.longitude,branches.address as address1,branches.location as landmark,branches.city,branches.country,restaurants.rest_name,restaurants.cover_image,restaurants.rest_image,restaurants.thumbnail,restaurants.rest_image,restaurants.service_charge,restaurants.delivery_charge,restaurants.min_order,restaurants.open_time,restaurants.close_time, SQRT(POW(69.1 * (branches.latitude - $latitude), 2) +POW(69.1 * (branches.longitude - $longitude) * COS(branches.latitude / 57.3), 2)) AS distance FROM restaurant_cuisines INNER JOIN restaurants ON restaurants.r_id=restaurant_cuisines.r_id INNER JOIN branches ON branches.r_id=restaurant_cuisines.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND restaurant_cuisines.c_id='$id' AND restaurants.status='1' AND branches.status='1' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
  
    function getBestSellingProducts($id)
    {
        $this->db->select('COUNT(ordered_products.quantity) as total,products.p_id,products.r_id,products.name,products.cover_image,products.thumbnail,products.cat_id,products.description,products.ingredients,products.price,products.prep_time,products.status,products.size');
        $this->db->from('ordered_products');
        $this->db->join('orders','orders.order_id=ordered_products.order_id');
        $this->db->join('products','products.p_id=ordered_products.product_id');
        $this->db->join('menu','menu.menu_id=products.cat_id');
        $this->db->where('products.r_id',$id);
        $this->db->where('products.status','active');
        $this->db->where('menu.status','1');
        $this->db->group_by('ordered_products.product_id');
        $this->db->order_by('total', 'desc');
        return $this->db->get()->result();
    }
  
    public function checkProductOffer($product_id,$date)
    {
      $this->db->select('*');
      $this->db->from('offers');
      $this->db->where('product_id',$product_id);
      $this->db->where('start_date<=',$date);
      $this->db->where('end_date>=',$date);
      $this->db->where('status','1');
      $this->db->limit('1');
      return $this->db->get();
    }
    
    function getRatingSum($id)
    {
      $this->db->select('SUM(rating) as total');
      $this->db->from('restaurant_reviews');
      $this->db->where('r_id',$id);
      return $this->db->get()->row()->total;
    }
    
    function getBranchProducts($menu,$branch)
    {
        $this->db->select('products.*,branch_products.bp_id,branch_products.product_id');
        $this->db->from('branch_products');
        $this->db->join('products','products.p_id=branch_products.product_id');
        $this->db->join('menu','menu.menu_id=products.cat_id');
        $this->db->where('branch_products.branch_id',$branch);
        $this->db->where('branch_products.status','1');
        $this->db->where('products.status','active');
        $this->db->where('menu.status','1');
        $this->db->where('products.cat_id',$menu);
        $this->db->order_by('products.p_id','desc');
        return $this->db->get();
    }
    
    function searchRestaurant($keyword,$latitude,$longitude,$radius)
    {
        $query = "SELECT restaurants.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM restaurants WHERE status='1' AND restaurants.rest_name LIKE '%$keyword%' HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function searchBranches($keyword,$latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT branches.b_id as branch_id,branches.r_id,branches.phone as rest_phone,branches.email as rest_email,branches.latitude,branches.longitude,branches.address as address1,branches.location as landmark,branches.city,branches.country,restaurants.rest_name,restaurants.cover_image,restaurants.rest_image,restaurants.thumbnail,restaurants.rest_image,restaurants.service_charge,restaurants.min_order,restaurants.open_time,restaurants.close_time,restaurants.delivery_charge, SQRT(POW(69.1 * (branches.latitude - $latitude), 2) +POW(69.1 * (branches.longitude - $longitude) * COS(branches.latitude / 57.3), 2)) AS distance FROM branches INNER JOIN restaurants ON restaurants.r_id=branches.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND branches.status='1' AND restaurants.rest_name LIKE '$keyword%' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getSearchProductByKeyword($keyword,$latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT products.*, SQRT(POW(69.1 * (restaurants.latitude - $latitude), 2) +POW(69.1 * (restaurants.longitude - $longitude) * COS(restaurants.latitude / 57.3), 2)) AS distance FROM products INNER JOIN restaurants ON restaurants.r_id=products.r_id INNER JOIN branches ON branches.r_id=restaurants.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND  products.status='Active' AND restaurants.status='1' AND products.name LIKE '$keyword%' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getSearchProduct($latitude,$longitude,$radius)
    {
        $query = "SELECT products.*, SQRT(POW(69.1 * (restaurants.latitude - $latitude), 2) +POW(69.1 * (restaurants.longitude - $longitude) * COS(restaurants.latitude / 57.3), 2)) AS distance FROM products INNER JOIN restaurants ON restaurants.r_id=products.r_id WHERE products.status='Active' AND restaurants.status='1' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getRestProductsByMenu($menu)
    {
        $this->db->select('products.*');
        $this->db->from('products');
        $this->db->join('menu','menu.menu_id=products.cat_id');
        $this->db->where('menu.status','1');
        $this->db->where('products.status','active');
        $this->db->where('products.cat_id',$menu);
        $this->db->order_by('products.name','asc');
        return $this->db->get();
    }
    
    function getRestCategories($id)
    {
        $this->db->select('menu.*');
        $this->db->from('menu');
        $this->db->join('products','products.cat_id=menu.menu_id');
        $this->db->where('menu.status','1');
        $this->db->where('products.status','active');
        $this->db->where('menu.r_id',$id);
        $this->db->order_by('menu.name','asc');
        $this->db->group_by('products.cat_id');
        return $this->db->get();
    }
}

?>
