<?php

class M_ratings extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  
  public function getTotalRating($id)
  {
    $this->db->select('SUM(rating) as total');
    $this->db->from('restaurant_reviews');
    $this->db->where('r_id',$id);
    $result = $this->db->get();
    if($result->num_rows()>0)
    {
       return $result->row()->total;
    }
    else
    {
       return false;
    }
  }
  
  public function getOrderRating($id)
  {
    $this->db->select('SUM(order_packing) as total');
    $this->db->from('restaurant_reviews');
    $this->db->where('r_id',$id);
    $result = $this->db->get();
    if($result->num_rows()>0)
    {
       return $result->row()->total;
    }
    else
    {
       return false;
    }
  }
  
  public function getFoodRating($id)
  {
    $this->db->select('SUM(quality_of_food) as total');
    $this->db->from('restaurant_reviews');
    $this->db->where('r_id',$id);
    $result = $this->db->get();
    if($result->num_rows()>0)
    {
       return $result->row()->total;
    }
    else
    {
       return false;
    }
  }
  
  public function getDeliveryRating($id)
  {
    $this->db->select('SUM(delivery_time) as total');
    $this->db->from('restaurant_reviews');
    $this->db->where('r_id',$id);
    $result = $this->db->get();
    if($result->num_rows()>0)
    {
       return $result->row()->total;
    }
    else
    {
       return false;
    }
  }
  
  public function getValueRating($id)
  {
    $this->db->select('SUM(value_for_money) as total');
    $this->db->from('restaurant_reviews');
    $this->db->where('r_id',$id);
    $result = $this->db->get();
    if($result->num_rows()>0)
    {
       return $result->row()->total;
    }
    else
    {
       return false;
    }
  }
  
  public function getReviews($id)
  {
    $this->db->select('restaurant_reviews.*,users.firstname,users.lastname');
    $this->db->from('restaurant_reviews');
    $this->db->join('users','users.user_id=restaurant_reviews.user_id');
    $this->db->where('restaurant_reviews.r_id',$id);
    $this->db->order_by('restaurant_reviews.rr_id','desc');
    return $this->db->get()->result();
  }
  

}

?>
