<?php

class M_products extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
    function searchProduct($keyword,$rest_id)
    {
        $this->db->select('p_id,name,cover_image as image,price,description,size,thumbnail');
        $this->db->from('products');
        $this->db->where("name LIKE '%$keyword%'");
        $this->db->where('r_id',$rest_id);
        $this->db->where('status','active');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
    function getAllProducts($rest_id)
    {
        $this->db->select('p_id,name,cover_image as image,price,description,size,thumbnail');
        $this->db->from('products');
        $this->db->where('r_id',$rest_id);
        $this->db->where('status','active');
        // $this->db->limit(10);
        return $this->db->get()->result();
    }
    function getTypes($id)
    {
          $this->db->select('restaurant_styles.name');
          $this->db->from('restaurant_types');
          $this->db->join('restaurant_styles','restaurant_styles.rs_id=restaurant_types.rs_id');
          $this->db->where('restaurant_types.r_id',$id);
          return $this->db->get()->result();
    }
    function getDays($id)
    {
          $this->db->select('days.day');
          $this->db->from('product_days');
          $this->db->join('days','days.d_id=product_days.day_id');
          $this->db->where('product_days.p_id',$id);
          return $this->db->get()->result();
    }
    function getProductImages($id)
    {
          $this->db->select('image');
          $this->db->from('product_images');
          $this->db->where('p_id',$id);
          return $this->db->get()->result();
    }
    function getProductImage($id)
    {
          $this->db->select('image');
          $this->db->from('product_images');
          $this->db->where('p_id',$id);
          $this->db->limit(1);
          return $this->db->get()->row()->image;
    }
    function getExtras($id,$restaurant)
    {
          $this->db->select('*');
          $this->db->from('products');
          $this->db->group_start();
          $this->db->where('type','e');
          $this->db->or_where('type','a');
          $this->db->group_end();
          $this->db->where('p_id!=',$id);
          $this->db->where('r_id',$restaurant);
          $this->db->order_by('p_id','desc');
          return $this->db->get()->result();  
    }
  
    function cartCheck($id,$user)
    {
          $this->db->select('cart.*');
          $this->db->from('cart');
          $this->db->join('products','products.p_id=cart.product_id');
          $this->db->where('products.r_id!=',$id);
          $this->db->where('user_id',$user);
          $this->db->where('cart.type','p');
          return $this->db->get()->num_rows();
    }
  
    function restaurantCartCheck($id,$user,$branch)
    {
          $this->db->select('cart.*');
          $this->db->from('cart');
          $this->db->where('cart.r_id',$id);
          $this->db->where('cart.branch_id',$branch);
          $this->db->where('user_id',$user);
          return $this->db->get()->num_rows();
    }
    
    function restaurantGuestCartCheck($id,$user,$branch)
    {
          $this->db->select('guest_cart.*');
          $this->db->from('guest_cart');
          $this->db->where('guest_cart.r_id',$id);
          $this->db->where('guest_cart.branch_id',$branch);
          $this->db->where('guest_id',$user);
          return $this->db->get()->num_rows();
    }
  
//   function getProductExtras($id)
//   {
//       $this->db->select('products.*');
//       $this->db->from('product_extras');
//       $this->db->join('products','products.p_id=product_extras.extra_id');
//       $this->db->where('product_extras.product_id',$id);
//       return $this->db->get()->result();  
//   }

    function getProductExtras($id)
    {
          $this->db->select('extras.*');
          $this->db->from('product_extras');
          $this->db->join('extras','extras.extra_id=product_extras.extra_id');
          $this->db->where('product_extras.product_id',$id);
          return $this->db->get()->result();  
    }
  
    function get_smallest_price($id)
    {
        $this->db->select('MIN(price) as min_price');
        $this->db->from('product_price');
        $this->db->where('product_id',$id);
        return $this->db->get()->row()->min_price;
    }
  
    public function checkProductOffer($product_id,$date)
    {
          $this->db->select('*');
          $this->db->from('offers');
          $this->db->where('product_id',$product_id);
          $this->db->where('start_date<=',$date);
          $this->db->where('end_date>=',$date);
          $this->db->where('status','1');
          $this->db->limit('1');
          return $this->db->get();
    }
    
    function getCartProducts($user_id)
    {
        $this->db->select('cart.*');
        $this->db->from('cart');
        $this->db->join('products','products.p_id=cart.product_id');
        $this->db->join('menu','menu.menu_id=products.cat_id');
        $this->db->join('restaurants','restaurants.r_id=cart.r_id');
        $this->db->where('restaurants.status','1');
        $this->db->where('products.status','active');
        $this->db->where('menu.status','1');
        $this->db->where('cart.user_id',$user_id);
        $this->db->where('cart.type','p');
        $this->db->order_by('cart.cart_id','desc');
        return $this->db->get()->result();
    }
    
    function getCartExtras($user_id)
    {
        $this->db->select('cart.*');
        $this->db->from('cart');
        $this->db->join('extras','extras.extra_id=cart.product_id');
        $this->db->join('restaurants','restaurants.r_id=cart.r_id');
        $this->db->where('restaurants.status','1');
        $this->db->where('extras.status','1');
        $this->db->where('cart.user_id',$user_id);
        $this->db->where('cart.type','e');
        $this->db->order_by('cart.cart_id','desc');
        return $this->db->get()->result();
    }
    
    function getGuestCartProducts($user_id)
    {
        $this->db->select('guest_cart.*');
        $this->db->from('guest_cart');
        $this->db->join('products','products.p_id=guest_cart.product_id');
        $this->db->join('menu','menu.menu_id=products.cat_id');
        $this->db->join('restaurants','restaurants.r_id=guest_cart.r_id');
        $this->db->where('guest_cart.guest_id',$user_id);
        $this->db->where('restaurants.status','1');
        $this->db->where('products.status','active');
        $this->db->where('menu.status','1');
        $this->db->where('guest_cart.type','p');
        $this->db->order_by('guest_cart.gcart_id','desc');
        return $this->db->get()->result();
    }
    
    function getGuestCartExtras($user_id)
    {
        $this->db->select('guest_cart.*');
        $this->db->from('guest_cart');
        $this->db->join('extras','extras.extra_id=guest_cart.product_id');
        $this->db->join('restaurants','restaurants.r_id=guest_cart.r_id');
        $this->db->where('guest_cart.guest_id',$user_id);
        $this->db->where('restaurants.status','1');
        $this->db->where('extras.status','1');
        $this->db->where('guest_cart.type','e');
        $this->db->order_by('guest_cart.gcart_id','desc');
        return $this->db->get()->result();
    }
    
    function getCartCount($user_id)
    {
        $this->db->select('cart.*');
        $this->db->from('cart');
        if('cart.type==p')
        {
            $this->db->join('products','products.p_id=cart.product_id');
            $this->db->join('menu','menu.menu_id=products.cat_id');
            $this->db->where('products.status','active');
            $this->db->where('menu.status','1');
        }
        else
        {
            $this->db->join('extras','extras.extra_id=cart.product_id');
            $this->db->where('extras.status','1');
        }
        $this->db->join('restaurants','restaurants.r_id=cart.r_id');
        $this->db->where('cart.user_id',$user_id);
        $this->db->where('restaurants.status','1');
        $this->db->order_by('cart.cart_id','desc');
        return $this->db->get();
    }
    
    function getGuestCartCount($user_id)
    {
        $this->db->select('guest_cart.*');
        $this->db->from('guest_cart');
        if('guest_cart.type==p')
        {
            $this->db->join('products','products.p_id=guest_cart.product_id');
            $this->db->join('menu','menu.menu_id=products.cat_id');
            $this->db->where('products.status','active');
            $this->db->where('menu.status','1');
        }
        else
        {
            $this->db->join('extras','extras.extra_id=guest_cart.product_id');
            $this->db->where('extras.status','1');
        }
        $this->db->join('restaurants','restaurants.r_id=guest_cart.r_id');
        $this->db->where('guest_cart.guest_id',$user_id);
        $this->db->where('restaurants.status','1');
        $this->db->order_by('guest_cart.gcart_id','desc');
        return $this->db->get();
    }
}

?>
