<?php

class M_orders extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
   function getCartData($id)
   {
     $this->db->select('products.*,cart.quantity,cart.cart_id');
     $this->db->from('cart');
     $this->db->join('products','products.p_id=cart.product_id');
     $this->db->order_by('cart.cart_id',"desc");
     $this->db->where('cart.user_id',$id);
     return $this->db->get()->result();
   }
   
   function getGuestCartData($id)
   {
     $this->db->select('products.*,guest_cart.quantity,guest_cart.gcart_id');
     $this->db->from('guest_cart');
     $this->db->join('products','products.p_id=guest_cart.product_id');
     $this->db->order_by('guest_cart.gcart_id',"desc");
     $this->db->where('guest_cart.guest_id',$id);
     return $this->db->get()->result();
   }
  
   function getOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','user');
      $this->db->where('status!=','requested');
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
   
   function getGuestOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','guest');
      $this->db->where('status!=','requested');
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
  
   function getExtras($id)
   {
      $this->db->select('*');
      $this->db->from('extras');
      $this->db->where('r_id',$id);
      $this->db->where('status','1');
      $this->db->order_by('extra_id','desc');
      return $this->db->get()->result();
   }
   
   function getDriverLocation($id)
   {
      $this->db->select('*');
      $this->db->from('locations');
      $this->db->where('driver_id',$id);
      $this->db->order_by('location_id','desc');
      $this->db->limit('1');
      return $this->db->get()->row();
   }
   function getDraftOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','user');
      $this->db->group_start();
      $this->db->where('status','pending');
      $this->db->or_where('status','processing');
      $this->db->or_where('status','approved');  
      $this->db->or_where('status','dispatched');
      $this->db->group_end();
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
   function getGuestDraftOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','guest');
      $this->db->group_start();
      $this->db->where('status','pending');
      $this->db->or_where('status','processing');
      $this->db->or_where('status','approved');  
      $this->db->or_where('status','dispatched');
      $this->db->group_end();
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
   function getCompletedOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','user');
      $this->db->where('status','delivered');
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
   function getGuestCompletedOrders($id)
   {
      $this->db->select('*');
      $this->db->from('orders');
      $this->db->where('user_id',$id);
      $this->db->where('type','guest');
      $this->db->where('status','delivered');
      $this->db->order_by('order_id','desc');
      return $this->db->get()->result();
   }
  
}

?>
