<?php
class M_offers extends CI_Model
{
    function getCoupons($latitude,$longitude,$block_id)
    {
        date_default_timezone_set('Asia/Bahrain');
        $current    = date('Y-m-d H:i:s');
        $date       = date('Y-m-d');
        $time       = date('h:i:s');
        
        $query = "SELECT coupons.*,branches.b_id as branch_id,branches.latitude,branches.longitude, SQRT(POW(69.1 * (branches.latitude - '$latitude'), 2) +POW(69.1 * (branches.longitude - '$longitude') * COS(branches.latitude / 57.3), 2)) AS distance FROM coupons INNER JOIN restaurants ON restaurants.r_id=coupons.r_id INNER JOIN branches ON branches.r_id=restaurants.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND restaurants.status='1' AND branches.status='1' AND coupons.status='1' AND coupons.offer_starts<='$current' AND coupons.offer_ends>='$current' GROUP BY branches.r_id ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getPromotions($latitude,$longitude,$block_id)
    {
        date_default_timezone_set('Asia/Bahrain');
        $current    = date('Y-m-d H:i:s');
        $date       = date('Y-m-d');
        $time       = date('h:i:s');
        
        $query = "SELECT promotions.*,branches.b_id as branch_id,branches.latitude,branches.longitude, SQRT(POW(69.1 * (branches.latitude - '$latitude'), 2) +POW(69.1 * (branches.longitude - '$longitude') * COS(branches.latitude / 57.3), 2)) AS distance FROM promotions INNER JOIN restaurants ON restaurants.r_id=promotions.r_id INNER JOIN branches ON branches.r_id=restaurants.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND restaurants.status='1' AND branches.status='1' AND promotions.status='active' AND promotions.start_date<='$current' AND promotions.end_date>='$current' GROUP BY branches.r_id ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getCoupons1($block_id)
    {
        date_default_timezone_set('Asia/Bahrain');
        $current    = date('Y-m-d H:i:s');
        $date       = date('Y-m-d');
        $time       = date('h:i:s');
    	    
        $this->db->select('coupons.*');
        $this->db->from('coupons');
        $this->db->join('restaurants','restaurants.r_id=coupons.r_id');
        $this->db->join('branches','branches.r_id=restaurants.r_id');
        $this->db->join('branch_delivery_blocks','branch_delivery_blocks.branch_id=branches.b_id');
        $this->db->where('coupons.status','1');
        $this->db->where('restaurants.status','1');
        $this->db->where('branches.status','1');
        $this->db->where('branch_delivery_blocks.block_id',$block_id);
        $this->db->where('coupons.offer_starts<=',$current);
        $this->db->where('coupons.offer_ends>=',$current);
        $this->db->order_by('coupons.c_id','desc');
        return $this->db->get()->result();
    }
    
    function getPromotions1($block_id)
    {
        date_default_timezone_set('Asia/Bahrain');
        $current    = date('Y-m-d H:i:s');
        $date       = date('Y-m-d');
        $time       = date('h:i:s');
        
        $this->db->select('promotions.*');
        $this->db->from('promotions');
        $this->db->join('restaurants','restaurants.r_id=promotions.r_id');
        $this->db->join('branches','branches.r_id=restaurants.r_id');
        $this->db->join('branch_delivery_blocks','branch_delivery_blocks.branch_id=branches.b_id');
        $this->db->where('promotions.status','active');
        $this->db->where('restaurants.status','1');
        $this->db->where('branches.status','1');
        $this->db->where('branch_delivery_blocks.block_id',$block_id);
        $this->db->where('promotions.start_date<=',$date);
        $this->db->where('promotions.end_date>=',$date);
        $this->db->order_by('promotions.pr_id','desc');
        return $this->db->get()->result();
    }
}

?>
