<?php

class M_home extends CI_Model
{
    function __construct()
    {
       $this->load->database();
    }
  
    function getDetails()
    {
        $this->db->select('*');
        $this->db->from('home_section');
        $this->db->where('status','1');
        $this->db->order_by('hs_id','desc');
        return $this->db->get()->result();
    }
    
    function getCuisines()
    {
        $this->db->select('*');
        $this->db->from('cuisines');
        $this->db->where('status','1');
        $this->db->order_by('name','asc');
        return $this->db->get()->result();
    }
    
    function getRatingSum($id)
    {
        $this->db->select('SUM(rating) as total');
        $this->db->from('restaurant_reviews');
        $this->db->where('r_id',$id);
        return $this->db->get()->row()->total;
    }
    
    function getRestaurants($id,$latitude,$longitude,$radius)
    {
        $query = "SELECT restaurant_cuisines.r_id, SQRT(POW(69.1 * (latitude - '$latitude'), 2) +POW(69.1 * (longitude - '$longitude') * COS(latitude / 57.3), 2)) AS distance FROM section_cuisines INNER JOIN restaurant_cuisines ON restaurant_cuisines.c_id=section_cuisines.c_id INNER JOIN restaurants ON restaurants.r_id=restaurant_cuisines.r_id WHERE section_cuisines.hs_id='$id' AND restaurants.status='1' GROUP BY restaurant_cuisines.r_id HAVING distance < '$radius' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getBranches($id,$latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT restaurant_cuisines.r_id,branches.b_id as branch_id,branches.latitude,branches.longitude, SQRT(POW(69.1 * (branches.latitude - '$latitude'), 2) +POW(69.1 * (branches.longitude - '$longitude') * COS(branches.latitude / 57.3), 2)) AS distance FROM section_cuisines INNER JOIN restaurant_cuisines ON restaurant_cuisines.c_id=section_cuisines.c_id INNER JOIN restaurants ON restaurants.r_id=restaurant_cuisines.r_id INNER JOIN branches ON branches.r_id=restaurant_cuisines.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND section_cuisines.hs_id='$id' AND restaurants.status='1' AND branches.status='1' GROUP BY restaurant_cuisines.r_id ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }

    function getAllRestaurants($latitude,$longitude,$radius)
    {
        $query = "SELECT restaurants.r_id, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM restaurants  WHERE restaurants.status='1' HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getAllBranches($latitude,$longitude,$radius,$block_id)
    {
        $query = "SELECT restaurants.r_id,branches.b_id as branch_id,branches.latitude,branches.longitude, SQRT(POW(69.1 * (branches.latitude - '$latitude'), 2) +POW(69.1 * (branches.longitude - '$longitude') * COS(branches.latitude / 57.3), 2)) AS distance FROM restaurants INNER JOIN branches ON branches.r_id=restaurants.r_id INNER JOIN branch_delivery_blocks ON branch_delivery_blocks.branch_id=branches.b_id WHERE branch_delivery_blocks.block_id='$block_id' AND restaurants.status='1' AND branches.status='1' GROUP BY branches.r_id ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
  
    function getCoupons($id)
    {
        date_default_timezone_set('Asia/Bahrain');
	    $current    = date('Y-m-d H:i:s');
	    $date       = date('Y-m-d');
	    $time       = date('h:i:s');
	    
        $this->db->select('*');
        $this->db->from('coupons');
        $this->db->where('status','1');
        $this->db->where('r_id',$id);
        $this->db->where('offer_starts<=',$current);
        $this->db->where('offer_ends>=',$current);
        $this->db->order_by('c_id','desc');
        return $this->db->get()->result();
    }
    
    function getPromotions($id)
    {
        date_default_timezone_set('Asia/Bahrain');
	    $current    = date('Y-m-d H:i:s');
	    $date       = date('Y-m-d');
	    $time       = date('h:i:s');
	    
        $this->db->select('*');
        $this->db->from('promotions');
        $this->db->where('status','active');
        $this->db->where('r_id',$id);
        $this->db->where('start_date<=',$date);
        $this->db->where('end_date>=',$date);
        $this->db->order_by('pr_id','desc');
        return $this->db->get()->result();
    }
  
    function getOrderStatus($id)
    {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('user_id',$id);
        $this->db->order_by('order_id','desc');
        $this->db->limit('1');
        return $this->db->get()->row();
    }
  
    function getAdvertisement($city)
    {
        $date   = date('Y-m-d');
        $this->db->select('*');
        $this->db->from('popup');
        $this->db->where('status','1');
        $this->db->where('start_date<=',$date);
        $this->db->where('end_date>=',$date);
        $this->db->where('city',$city);
        $this->db->order_by('pop_id','desc');
        $this->db->limit('1');
        return $this->db->get();
    }
   
    function getRestaurantSliders($latitude,$longitude,$radius)
    {
        $query = "SELECT banners.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM banners INNER JOIN restaurants ON restaurants.r_id=banners.r_id WHERE banners.status='1' HAVING distance < $radius ORDER BY distance;";
        $res   = $this->db->query($query);
        return $res->result();
    }
   
    function getBranchSliders($latitude,$longitude,$radius)
    {
        $query = "SELECT banners.*,branches.b_id as branch_id, SQRT(POW(69.1 * (branches.latitude - $latitude), 2) +POW(69.1 * (branches.longitude - $longitude) * COS(branches.latitude / 57.3), 2)) AS distance FROM banners INNER JOIN branches ON branches.r_id=banners.r_id WHERE banners.status='1' HAVING distance < $radius ORDER BY distance;";
        $res   = $this->db->query($query);
        return $res->result();
    }
   
}

?>
