<?php

class M_footer extends CI_Model
{
    function __construct()
    {
       $this->load->database();
    }
  
    function getRestaurants()
    {
        $this->db->select('restaurants.rest_name,r_id');
        $this->db->from('restaurants');
        $this->db->where('status','1');
        return $this->db->get();
    }
    function getOrderNo($r_id)
    {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('r_id',$r_id);
        return $this->db->get()->num_rows();
    }
    function getCuisines()
    {
        $this->db->select('cuisines.name');
        $this->db->from('restaurant_cuisines');
        $this->db->join('cuisines','cuisines.c_id=restaurant_cuisines.c_id');        
        $this->db->where('cuisines.status','1');
        $this->db->order_by('cuisines.c_id','desc');
        $this->db->distinct('cuisines.c_id');
        return $this->db->get();
    }
    function getAreas()
    {
        $this->db->select('branches.city');
        $this->db->from('orders');
        $this->db->join('branches','branches.b_id=orders.branch_id');        
        $this->db->where('branches.status','1');
        $this->db->order_by('branches.b_id','desc');
        $this->db->distinct('branches.b_id');
        return $this->db->get();
    }
    function getSocialMedia()
    {
        $this->db->select('*');
        $this->db->from('social_media');
        return $this->db->get()->result();
    }
}

?>