<?php

class M_address extends CI_Model
{
    function getAddress($id)
    {
        $this->db->select('*');
        $this->db->from('address');
        $this->db->where('user_id',$id);
        $this->db->where('status','1');
        $this->db->order_by('address_id','desc');
        return $this->db->get()->result();
    }
    
    function getGuestAddress($id)
    {
        $this->db->select('*');
        $this->db->from('guest_address');
        $this->db->where('guest_id',$id);
        $this->db->order_by('ga_id','desc');
        return $this->db->get()->result();
    }
    
    function getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id)
    {
        $query = "SELECT branches.r_id, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM branches  WHERE status = '1' AND branches.b_id='$branch_id'  HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->num_rows();
    }
    
    function getShopsDelivery($latitude,$longitude,$radius,$restaurant_id)
    {
        $query = "SELECT restaurants.r_id, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM restaurants  WHERE status = '1' AND restaurants.r_id='$restaurant_id'  HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->num_rows();
    }
    
    function getDeliveryAddress($latitude,$longitude,$radius,$user_id)
    {
        $query = "SELECT address.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM address  WHERE status = '1' AND address.user_id='$user_id'  HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
    
    function getGuestDeliveryAddress($latitude,$longitude,$radius,$user_id)
    {
        $query = "SELECT guest_address.*, SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM guest_address  WHERE guest_address.guest_id='$user_id'  HAVING distance < $radius ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    }
}

?>
