<?php

class M_restaurants extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function make_query(){
    $table = "restaurants";
    $select_column = array("r_id","rest_name","rest_code","rest_email","rest_phone","open_time","close_time","address1","address2","address3","pincode","country","pincode","state","city","landmark","url","status","thumbnail");
    $order_column = array(null,"rest_name","rest_email","rest_phone",null,null,null,null,null,null,null,null,null,null,null,null,null);

    $this->db->select($select_column);
    $this->db->from($table);
    if (isset($_POST["search"]["value"])) 
    {
      $this->db->like("rest_name",$_POST["search"]["value"]);
      $this->db->or_like("rest_code",$_POST["search"]["value"]);
      $this->db->or_like("rest_email",$_POST["search"]["value"]);
      $this->db->or_like("rest_phone",$_POST["search"]["value"]);
    }
    if (isset($_POST["order"])) {
      $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
    }
    else {
      $this->db->order_by("r_id","desc");
    }
  }
  function make_datatables()
  {
    $this->make_query();
    if ($_POST["length"] != -1) {
      $this->db->limit($_POST["length"],$_POST["start"]);
    }
    $query = $this->db->get();
    return $query->result();
  }
  function get_filtered_data()
  {
    $this->make_query();
    $query = $this->db->get();
    return $query->num_rows();
  }
  function get_all_data()
  {
    $this->db->select("*");
    $this->db->from("restaurants");
    return $this->db->count_all_results();
  }
}

?>
