<?php

class M_reports extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
    function getReports($start_date,$end_date,$shop_id)
    {
        $this->db->select('*');
        $this->db->from('orders');
        if($shop_id!='all')
        {
         $this->db->where('r_id',$shop_id);
        } 
        $this->db->where('completed_date>=',$start_date);
        $this->db->where('completed_date<=',$end_date);
        $this->db->where('status','delivered');
        $this->db->order_by('order_id','desc');
        return $this->db->get()->result();
    }
    
    function getDailyReports($start_date,$shop_id)
    {
        $this->db->select('*');
        $this->db->from('orders');
        if($shop_id!='all')
        {
         $this->db->where('r_id',$shop_id);
        } 
        $this->db->where('completed_date',$start_date);
        $this->db->where('status','delivered');
        $this->db->order_by('order_id','desc');
        return $this->db->get()->result();
    }
    
    function getMenuReports($start_date,$end_date,$shop_id)
    {
        $this->db->select('ordered_products.product_id,SUM(ordered_products.quantity) as product_conut,SUM(ordered_products.total) as product_price,orders.r_id');
        $this->db->from('ordered_products');
        $this->db->join('orders','orders.order_id=ordered_products.order_id');
        if($shop_id!='all')
        {
         $this->db->where('orders.r_id',$shop_id);
        } 
        $this->db->where('orders.completed_date>=',$start_date);
        $this->db->where('orders.completed_date<=',$end_date);
        $this->db->where('orders.status','delivered');
        $this->db->group_by('ordered_products.product_id');
        $this->db->order_by('orders.order_id','desc');
        return $this->db->get()->result();
    }
    
}

?>
