<?php

class M_reasons extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function make_query(){
    $table = "cancel_reasons";
    $select_column = array("cr_id","reason_for","reason","status");
    $order_column = array(null,"reason_for","reason","status");

    $this->db->select($select_column);
    $this->db->from($table);
    if (isset($_POST["search"]["value"])) 
    {
      $this->db->like("reason_for",$_POST["search"]["value"]);
      $this->db->or_like("reason",$_POST["search"]["value"]);
    }
    if (isset($_POST["order"])) {
      $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
    }
    else {
      $this->db->order_by("cr_id","desc");
    }
  }
  function make_datatables()
  {
    $this->make_query();
    if ($_POST["length"] != -1) {
      $this->db->limit($_POST["length"],$_POST["start"]);
    }
    $query = $this->db->get();
    return $query->result();
  }
  function get_filtered_data()
  {
    $this->make_query();
    $query = $this->db->get();
    return $query->num_rows();
  }
  function getCancelReasons()
  {
    $this->db->select('*');
    $this->db->from('cancel_reasons');
    $this->db->order_by('cr_id','desc');
    return $this->db->get()->result();
  }
}

?>
