<?php

class M_orders extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function getNewOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','pending');
    $this->db->where('order_type!=','scheduled');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }
  function getScheduledOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','pending');
    $this->db->where('order_type','scheduled');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }
  function getApprovedOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','approved');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }
  function getActiveOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','processing');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }

  function getCompletedOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','delivered');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }

  function getCancelledOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','cancelled');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }
  
  function getDispatchedOrders()
  {
    $this->db->select('*');
    $this->db->from('orders');
    $this->db->where('status','cancelled');
    $this->db->order_by('order_id','desc');
    $result=$this->db->get();
    return $result->result();
  }
 
//********************************************** NEW **************************************************************************************************************//
    function make_new_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_new_datatables()
    {
        $this->make_new_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_new_filtered_data()
    {
        $this->make_new_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_new_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        return $this->db->count_all_results();
    } 
    
//*************************************************** SCHEDULED ***************************************************************************************************//
    function make_scheduled_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type","delivery_date","delivery_time");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','pending');
        $this->db->where('order_type','scheduled');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_scheduled_datatables()
    {
        $this->make_scheduled_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_scheduled_filtered_data()
    {
        $this->make_scheduled_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_scheduled_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        return $this->db->count_all_results();
    } 
    
//******************************************************** APPROVED ************************************************************************************************//
    function make_approved_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','approved');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_approved_datatables()
    {
        $this->make_approved_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_approved_filtered_data()
    {
        $this->make_approved_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_approved_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','approved');
        return $this->db->count_all_results();
    }
    
//***************************************************** ACTIVE *****************************************************************************************************//
    function make_active_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','processing');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_active_datatables()
    {
        $this->make_active_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_active_filtered_data()
    {
        $this->make_active_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_active_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','processing');
        return $this->db->count_all_results();
    }
    
//*********************************************************** DISPATCHED ******************************************************************************************//
    function make_dispatched_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','dispatched');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_dispatched_datatables()
    {
        $this->make_dispatched_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_dispatched_filtered_data()
    {
        $this->make_dispatched_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_dispatched_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','dispatched');
        return $this->db->count_all_results();
    }
    
//********************************************** COMPLETED ****************************************************************************************************************//
    function make_completed_query()
    {
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','delivered');
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_completed_datatables()
    {
        $this->make_completed_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_completed_filtered_data()
    {
        $this->make_completed_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_completed_all_data()
    {
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','delivered');
        return $this->db->count_all_results();
    }    
  
}

?>
