<?php

class M_drivers extends CI_Model
{
    function __construct()
    {
        $this->load->database();
    }
    
    function getDrivers()
    {
        $this->db->select("*");
        $this->db->from("drivers");
        $this->db->where('status!=','3');
        $this->db->order_by('dr_id','desc');
        return $this->db->get()->result();
    }
    
    function make_query()
    {
        $table = "drivers";
        $select_column = array("dr_id","name","email","phone","country","pincode","state","city","status","vehicle_number","jrms_code");
        $order_column = array(null,"name","email","phone",null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status!=',3);
        
        if (isset($_POST["search"]["value"])) 
        {
          $this->db->like("name",$_POST["search"]["value"]);
          $this->db->or_like("email",$_POST["search"]["value"]);
          $this->db->or_like("phone",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("dr_id","desc");
        }
    }
    function make_datatables()
    {
        $this->make_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_filtered_data()
    {
        $this->make_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_all_data()
    {
        $this->db->select("*");
        $this->db->from("drivers");
        $this->db->where('status!=','3');
        return $this->db->count_all_results();
    }
}

?>
