<?php

class M_dashboard extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }

    function getUsers()
    {
        $this->db->select("firstname,lastname,email,mobile,date,timestamp");
        $this->db->from('users');
        $this->db->where('status','1');
        $this->db->limit(6);
        $this->db->order_by('user_id','desc');
        return $this->db->get()->result();
    }

    function getRestaurants()
    {
        $this->db->select("rest_name,cover_image,rest_email,rest_phone");
        $this->db->from('restaurants');
        $this->db->where('status','1');
        $this->db->limit(6);
        $this->db->order_by('r_id','desc');
        return $this->db->get()->result();
    }

    function getCuisines()
    {
        $this->db->select("name");
        $this->db->from('cuisines');
        $this->db->where('status','1');
        $this->db->limit(10);
        $this->db->order_by('c_id','desc');
        return $this->db->get()->result();
    }
  
    function getOrders()
    {
        $this->db->select("orders.*,restaurants.rest_name,users.firstname,users.lastname");
        $this->db->from('orders');
        $this->db->join('restaurants','restaurants.r_id=orders.r_id');
        $this->db->join('users','users.user_id=orders.user_id');
        $this->db->limit(7);
        $this->db->order_by('orders.order_id','desc');
        return $this->db->get()->result();
    }

    function getOrderCount()
    {
        $this->db->select("*");
        $this->db->from('orders');
        $this->db->where('MONTH(ordered_date)', date('m')); //For current month
        $this->db->where('YEAR(ordered_date)', date('Y')); // For current year
        return $this->db->get()->num_rows();
    }
  
    function getTodaysOrderCount($date)
    {
        $this->db->select("*");
        $this->db->from('orders');
        $this->db->where('ordered_date',$date);
        return $this->db->get()->num_rows();
    }
  
   function getTodaysCancelledOrderCount($date)
   {
        $this->db->select("*");
        $this->db->from('orders');
        $this->db->where('cancelled_date',$date);
        return $this->db->get()->num_rows();
   }
  
}

?>
