<?php

class M_advertisement extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function make_query(){
    $table = "popup";
    $select_column = array("pop_id","title","image","city","place_id","start_date","end_date","status");
    $order_column = array(null,"title",null,null,null,null);

    $this->db->select($select_column);
    $this->db->from($table);
    if (isset($_POST["search"]["value"])) {
      $this->db->like("title",$_POST["search"]["value"]);
    }
    if (isset($_POST["order"])) {
      $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
    }
    else {
      $this->db->order_by("pop_id","desc");
    }
  }
  function make_datatables()
  {
    $this->make_query();
    if ($_POST["length"] != -1) {
      $this->db->limit($_POST["length"],$_POST["start"]);
    }
    $query = $this->db->get();
    return $query->result();
  }
  function get_filtered_data()
  {
    $this->make_query();
    $query = $this->db->get();
    return $query->num_rows();
  }
  function get_all_data()
  {
    $this->db->select("*");
    $this->db->from("popup");
    return $this->db->count_all_results();
  }

  function checkStart($place,$start)
  {
    $this->db->select('*');
    $this->db->from('popup');
    $this->db->where('place_id',$place);
    $this->db->where('end_date>=',$start);
    $this->db->order_by('pop_id','desc');
    return $this->db->get();
  }

  function checkById($place,$adv,$start)
  {
    $this->db->select('*');
    $this->db->from('popup');
    $this->db->where('place_id',$place);
    $this->db->where('pop_id!=',$adv);
    $this->db->where('end_date>=',$start);
    $this->db->order_by('pop_id','desc');
    return $this->db->get();
  }
}

?>
