<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Styles extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model('restaurant/Model_styles', 'style');
        if (!restaurant()) {
            redirect('users/restaurant');
        }
    }
    public function index() {
        $restaurant = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        $styles = $this->style->getStyles($restaurant_id);
		foreach ($styles as $style) {
			$style->status = $this->style->check($style->rs_id,$restaurant_id);
		}
        $data['rest_styles'] = $this->style->getRestaurantStyles($restaurant_id);
		$data['styles'] = $styles;
        $this->load->view('restaurant/styles/view', $data);
    }
    public function addData() {
        $restaurant = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        $styles = $this->input->post('styles');
        foreach ($styles as $style) {
            $check = $this->style->get_details('restaurant_types', array('rs_id' => $style, 'r_id' => $restaurant_id))->num_rows();
            if ($check > 0) {
                $this->style->delete('restaurant_types', array('rs_id' => $style, 'r_id' => $restaurant_id));
                $array = ['r_id' => $restaurant_id, 'rs_id' => $style];
                $this->style->insert('restaurant_types', $array);
            } else {
                $array = ['r_id' => $restaurant_id, 'rs_id' => $style];
                $this->style->insert('restaurant_types', $array);
            }
        }
        $this->session->set_flashdata('alert_type', 'success');
        $this->session->set_flashdata('alert_title', 'Success');
        $this->session->set_flashdata('alert_message', 'New restaurant style added..!');
        redirect('restaurant/styles');
    }
    public function delete($id) {
        $restaurant = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        if ($this->style->delete('restaurant_types', array('r_id' => $restaurant_id, 'rs_id' => $id))) {
            $this->session->set_flashdata('alert_type', 'success');
            $this->session->set_flashdata('alert_title', 'Success');
            $this->session->set_flashdata('alert_message', 'Restaurant style removed successfully..');
            redirect('restaurant/styles');
        } else {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Failed to remove restaurant style..!');
            redirect('restaurant/styles');
        }
    }
}
?>
