<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restaurant_styles extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_styles','styles');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function getRestaurantStyles()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$styles          = $this->styles->getRestStyles($restaurant_id);
		foreach($styles as $st)
		{
			$st->name   = $this->Common->get_details('restaurant_styles',array('rs_id'=>$st->rs_id))->row()->name;
		}
		$data['styles']  = $styles;

		$types           = $this->styles->getRestTypes();
		foreach($types as $type)
		{   
			$stat_check  = $this->styles->getRestTypeStat($type->rs_id,$restaurant_id);
			if($stat_check>0)
			{
				$type->stat  = '1';
			}
			else
			{
				$type->stat  = '0';
			}
		}
		$data['types']  = $types;
		$this->load->view('restaurant/restaurant_styles/view',$data);
	}
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('restaurant_styles',array('rs_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$styles      = $this->input->post('styles');
		
		
            foreach($styles as $style)
			{ 
			   $check         = $this->Common->get_details('restaurant_types',array('rs_id' => $style,'r_id'=>$restaurant_id))->num_rows();
			   if ($check > 0) 
		       {	
				   $this->Common->delete('restaurant_types',array('rs_id' => $style,'r_id'=>$restaurant_id));
					$array = [
					           'r_id'  => $restaurant_id,
					           'rs_id' => $style
				             ];
					$this->Common->insert('restaurant_types',$array);
			    }
			    else
			    {
			    	$array  = [
				             'r_id'  => $restaurant_id,
				             'rs_id' => $style
			              ];
			        $this->Common->insert('restaurant_types',$array);
			    }		
			}

			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'New restaurant style added..!');
			redirect('restaurant/restaurant_styles/getRestaurantStyles');
			// print_r($styles);
	}
	
	public function delete($id)
	{  
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		if($this->Common->delete('restaurant_types',array('r_id'=>$restaurant_id,'rs_id'=>$id)))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Restaurant style removed successfully..');
			redirect('restaurant/restaurant_styles/getRestaurantStyles');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove restaurant style..!');
			redirect('admin/restaurants/getRestaurantStyles');
	    }		
	}
}
?>
