<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Promotions extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('restaurant/M_promotion','promo');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	
  	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$promotions    = $this->promo->getPromotions($restaurant_id);
		foreach($promotions as $pro)
		{
			$pro->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$pro->r_id))->row()->rest_name;
		}
		$data['promotions'] = $promotions;

		$this->load->view('restaurant/promotions/view',$data);
	}

    public function add()
    {
        $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		
		$data['category'] = $this->Common->get_details('promotion_category',array('r_id'=>$restaurant_id,'status'=>'1'))->result();
		$data['products'] = $this->promo->getProducts($restaurant_id);
		
		$this->load->view('restaurant/promotions/add',$data);
    }
    
    public function edit($id)
	{
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		
		$promotion          = $this->Common->get_details('promotions',array('pr_id'=>$id))->row();
		$promotion_category = $this->Common->get_details('promotion_selection_list',array('promo_id'=>$id,'status'=>'1'))->result();
		foreach($promotion_category as $cat)
		{   
		    $cat_details    = $this->Common->get_details('promotion_category',array('pcat_id'=>$cat->cat_id))->row();
		    if($cat_details){
		        $cat->name      = $cat_details->cat_name;
		    } else {
		        $cat->name      = '';
		    }		    
		    $cat->products  = $this->Common->get_details('promotion_products',array('cat_id'=>$cat->cat_id,'promo_id'=>$id,'status'=>'1'))->result();
		    foreach($cat->products as $product)
		    {
		        $product_details  = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
		        $product->item_code= $product_details->item_code;
		        $price            = $this->Common->get_details('product_price',array('price_id'=>$product->price_id))->row();
		        if($price->unit!=='')
		        {
		            $product->name    = $product_details->name.' - '.$price->unit;
		        }
		        else
		        {
		            $product->name    = $product_details->name;
		        }
		        $product->price       = $price->price;
		    }
		}
		$data['promotion']  = $promotion;
		$data['promotion_category'] = $promotion_category;
		$data['categories'] = $this->Common->get_details('promotion_category',array('r_id'=>$restaurant_id,'status'=>'1'))->result();
		$data['products']   = $this->promo->getProducts($restaurant_id);
		
	   $this->load->view('restaurant/promotions/edit',$data);
	}

	public function addData()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp    = date('Y-m-d H:i:s');
	    
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$name          = $this->security->xss_clean($this->input->post('name'));
		$code          = $this->security->xss_clean($this->input->post('code'));
		$description   = $this->security->xss_clean($this->input->post('description'));
		$price         = $this->security->xss_clean($this->input->post('price'));
		$start         = $this->security->xss_clean($this->input->post('start_date'));
		$end           = $this->security->xss_clean($this->input->post('end_date'));

		if(isset($_POST['values']))
		{
    		$image1       = $this->input->post('image');
            if($image1!='')
            {
                $img1       = substr($image1, strpos($image1, ",") + 1);
        		$url1       = FCPATH.'uploads/restaurant/promotion';
        		$rand11     = date('Ymd').mt_rand(1001,9999);
        		$userpath1  = $url1.$rand11.'.png';
        		$path1      = "uploads/restaurant/promotion".$rand11.'.png';
        		if(file_put_contents($userpath1,base64_decode($img1)))
    			{
    			    $filename = 'uploads/restaurant/promotion/thumbnail/'.$rand11.'thumb.png'; // output file name
                    $fileData = base64_decode($img1);
                    $im = imagecreatefromstring($fileData);
                    $source_width = imagesx($im);
                    $source_height = imagesy($im);
                    $ratio =  $source_height / $source_width;
                    
                    $new_width  = 300; // assign new width to new resized image
                    $new_height = 300*$ratio;
                    
                    $thumb = imagecreatetruecolor($new_width, $new_height);
                    
                    $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                    imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                    
                    imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                    imagepng($thumb, $filename, 9);
                    imagedestroy($im);
    			}
    			else
    			{
    			    $filename = '';
    			}
            }
    		else
    		{
    		    $path1      = '';
    		}
    		
    		$values        = $_POST['values'];
            $count        = sizeof($values);
    		if($count==0)
    		{
    		    $this->session->set_flashdata('alert_type', 'error');
    			$this->session->set_flashdata('alert_title', 'Failed');
    			$this->session->set_flashdata('alert_message', 'Please select products..!');
    			redirect('restaurant/promotions/add');
    		}
    		else
    		{
        		$check      = $this->Common->get_details('promotions',array('code'=>$code));
        		if ($check->num_rows()> 0) 
        		{
        			$this->session->set_flashdata('alert_type', 'error');
        			$this->session->set_flashdata('alert_title', 'Failed');
        			$this->session->set_flashdata('alert_message', 'Promotion Code already exists..!');
        			redirect('restaurant/promotions/add');
        		}
        		else
        		{   
        			$array = [
        				         'r_id'        => $restaurant_id,
        						 'code'        => $code,
        						 'title'       => $name,
        						 'description' => $description,
        						 'price'       => $price,
        						 'image'       => $path1,
        						 'thumbnail'   => $filename,
        						 'start_date'  => $start,
            					  'end_date'    => $end,
        						 'added_date'  => date('Y-m-d'),
        						 'timestamp'   => date('Y-m-d H:i:s')
        					 ];
        			if ($id=$this->Common->insert('promotions',$array))
        			{
                        for ($i=1;$i <=$count; $i++) 
                        {
                          $cat_ids    = $_POST['cat_id'.$i];
                          $quantity   = $_POST['quantity'.$i];
                          $products   = $_POST['products'.$i];
                          $j=0;
                          foreach($cat_ids as $cat)
                          {
                              $cat_array = [   
                                              'promo_id'       => $id,
                                              'cat_id'         => $cat,
                                              'quantity'       => $quantity[$j],
                		                      'date'           => date('Y-m-d')
                                          ];
            
                              if($c_id = $this->Common->insert('promotion_selection_list',$cat_array))
                              {
                                  $k=0;
                                  foreach($products as $pr)
                                  {
                                      $product_id     = $this->Common->get_details('product_price',array('price_id'=>$pr))->row()->product_id;
                                      $product_detail = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                                      $val_array      =  [    
                                                            'promo_id'    => $id,
                                                            'cat_id'      => $cat,
                                                            'price_id'    => $pr,
                                                            'product_id'  => $product_id,
                                                         ];
                                      $this->Common->insert('promotion_products',$val_array);                 
                                      $k++;
                                  }
                              }
                              $j++;
                          }
                        } 
        			    
        			    $branches  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id))->result();
        			    foreach($branches as $branch)
        			    {
        			        $promotion_array    = [
        			                                 'r_id'       => $restaurant_id,
        			                                 'branch_id'  => $branch->b_id,
        			                                 'promo_id'   => $id,
        			                                 'status'     => '1',
        			                                 'timestamp'  => date('Y-m-d H:i:s')
        			                              ];
        			        $this->Common->insert('branch_promotions',$promotion_array);                             
        			    }
        			    
        				$this->session->set_flashdata('alert_type', 'success');
        				$this->session->set_flashdata('alert_title', 'Success');
        				$this->session->set_flashdata('alert_message', 'New promotion added..!');
        				redirect('restaurant/promotions');
        			}
        			else
        			{
        				$this->session->set_flashdata('alert_type', 'error');
        				$this->session->set_flashdata('alert_title', 'Failed');
        				$this->session->set_flashdata('alert_message', 'Failed to add category...!');
        				redirect('restaurant/promotions');
        			}
        		}
    		}
		}
		else
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Please select the products...!');
			redirect('restaurant/promotions/add');
		}
	}

	public function editPromotionData()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp    = date('Y-m-d H:i:s');
	    
		$promotion_id  = $this->input->post('promotion_id');
		$name          = $this->security->xss_clean($this->input->post('name'));
		$code          = $this->security->xss_clean($this->input->post('code'));
		$description   = $this->security->xss_clean($this->input->post('description'));
		$price         = $this->security->xss_clean($this->input->post('price'));
		$start         = $this->security->xss_clean($this->input->post('start_date'));
		$end           = $this->security->xss_clean($this->input->post('end_date'));
		
		if(isset($_POST['values']))
		{
    		$image1       = $this->input->post('image');
            if($image1!='')
            {
                $img1       = substr($image1, strpos($image1, ",") + 1);
        		$url1       = FCPATH.'uploads/restaurant/promotion';
        		$rand11     = date('Ymd').mt_rand(1001,9999);
        		$userpath1  = $url1.$rand11.'.png';
        		$path1      = "uploads/restaurant/promotion".$rand11.'.png';
        		if(file_put_contents($userpath1,base64_decode($img1)))
    			{
    			    $filename = 'uploads/restaurant/promotion/thumbnail/'.$rand11.'thumb.png'; // output file name
                    $fileData = base64_decode($img1);
                    $im = imagecreatefromstring($fileData);
                    $source_width = imagesx($im);
                    $source_height = imagesy($im);
                    $ratio =  $source_height / $source_width;
                    
                    $new_width  = 300; // assign new width to new resized image
                    $new_height = 300*$ratio;
                    
                    $thumb = imagecreatetruecolor($new_width, $new_height);
                    
                    $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                    imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                    
                    imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                    imagepng($thumb, $filename, 9);
                    imagedestroy($im);
    			}
    			else
    			{
    			    $filename = '';
    			}
    			$array  = [     
                                 'code'        => $code,
        						 'title'       => $name,
        						 'description' => $description,
        						 'price'       => $price,
        						 'start_date'  => $start,
        						 'end_date'    => $end,
        						 'image'       => $path1,
        						 'thumbnail'   => $filename
                            ];
    
            }
    		else
    		{
    		    $array  = [     
                              'code'        => $code,
    						  'title'       => $name,
    						  'description' => $description,
    						  'price'       => $price,
    						  'start_date'  => $start,
        					  'end_date'    => $end,
                            ];
    		}
    		
    		if($this->Common->update('pr_id',$promotion_id,'promotions',$array))
    		{   
        		$values    = $_POST['values'];
        		$count     = sizeof($values);
                for ($i=1;$i <=$count; $i++) 
                {
                  $cat_ids    = $_POST['cat_id'.$i];
                  $quantity   = $_POST['quantity'.$i];
                  $products   = $_POST['products'.$i];
                  $cat_id     = $_POST['cate_id'.$i];
                  $produ_id   = $_POST['prod_id'.$i];
                  
                  $j=0;
                  foreach($cat_ids as $cat)
                  {   
                        $categ_id	 = isset($cat_id[$j]) ? $cat_id[$j] : '';
                        $cat_array   = [   
                                              'promo_id'       => $promotion_id,
                                              'cat_id'         => $cat,
                                              'quantity'       => $quantity[$j],
                		                      'date'           => date('Y-m-d')
                                        ];
                        
                        if($categ_id=='')
        				{
        					$this->Common->insert('promotion_selection_list',$cat_array);
        				}
        				else
        				{					    
        				   $this->Common->update('sel_id',$categ_id,'promotion_selection_list',$cat_array);
        			    }
    
                        $k=0;
                        foreach($products as $pr)
                        {
                              $product_id     = $this->Common->get_details('product_price',array('price_id'=>$pr))->row()->product_id;
                              $product_detail = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                              $prd_id	      = isset($produ_id[$k]) ? $produ_id[$k] : '';
                              
                              $val_array      =  [    
                                                    'promo_id'    => $promotion_id,
                                                    'cat_id'      => $cat,
                                                    'price_id'    => $pr,
                                                    'product_id'  => $product_id,
                                                 ];
                                                 
                                if($prd_id=='')
                				{
                					$this->Common->insert('promotion_products',$val_array);
                				}
                				else
                				{					    
                				   $this->Common->update('ppro_id',$prd_id,'promotion_products',$val_array);
                			    }
                              $k++;
                        }
                      $j++;
                  }
                }
    
    			$this->session->set_flashdata('alert_type', 'success');
    			$this->session->set_flashdata('alert_title', 'Success');
    			$this->session->set_flashdata('alert_message', 'Promotion updated successfully..!');
    			redirect('restaurant/promotions');
    		}
    		else
    		{
    			$this->session->set_flashdata('alert_type', 'error');
    			$this->session->set_flashdata('alert_title', 'Failed');
    			$this->session->set_flashdata('alert_message', 'Failed to update promotion..!');
    			redirect('restaurant/promotions/edit/'.$promotion_id);
    		}
		}
		else
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Please select products..!');
			redirect('restaurant/promotions/edit/'.$promotion_id);
		}
	}
	
	public function disable_promotion()
	{
	    $id    = $this->input->post('promo_id');
		$array = [
			       'status' => 'blocked'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion blocked successfully..!');
			redirect('restaurant/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block promotion..!');
			redirect('restaurant/promotions');
		}
	}
	
	public function enable_promotion()
	{
	    $id    = $this->input->post('promo_id');
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion activated successfully..');
			redirect('restaurant/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate promotion..!');
			redirect('restaurant/promotions');
	    }		
	}

	public function details($id)
	{
		$promotion          = $this->Common->get_details('promotions',array('pr_id'=>$id))->row();
		$promotion_category= $this->Common->get_details('promotion_selection_list',array('promo_id'=>$id))->result();
		foreach($promotion_category as $cat)
		{   
		    $cat_details    = $this->Common->get_details('promotion_category',array('pcat_id'=>$cat->cat_id))->row();
		    if($cat_details) {
		        $cat->name      = $cat_details->cat_name;
		    } else {
		        $cat->name      = '';
		    }
		    $cat->products  = $this->Common->get_details('promotion_products',array('cat_id'=>$cat->cat_id,'promo_id'=>$id))->result();
		    foreach($cat->products as $product)
		    {
		        $product_details  = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
		        $product->item_code= $product_details->item_code;
		        $price            = $this->Common->get_details('product_price',array('price_id'=>$product->price_id))->row();
		        if($price->unit!=='')
		        {
		            $product->name    = $product_details->name.' - '.$price->unit;
		        }
		        else
		        {
		            $product->name    = $product_details->name;
		        }
		        $product->price       = $this->promo->get_smallest_price($product->product_id);
		        $product->code        = $product_details->item_code;
		    }
		}
		$data['promotion']  = $promotion;
		$data['promotion_category'] = $promotion_category;
	   $this->load->view('restaurant/promotions/details',$data);
	}
	
	public function updateProductStatus()
	{
		$prod_id      = $_POST['prod'];
		$array        = [
                			'status'   => '0'
                		];
        
		if ($this->Common->update('ppro_id',$prod_id,'promotion_products',$array)) 
		    {
			  echo "1";
		    }
		else 
		   {  
			  echo "0";
		   }
	}
	
	public function updateCategoryStatus()
	{
		$cat_id       = $_POST['category'];
		$array        = [
                			'status'   => '0'
                		];
        
		if ($this->Common->update('sel_id',$cat_id,'promotion_selection_list',$array)) 
		    {
			  echo "1";
		    }
		else 
		   {  
			  echo "0";
		   }
	}
    
    public function checkCode()
    {
    	$code = $this->input->post('code');
    	$check= $this->Common->get_details('promotions',array('code'=>$code));
    	if($check->num_rows()>0)
    	{
    		$data = '1';
    	}
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
    
    public function deletePromotion()
	{
	    $promotion_id  = $this->input->post('promotion_id');
		$check = $this->Common->get_details('promotions',array('pr_id' => $promotion_id));
		if ($check->num_rows() > 0) {
			$banner = $check->row();
			if ($this->Common->delete('promotions',array('pr_id' => $promotion_id))) {
                $this->Common->delete('promotion_selection_list',array('promo_id' => $promotion_id));
                $this->Common->delete('promotion_products',array('promo_id' => $promotion_id));
                
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Promotion deleted successfully..!');
			}
			else {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to remove promotion..!');
			}
		}
		else {
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove promotion..!');
		}
		redirect('restaurant/promotions');
	}

//     public function checkCouponById()
//     {
//     	$code = $this->input->post('code');
//     	$id   = $this->input->post('id');
//     	$check= $this->Common->get_details('promotions',array('offer_code'=>$code,'pr_id!='=>$id));
//     	if($check->num_rows()>0)
//     	{
//     		$data = '1';
//     	}
//         else
//         {
//         	$data = '0';
//         }
//         print_r($data);
//     }
    

//Category//
    public function category()
    {
        $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$categories    = $this->promo->getPromotionCategories($restaurant_id);
		
		$data['categories'] = $categories;

		$this->load->view('restaurant/promotions/category',$data);
    }
   
   	public function addCatData()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp    = date('Y-m-d H:i:s');
	    
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

        $name       = $this->security->xss_clean($this->input->post('name'));
		$check      = $this->promo->checkCatName($name,$restaurant_id);
		if($check > 0)
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Category name already exists..!');
			redirect('restaurant/promotions/category');
		}
		else
		{   
			$array = [
				         'r_id'        => $restaurant_id,
						 'cat_name'    => $name,
						 'timestamp'   => date('Y-m-d H:i:s')
					 ];
			if ($id=$this->Common->insert('promotion_category',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New promotion category added..!');
				redirect('restaurant/promotions/category');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add promotion category...!');
				redirect('restaurant/promotions/category');
			}
		}
	}
	public function editData()
	{
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		
		$cat_id     = $this->input->post('cat_id');
		$name       = $this->security->xss_clean($this->input->post('name'));
		$check      = $this->promo->checkCatById($name,$cat_id,$restaurant_id);
		if($check > 0)
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Category name already exists..!');
			redirect('restaurant/promotions/category');
		}
		else
		{
		     $array   =  [
    						'cat_name'       => $name
    					 ];

    		if ($this->Common->update('pcat_id',$cat_id,'promotion_category',$array)) 
    		{
    			$this->session->set_flashdata('alert_type', 'success');
    			$this->session->set_flashdata('alert_title', 'Success');
    			$this->session->set_flashdata('alert_message', 'Promotion category updated successfully..!');
    			redirect('restaurant/promotions/category');
    		}
    		else
    		{
    			$this->session->set_flashdata('alert_type', 'error');
    			$this->session->set_flashdata('alert_title', 'Failed');
    			$this->session->set_flashdata('alert_message', 'Failed to update promotion category..!');
    			redirect('restaurant/promotions/category');
    		}
		}
		
	}
	
	public function getCatDetails() 
	{
        $id      = $this->input->post('id');
        $check   = $this->Common->get_details('promotion_category', array('pcat_id' => $id));
        if ($check->num_rows() > 0) 
        {
            $data = $check->row();
        } 
        else 
        {
            $data = '';
        }
        print_r(json_encode($data));
    }

	public function disableCat()
	{
	    $id    = $this->input->post('cat_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('pcat_id',$id,'promotion_category',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion category blocked successfully..!');
			redirect('restaurant/promotions/category');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block promotion category..!');
			redirect('restaurant/promotions/category');
		}
	}

	public function enableCat()
	{
	    $id    = $this->input->post('cat_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('pcat_id',$id,'promotion_category',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion category activated successfully..');
			redirect('restaurant/promotions/category');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate promotion category..!');
			redirect('restaurant/promotions/category');
	    }		
	}
	
	public function checkExtra() 
	{
        $code        = $this->input->post('code');
        $name        = $this->input->post('name');
        $check_code  = $this->Common->get_details('extras', array('item_code'  => $code));
        $check_name  = $this->extras->checkString($name);
        if($check_name > 0) 
        {
            $data = '1';
        }
        elseif($check_code->num_rows() > 0)
        {
            $data = '2';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
    

}
?>
