<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}

	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		$data['rest']  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
		$types         = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$restaurant_id))->result();
		foreach($types as $type)
		{
			$type->name = $this->Common->get_details('cuisines',array('c_id'=>$type->c_id))->row()->name;
		}
		$data['types'] = $types;
		$this->load->view('restaurant/profile/view',$data);
	}

	public function getProfileById()
    {
    	$rest_id    = $this->input->post('id');
    	$data       = $this->Common->get_details('restaurants',array('r_id'=>$rest_id))->row();
    	print_r(json_encode($data));
    }

	public function editData()
	{
		$rest_id   = $this->input->post('rest_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$code      = $this->security->xss_clean($this->input->post('code'));
// 		$address_2 = $this->security->xss_clean($this->input->post('address_2'));
// 		$address_3 = $this->security->xss_clean($this->input->post('address_3'));
// 		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
// 		$state     = $this->security->xss_clean($this->input->post('state'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
// 		$service   = $this->security->xss_clean($this->input->post('service'));
		$delivery_vat   = $this->security->xss_clean($this->input->post('delivery_vat'));
		$delivery  = $this->security->xss_clean($this->input->post('delivery'));
		$min_order = $this->security->xss_clean($this->input->post('min_order'));
		
		$check     = $this->Common->get_details('restaurants',array('rest_email' => $email,'rest_phone'=>$phone, 'r_id!=' => $rest_id))->num_rows();
		$check_phone = $this->Common->get_details('restaurants',array('rest_phone'=>$phone, 'r_id!=' => $rest_id))->num_rows();
		$check_mail  = $this->Common->get_details('restaurants',array('rest_email'=>$email, 'r_id!=' => $rest_id))->num_rows();
		$check_email  = $this->Common->get_details('branches',array('email'=>$email,'branch_type' => 1 ))->num_rows();
		$check_code  = $this->Common->get_details('restaurants',array('rest_code'=>$code, 'r_id!=' => $rest_id))->num_rows();
		$check_bcode  = $this->Common->get_details('branches',array('branch_code'=>$code,'branch_type' => 1 ))->num_rows();
		$city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
		if($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
			redirect('restaurant/profile');
		}
		elseif($check_phone > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number already exists..!');
			redirect('restaurant/profile');
		}
		elseif($check_mail > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email already exists..!');
			redirect('restaurant/profile');
		}
		elseif($check_email > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email address already registered for a branch..!');
			redirect('restaurant/profile/edit/'.$rest_id);
		}
		elseif($check_code > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_bcode > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		else 
		{
			$image  = $this->input->post('image');
            if ($image != '') 
			{
				$img = substr($image, strpos($image, ",") + 1);

				$url      = FCPATH.'uploads/admin/restaurants/';
				$rand     = date('Ymd').mt_rand(1001,9999);
				$userpath = $url.$rand.'.png';
				$path     = "uploads/admin/restaurants/".$rand.'.png';
				file_put_contents($userpath,base64_decode($img));

				// Remove old image from the server
				$old = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->rest_image;
				$remove_path = FCPATH . $old;
				unlink($remove_path);

				$array = [
    						'rest_name'  => $name,
    						'rest_code'  => $code,
    						'rest_phone' => $phone,
    						'rest_email' => $email,
    						'rest_image' => $path,
    						'open_time'  => $open_time,
    						'close_time' => $close_time,
    						'address1'   => $address_1,
    				// 		'address2'   => $address_2,
    				// 		'address3'   => $address_3,
    				// 		'state'      => $state,
    				        'latitude'   => $latitude,
    						'longitude'   => $longitude,
    						'city'       => $city,
    						'landmark'   => $landmark,
    				// 		'pincode'    => $pincode,
    						'country'    => $country,
    						'del_charge_without_vat' => $delivery,
						    'delivery_charge'=>$delivery_vat,
    						'min_order'  => $min_order,
    					 ];
			}
			else
			{
				$array = [
    						'rest_name'  => $name,
    						'rest_code'  => $code,
    						'rest_phone' => $phone,
    						'rest_email' => $email,
    						'open_time'  => $open_time,
    						'close_time' => $close_time,
    						'address1'   => $address_1,
    				// 		'address2'   => $address_2,
    				// 		'address3'   => $address_3,
    				// 		'state'      => $state,
    				        'latitude'   => $latitude,
    						'longitude'   => $longitude,
    						'city'       => $city,
    						'landmark'   => $landmark,
    				// 		'pincode'    => $pincode,
    						'country'    => $country,
    						'del_charge_without_vat' => $delivery,
						    'delivery_charge'=>$delivery_vat,
    						'min_order'  => $min_order,
    					 ];
			}
			
// 			$image1     = $this->input->post('t_image');
// 			if($image1!='')
// 			{
// 			    $img1       = substr($image1, strpos($image1, ",") + 1);
//     			$url1       = FCPATH.'uploads/admin/restaurants/';
//     			$rand1      = date('Ymd').mt_rand(1001,9999);
//     			$userpath1  = $url1.$rand1.'.png';
//     			$path1      = "uploads/admin/restaurants/".$rand1.'.png';
//     			file_put_contents($userpath1,base64_decode($img1)); 
//     			$array['thumbnail'] = $path1;
    			
//     			// Remove old image from the server
// 				$old1 = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->thumbnail;
// 				$remove_path1 = FCPATH . $old1;
// 				unlink($remove_path1);
// 			}
			
			$image2     = $this->input->post('c_image');
			if($image2!='')
			{
			    $img2       = substr($image2, strpos($image2, ",") + 1);
    			$url2       = FCPATH.'uploads/admin/restaurants/cover/';
    			$rand2      = date('Ymd').mt_rand(1001,9999);
    			$userpath2  = $url2.$rand2.'.png';
    			$path2      = "uploads/admin/restaurants/cover/".$rand2.'.png';
    			if(file_put_contents($userpath2,base64_decode($img2)))
    			{
    			    $filename = 'uploads/admin/restaurants/thumbnail/'.$rand2.'thumb.png'; // output file name
                    $fileData = base64_decode($img2);
                    $im = imagecreatefromstring($fileData);
                    $source_width = imagesx($im);
                    $source_height = imagesy($im);
                    $ratio =  $source_height / $source_width;
                    
                    $new_width  = 300; // assign new width to new resized image
                    $new_height = 350*$ratio;
                    
                    $thumb = imagecreatetruecolor($new_width, $new_height);
                    
                    $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                    imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                    
                    imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                    imagepng($thumb, $filename, 9);
                    imagedestroy($im);
    			}
    			else
    			{
    			    $filename ='';
    			}
    			$array['cover_image'] = $path2;
    			$array['thumbnail']   = $filename;
    			// Remove old image from the server
				$old2         = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->cover_image;
				$remove_path2 = FCPATH . $old2;
				unlink($remove_path2);
			}
			
			if ($this->Common->update('r_id',$rest_id,'restaurants',$array)) 
			{
			   $branch_check = $this->Common->get_details('branches',array('r_id'=>$rest_id,'branch_type'=>'2'));
			   if($branch_check->num_rows()>0)
			   {
			       $branch_id    = $branch_check->row()->b_id;
			       $branch_array = [  
                						'phone'      => $phone,
                						'email'      => $email,
                						'city_id'    => $city_id,
                						'city'       => $city,
                						'address'    => $address_1,
                						'location'   => $landmark,
                						'latitude'   => $latitude,
                						'longitude'  => $longitude,
                						'country'    => $country,
                						'branch_code'=> $code,
                						'open_time'  => $open_time,
						                'close_time' => $close_time,
                					 ];
			       $this->Common->update('b_id',$branch_id,'branches',$branch_array);
			   }
			   else
			   {
			       $rest_details = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row();
			       $branch_array = [  
                				        'r_id'       => $rest_id,
                				        'branch_code'=> $code,
                						'phone'      => $phone,
                						'email'      => $email,
                						'city_id'    => $city_id,
                						'city'       => $city,
                						'address'    => $address_1,
                						'location'   => $landmark,
                						'latitude'   => $latitude,
                						'longitude'  => $longitude,
                						'country'    => $country,
                						'password'   => $rest_details->rest_password,
                						'pass'       => $rest_details->password,
                						'status'     => '1',
                						'branch_type'=> '2',
                                        'date'       => date('Y-m-d'),
                						'timestamp'  => date('Y-m-d H:i:s')
            					 ];
                    $this->Common->insert('branches',$branch_array);        					 
			   }
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('restaurant/profile');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update restaurant..!');
				redirect('restaurant/profile');
			}
		}
	}
    
    public function edit($id)
	{
		$check = $this->Common->get_details('restaurants',array('r_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['rest']    = $check->row();
			$data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
			$this->load->view('restaurant/profile/edit',$data);
		}
		else 
		{
			redirect('profile');
		}
	}

	
}
?>
