<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_products','products');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

		$products         = $this->products->getProducts($restaurant_id);
		foreach($products as $pro)
		{   
			$category_check    = $this->Common->get_details('menu',array('menu_id'=>$pro->cat_id));
			if($category_check->num_rows()>0)
			{
				$pro->category = $category_check->row()->name;
			}
			else
			{
				$pro->category = '';
			}
		}
		$data['products'] = $products;
		// print_r($data);
		$this->load->view('restaurant/products/view',$data);
	}
	public function get()
	{
		$result = $this->products->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status=='active') 
			{
				$status = "Active";
				$action = '<a class="btn btn-danger" style="font-size:12px;" href="' . site_url('restaurant/products/disable/'.$res->p_id) . '" >Disable</a>';
			}
			elseif($res->status=='blocked') 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success" style="font-size:12px;" href="' . site_url('restaurant/products/enable/'.$res->p_id) . '" >Enable</a>';
			}
			else
			{
				$status = "Sold out";
				$action = '';
			}
			
			$sub_array = array();
			// $sub_array[] = '<img src="' . base_url() . $res->cover_image . '" height="100px">';
			$sub_array[] = $res->sku;
			$sub_array[] = $res->name;
			$sub_array[] = $res->price;
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/details/'.$res->p_id) . '">View</a>';
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/images/'.$res->p_id) . '">Images</a>';
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/edit/'.$res->p_id) . '">Edit</a>';
			$sub_array[] = $status.'<br>'.$action;
			$data[] = $sub_array;
		}

		$output = array (
							"draw"            => intval($_POST['draw']),
							"recordsTotal"    => $this->products->get_all_data(),
							"recordsFiltered" => $this->products->get_filtered_data(),
							"data"            => $data
						);
		echo json_encode($output);
	}
	public function add()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

        $data['rest']  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row(); 
		$data['menu']  = $this->Common->get_details('menu',array('status'=>'1','r_id'=>$restaurant_id))->result();
		$data['days']  = $this->Common->get_details('days',array())->result();
		$data['extras']= $this->products->getRestaurantExtras($restaurant_id);
		$this->load->view('restaurant/products/add',$data);
		// print_r($data);
	}
	public function edit($id)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

        $data['rest']  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row(); 
        
		$check = $this->Common->get_details('products',array('p_id' => $id));
		if ($check->num_rows() > 0) 
		{   
			$product       = $check->row();
			$data['pro']   = $product;
			$data['menu']  = $this->Common->get_details('menu',array('status'=>'1'))->result();
			$days = $this->Common->get_details('days',array())->result();
			foreach($days as $d)
			{
				$stat_check  = $this->products->getProductDays($d->d_id,$id);
				if($stat_check>0)
				{
					$d->stat  = '1';
				}
				else
				{
					$d->stat  = '0';
				}
			}
            $data['days'] = $days;

            $extras        = $this->products->getRestaurantExtras($restaurant_id);
			foreach($extras as $ex)
			{   
				$stat_check  = $this->Common->get_details('product_extras',array('product_id'=>$id,'extra_id'=>$ex->extra_id))->num_rows();
				if($stat_check>0)
				{
					$ex->stat  = '1';
				}
				else
				{
					$ex->stat  = '0';
				}
			}
			$data['extras']  = $extras;
			$this->load->view('restaurant/products/edit',$data);
		}
		else 
		{
			redirect('restaurant/products');
		}
	}
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$name        = $this->security->xss_clean($this->input->post('name'));
		$cat_id      = $this->security->xss_clean($this->input->post('cat_id'));
		// $type        = $this->security->xss_clean($this->input->post('type'));
		// $sku         = $this->security->xss_clean($this->input->post('sku'));
		$price       = $this->security->xss_clean($this->input->post('price'));
		// $description = $this->security->xss_clean($this->input->post('description'));
		// $ingredients = $this->security->xss_clean($this->input->post('ingredients'));
		$days        = $this->security->xss_clean($this->input->post('days'));
		$time_starts = $this->security->xss_clean($this->input->post('time_starts'));
		$time_ends   = $this->security->xss_clean($this->input->post('time_ends'));
		// $sequence    = $this->security->xss_clean($this->input->post('sequence'));
		$prep_time   = $this->security->xss_clean($this->input->post('prep_time'));
		
		// $check     = $this->Common->get_details('products',array('sku' => $sku))->num_rows();
		// if ($check > 0) 
		// {
		// 	$this->session->set_flashdata('alert_type', 'error');
		// 	$this->session->set_flashdata('alert_title', 'Failed');
		// 	$this->session->set_flashdata('alert_message', 'Product already exists..!');
		// 	redirect('restaurant/products/add');
		// }
		// else {

			// $cover       = $_FILES['cover'];
			// if($cover['name']!='')
			// {
   //              $tar1        = "uploads/restaurant/products/cover/";
			// 	$rand1       = date('Ymd').mt_rand(1001,9999);
			// 	$tar_file1   = $tar1 . $rand1.'.png';
			// 	move_uploaded_file($cover['tmp_name'], $tar_file1);
			// }
			// else
			// {
			// 	$tar_file1  = '';
			// }

			$cover    = $this->input->post('cover');
			if($cover!='')
			{
				$cvr      = substr($cover, strpos($cover, ",") + 1);

	    		$url      = FCPATH.'uploads/restaurant/products/cover/';
	    		$rand     = date('Ymd').mt_rand(1001,9999);
	    		$userpath = $url.$rand.'.png';
	    		$path1    = "uploads/restaurant/products/cover/".$rand.'.png';
	    		file_put_contents($userpath,base64_decode($cvr));
			}
			else
			{
				$path1    = '';
			}

			$array = [  
				        'r_id'        => $restaurant_id,
						'name'        => $name,
						'cat_id'      => $cat_id,
						'price'       => $price,
						// 'sku'         => $sku,
						// 'description' => $description,
						// 'ingredients' => $ingredients,
						'time_starts' => $time_starts,
						'time_ends'   => $time_ends,
						// 'sequence'    => $sequence,
						'prep_time'   => $prep_time,
						'cover_image' => $path1,
						// 'type'        => $type,
						'status'     => 'active',
                        'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($id=$this->Common->insert('products',$array))
			{   
				// $files = $_FILES['image'];
				// extract($files);
				// $i = 0;
				// foreach ($name as $key => $value) 
				// {
				// 	$tar      = "uploads/restaurant/products/";
				// 	$rand     = date('Ymd').mt_rand(1001,9999);
				// 	$tar_file = $tar . $rand.'.png';
				// 	if(move_uploaded_file($tmp_name[$i], $tar_file))
				// 	{
				// 		$array_image  = [
				// 							'image'      => $tar_file,
				// 							'p_id'       => $id
				// 						];
				// 		$this->Common->insert('product_images',$array_image);
				// 	}
				// 	$i++;
				// }
                
    //             $images    = $this->input->post('image');
				// foreach ($images as $image) {
				// 	$img      = substr($image, strpos($image, ",") + 1);

		  //   		$url      = FCPATH.'uploads/restaurant/products/';
		  //   		$rand     = date('Ymd').mt_rand(1001,9999);
		  //   		$userpath = $url.$rand.'.png';
		  //   		$path     = "uploads/restaurant/products/".$rand.'.png';
		  //   		file_put_contents($userpath,base64_decode($img));
				// 		$image = [
				// 			'p_id' => $id,
				// 			'image' => $path
				// 		];
					
				// 	$this->Common->insert('product_images',$image);
				// }

				$days = $this->input->post('days');
				foreach($days as $day)
				{
					$day_array  = [
						             'p_id'     => $id,
						             'day_id'   => $day
					              ];
					$this->Common->insert('product_days',$day_array);              
				}

				$extras      = $this->input->post('extras');			
		        foreach($extras as $ex)
				{ 
			    	$array  = [
					             'product_id'=> $id,
					             'extra_id'  => $ex,
					             'timestamp' => date('Y-m-d H:i:s')
				              ];
			        $this->Common->insert('product_extras',$array);
				}

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New product added..!');
				redirect('restaurant/products');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add product...!');
				redirect('restaurant/products/add');
			}
		// }
	}
	public function editData()
	{
		$product_id  = $this->input->post('product_id');
		$name        = $this->security->xss_clean($this->input->post('name'));
		// $type        = $this->security->xss_clean($this->input->post('type'));
		$cat_id      = $this->security->xss_clean($this->input->post('cat_id'));
		// $sku         = $this->security->xss_clean($this->input->post('sku'));
		$price       = $this->security->xss_clean($this->input->post('price'));
		// $description = $this->security->xss_clean($this->input->post('description'));
		// $ingredients = $this->security->xss_clean($this->input->post('ingredients'));
		$days        = $this->security->xss_clean($this->input->post('days'));
		$time_starts = $this->security->xss_clean($this->input->post('time_starts'));
		$time_ends   = $this->security->xss_clean($this->input->post('time_ends'));
		// $sequence    = $this->security->xss_clean($this->input->post('sequence'));
		$prep_time   = $this->security->xss_clean($this->input->post('prep_time'));
		$days        = $this->input->post('days');
		// $check       = $this->Common->get_details('products',array('sku'=>$sku, 'p_id!=' => $product_id))->num_rows();
		// if($check > 0) 
		// {
		// 	$this->session->set_flashdata('alert_type', 'error');
		// 	$this->session->set_flashdata('alert_title', 'Failed');
		// 	$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
		// 	redirect('restaurant/restaurants/edit/'.$rest_id);
		// }
		
		// else {
			// $cover       = $_FILES['cover'];
			// if($cover['name']!='')
			// {
   //              $tar1        = "uploads/restaurant/products/cover/";
			// 	$rand1       = date('Ymd').mt_rand(1001,9999);
			// 	$tar_file1   = $tar1 . $rand1.'.png';
			// 	move_uploaded_file($cover['tmp_name'], $tar_file1);
			$cover    = $this->input->post('image');
			if($cover!='')
			{
				$cvr      = substr($cover, strpos($cover, ",") + 1);

	    		$url      = FCPATH.'uploads/restaurant/products/cover/';
	    		$rand     = date('Ymd').mt_rand(1001,9999);
	    		$userpath = $url.$rand.'.png';
	    		$path1    = "uploads/restaurant/products/cover/".$rand.'.png';
	    		file_put_contents($userpath,base64_decode($cvr));

				$array = [
							'name'        => $name,
							'cat_id'      => $cat_id,
							'price'       => $price,
							// 'sku'         => $sku,
							// 'description' => $description,
							// 'ingredients' => $ingredients,
							'time_starts' => $time_starts,
							'time_ends'   => $time_ends,
							// 'sequence'    => $sequence,
							'prep_time'   => $prep_time,
							'cover_image' => $path1,
							// 'type'       => $type,
							'status'     => 'active',
	                        'date'       => date('Y-m-d'),
							'timestamp'  => date('Y-m-d H:i:s')
						 ];
			}
			else
			{		
				$array = [
							'name'        => $name,
							'cat_id'      => $cat_id,
							'price'       => $price,
							// 'sku'         => $sku,
							// 'description' => $description,
							// 'ingredients' => $ingredients,
							'time_starts' => $time_starts,
							'time_ends'   => $time_ends,
							// 'sequence'    => $sequence,
							'prep_time'   => $prep_time,
							// 'type'        => $type
						 ];
			}
			
			// print_r($days);
			if ($this->Common->update('p_id',$product_id,'products',$array)) 
			{   
				$this->Common->delete('product_days',array('p_id'=>$product_id));
                foreach($days as $day)
                {                 
				   
					$day_array  = [
					           'p_id'  => $product_id,
					           'day_id'  => $day
				             ];
					$this->Common->insert('product_days',$day_array);
                }	
                    
                $check_extra = $this->Common->get_details('product_extras',array('product_id'=>$product_id));
                if($check_extra->num_rows()>0)
                {
                	$this->Common->delete('product_extras',array('product_id' => $product_id));

                	$extras      = $this->input->post('extras');			
			        foreach($extras as $ex)
					{  
				    	$extra_array  = [
						                     'product_id'=> $product_id,
						                     'extra_id'  => $ex,
						                     'timestamp' => date('Y-m-d H:i:s')
					                   ];
				        $this->Common->insert('product_extras',$extra_array);
					}		
                }
                else
                {
                	$extras      = $this->input->post('extras');			
			        foreach($extras as $ex)
					{  
				    	$extra_array  =  [
    							             'product_id'=> $product_id,
    							             'extra_id'  => $ex,
    							             'timestamp' => date('Y-m-d H:i:s')
    						              ];
				        $this->Common->insert('product_extras',$extra_array);
					}		
                }
							   
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('restaurant/products');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update product..!');
				redirect('restaurant/products/edit/'.$rest_id);
			}
		// }
	}

	public function disable($id)
	{
		$array = [
			       'status' => 'blocked'
		         ];
	
		if ($this->Common->update('p_id',$id,'products',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product blocked successfully..!');
			redirect('restaurant/products');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block product..!');
			redirect('restaurant/products');
		}
	}

	public function enable($id)
	{
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('p_id',$id,'products',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product activated successfully..');
			redirect('restaurant/products');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate product..!');
			redirect('restaurant/products');
	    }		
	}

    public function images($param)
	{
		$check          = $this->Common->get_details('product_images',array('p_id' => $param));
		$data['images']  = $check->result();
		$data['product'] = $this->Common->get_details('products',array('p_id' => $param))->row()->name;
		$data['p_id']    = $param;
		$this->load->view('restaurant/products/gallery',$data);
	}

	public function gallery($id)
	{
		$data['product_id'] = $id;
		$this->load->view('restaurant/products/image',$data);
	}

	public function addImage()
	{
		$product_id = $this->input->post('product_id');
		// $file       = $_FILES['image'];
		// $tar        = "uploads/restaurant/products/";
		// $rand       = date('Ymd').mt_rand(1001,9999);
		// $tar_file   = $tar . $rand.'.png';
		// if(move_uploaded_file($file['tmp_name'], $tar_file))
		$image    = $this->input->post('image');
		$img      = substr($image, strpos($image, ",") + 1);

		$url      = FCPATH.'uploads/restaurant/products/';
		$rand     = date('Ymd').mt_rand(1001,9999);
		$userpath = $url.$rand.'.png';
		$path     = "uploads/restaurant/products/".$rand.'.png';
		if(file_put_contents($userpath,base64_decode($img)))
		{
			$array = [
						'image'      => $path,
						'p_id'       => $product_id
					 ];
			$this->Common->insert('product_images',$array);
		}
		$this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'Image added successfully..');
		redirect('restaurant/products/images/'.$product_id);
	}

	public function deleteImage()
	{
		$param = $_POST['delete_id'];
		$check = $this->Common->get_details('product_images',array('pi_id' => $param));
		if ($check->num_rows() == 1) 
		{      
				$old         = $this->Common->get_details('product_images',array('pi_id' => $param))->row()->image;
				$remove_path = FCPATH . $old;
				unlink($remove_path);

				$this->Common->delete('product_images',array('pi_id' => $param));

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Image deleted successfully..');
				redirect('restaurant/products/images/'.$check->row()->p_id);
		}
		else 
		{
				redirect('products');
		}
	}

	public function details($id)
	{
		$check = $this->Common->get_details('products',array('p_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['pro'] = $check->row();
			$days        = $this->Common->get_details('product_days',array('p_id' => $id))->result();
			foreach($days as $d)
			{
				$d->day = $this->Common->get_details('days',array('d_id'=>$d->day_id))->row()->day;
			}
			$data['days']= $days;
			$menu = $this->Common->get_details('menu',array('menu_id'=>$check->row()->cat_id));
             if($menu->num_rows()>0)
             {
             	$data['menu'] = $menu->row()->name;
             }
             else
             {
             	$data['menu'] = 'None';
             }
			$this->load->view('restaurant/products/details',$data);
		}
		else 
		{
			redirect('restaurant/products');
		}
	}

	public function checkProduct() 
	{
        $sku     = $this->input->post('sku  ');
        $check   = $this->Common->get_details('products', array('sku' => $sku));
        if($check->num_rows() > 0) 
        {
            $data = '1';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
}
?>
