<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_products','products');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
//******************************************** GET ****************************************************************************************************************//	
	public function index($param)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        // if (isset($_POST['submit']))
        
		$products      = $this->products->getProducts($restaurant_id,$param);
		foreach($products as $pro)
		{   
			$category_check    = $this->Common->get_details('menu',array('menu_id'=>$pro->cat_id));
			if($category_check->num_rows()>0)
			{
				$pro->category = $category_check->row()->name;
			}
			else
			{
				$pro->category = '';
			}
			
			$prices        = $this->Common->get_details('product_price',array('product_id'=>$pro->p_id,'status'=>'1'))->result();
			$pro->prices   = $prices;
		}
		$data['products'] = $products;
		// print_r($data);
		$this->load->view('restaurant/products/view',$data);
	}
	
	public function get()
	{
		$result = $this->products->make_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
			if ($res->status=='active') 
			{
				$status = "Active";
				$action = '<a class="btn btn-danger" style="font-size:12px;" href="' . site_url('restaurant/products/disable/'.$res->p_id) . '" >Disable</a>';
			}
			elseif($res->status=='blocked') 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success" style="font-size:12px;" href="' . site_url('restaurant/products/enable/'.$res->p_id) . '" >Enable</a>';
			}
			else
			{
				$status = "Sold out";
				$action = '';
			}
			
			$sub_array = array();
			// $sub_array[] = '<img src="' . base_url() . $res->cover_image . '" height="100px">';
			$sub_array[] = $res->sku;
			$sub_array[] = $res->name;
			$sub_array[] = $res->price;
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/details/'.$res->p_id) . '">View</a>';
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/images/'.$res->p_id) . '">Images</a>';
			$sub_array[] = '<a class="btn btn-danger" style="font-size: 12px;" href="' . site_url('restaurant/products/edit/'.$res->p_id) . '">Edit</a>';
			$sub_array[] = $status.'<br>'.$action;
			$data[] = $sub_array;
		}

		$output = array (
							"draw"            => intval($_POST['draw']),
							"recordsTotal"    => $this->products->get_all_data(),
							"recordsFiltered" => $this->products->get_filtered_data(),
							"data"            => $data
						);
		echo json_encode($output);
	}
	
//***************************************************** ADD ********************************************************************************************************//	
	public function add()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

        $data['rest']  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row(); 
		$data['menu']  = $this->Common->get_details('menu',array('status'=>'1','r_id'=>$restaurant_id))->result();
		$data['products'] = $this->products->getChoiceProducts($restaurant_id);
		$data['days']  = $this->Common->get_details('days',array())->result();
		$data['extras']= $this->products->getRestaurantExtras($restaurant_id);
		$this->load->view('restaurant/products/add',$data);
		// print_r($data);
	}

	public function addData()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp    = date('Y-m-d H:i:s');
	    
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
        
        $name         = $this->security->xss_clean($this->input->post('name'));
		$category_id  = $this->security->xss_clean($this->input->post('category_id'));
// 		$price        = $this->security->xss_clean($this->input->post('price'));
		$pre_time     = $this->security->xss_clean($this->input->post('prep_time'));
		$code         = $this->security->xss_clean($this->input->post('code'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$choice_type  = $this->security->xss_clean($this->input->post('choice_type'));
		$size         = $this->security->xss_clean($this->input->post('size'));

		$image1       = $this->input->post('image');
        if($image1!='')
        {
            $img1       = substr($image1, strpos($image1, ",") + 1);
    		$url1       = FCPATH.'uploads/restaurant/products';
    		$rand11     = date('Ymd').mt_rand(1001,9999);
    		$userpath1  = $url1.$rand11.'.png';
    		$path1      = "uploads/restaurant/products".$rand11.'.png';
    		if(file_put_contents($userpath1,base64_decode($img1)))
			{
			    $filename = 'uploads/restaurant/products/thumbnail/'.$rand11.'thumb.png'; // output file name
                $fileData = base64_decode($img1);
                $im = imagecreatefromstring($fileData);
                $source_width = imagesx($im);
                $source_height = imagesy($im);
                $ratio =  $source_height / $source_width;
                
                $new_width  = 300; // assign new width to new resized image
                $new_height = 300*$ratio;
                
                $thumb = imagecreatetruecolor($new_width, $new_height);
                
                $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                
                imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                imagepng($thumb, $filename, 9);
                imagedestroy($im);
			}
			else
			{
			    $filename = '';
			}
        }
		else
		{
		    $path1      = '';
		}
		
		if($size =='no')
        {   
            $product_size  = 'single';
        }
        else if($size=='yes')
        {
            $product_size  = 'multi';
        }
        
        $array        = [     
                              'r_id'      => $restaurant_id,
                              'name'      => $name,
                              'cat_id'    => $category_id,
                            //   'price'     => $price,
                              'prep_time' => $pre_time,
                              'item_code' => $code,
                              'size'      => $product_size,
                              'description'=> $description,
                              'cover_image'=> $path1,
                              'thumbnail'  => $filename,
                              'date'       => date('Y-m-d'),
                              'timestamp'  => $timestamp
                        ];
        
        if($id = $this->Common->insert('products',$array))
        {   
            if($size =='no')
            {   
                $single_price   = $this->input->post('single_price');
                $price_array    = [
									'product_id'       => $id,
									'unit'             => '',
									'price'            => $single_price,
									'timestamp'        => $timestamp
								 ];
				
				$this->Common->insert('product_price',$price_array);
            }
            else if($size=='yes')
            {
                $unit     = $_POST['unit'];
    			$price    = $_POST['price'];
    
    			$m = 0;
    			foreach ($unit as $u) 
    			{
    				$price_array    = [
    									'product_id'       => $id,
    									'unit'             => $u,
    									'price'            => $price[$m],
    									'timestamp'        => $timestamp
    								 ];
    				
    				$this->Common->insert('product_price',$price_array);
    				$m++;
    			}
            }
			
            
            if($choice_type=='yes')
            {
                $values    = $_POST['values'];
        		$count     = sizeof($values);
        	
                for ($i=1;$i <=$count; $i++) 
                {
                  $cat_names = $_POST['cat_name'.$i];
                  $cat_types = $_POST['type'.$i];
                  $sel_types = $_POST['selection_type'.$i];
                  $cat_values= $_POST['cat_value'.$i];
                  $cat_prices= $_POST['value_price'.$i];
                  $ca_type   = $_POST['c_type'.$i];
                  
                  $j=0;
                  foreach($cat_names as $cat)
                  {
                      $cat_array = [   
                                      'product_id'     => $id,
                                      'cat_name'       => $cat,
                                      'required'       => $sel_types[$j],
        		                       'type'          => $cat_types[$j],
        		                       'cat_type'      => $ca_type[$j]
                                   ];
    
                      if($c_id = $this->Common->insert('product_choice_categories',$cat_array))
                      {
                          $k=0;
                          foreach($cat_values as $val)
                          {
                              $val_array  = [    
                                                 'pcat_id'    => $c_id,
                                                 'product_id' => $id,
                                                 'name'       => $val,
                		                         'price'      => $cat_prices[$k]
                                            ];
                              $this->Common->insert('product_choices',$val_array);                 
                              $k++;
                          }
                      }
                      $j++;
                  }
                } 
            }

            $branches  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id))->result();
            foreach($branches as $branch)
            {
                $branch_array    =  [
    			                        'branch_id'    => $branch->b_id,
    			                        'r_id'         => $restaurant_id,
    			                        'product_id'   => $id,
    			                        'date'         => date('Y-m-d'),
    			                        'timestamp'    => date('Y-m-d H:i:s')
    			                    ];
    			$this->Common->insert('branch_products',$branch_array);                    
            }
             
	        $this->session->set_flashdata('alert_type', 'success');
		    $this->session->set_flashdata('alert_title', 'Success');
		    $this->session->set_flashdata('alert_message', 'New product added..!');
		    redirect('restaurant/products/index/all');		
        }
        else
        {
            $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add product..!');
			redirect('restaurant/products/add');
        }
	}


//********************************************************** EDIT *************************************************************************************************//	
	public function edit($id)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

        $data['rest']  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row(); 
        
		$check = $this->Common->get_details('products',array('p_id' => $id));
		if ($check->num_rows() > 0) 
		{   
			$product       = $check->row();
			$data['pro']   = $product;
			$data['menu']  = $this->Common->get_details('menu',array('status'=>'1','r_id'=>$restaurant_id))->result();
			
			$prices        = $this->Common->get_details('product_price',array('product_id'=>$id,'status'=>'1'))->result();
			$data['prices']= $prices;
			
			$categories         = $this->Common->get_details('product_choice_categories',array('product_id'=>$id,'status'=>'1'))->result();
			foreach($categories as $cat)
			{
			    $cat->choices   = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id,'status'=>'1'))->result();
			}
            $data['categories'] = $categories;
            
			$this->load->view('restaurant/products/edit',$data);
		}
		else 
		{
			redirect('restaurant/products/index/all');
		}
	}
	
	public function editData()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp    = date('Y-m-d H:i:s');
	    
		$product_id   = $this->input->post('product_id');
		$name         = $this->security->xss_clean($this->input->post('name'));
		$category_id  = $this->security->xss_clean($this->input->post('category_id'));
		$pre_time     = $this->security->xss_clean($this->input->post('prep_time'));
		$code         = $this->security->xss_clean($this->input->post('code'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$size         = $this->security->xss_clean($this->input->post('size'));
		
		$image1     = $this->input->post('image');
        if($image1!='')
        {
            $img1       = substr($image1, strpos($image1, ",") + 1);
    		$url1       = FCPATH.'uploads/restaurant/products';
    		$rand11     = date('Ymd').mt_rand(1001,9999);
    		$userpath1  = $url1.$rand11.'.png';
    		$path1      = "uploads/restaurant/products".$rand11.'.png';
    		
    		if(file_put_contents($userpath1,base64_decode($img1)))
			{
			    $filename = 'uploads/restaurant/products/thumbnail/'.$rand11.'thumb.png'; // output file name
                $fileData = base64_decode($img1);
                $im       = imagecreatefromstring($fileData);
                $source_width = imagesx($im);
                $source_height = imagesy($im);
                $ratio =  $source_height / $source_width;
                
                $new_width  = 300; // assign new width to new resized image
                $new_height = 300*$ratio;
                
                $thumb = imagecreatetruecolor($new_width, $new_height);
                
                $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                
                imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                imagepng($thumb, $filename, 9);
                imagedestroy($im);
                
                // Remove old image from the server
				// $old1 = $this->Common->get_details('products',array('p_id' => $product_id))->row()->thumbnail;
				// $remove_path1 = FCPATH . $old1;
				// unlink($remove_path1);
			}
			else
			{
			    $filename = '';
			}
    		
    		// Remove old image from the server
			$old = $this->Common->get_details('products',array('p_id' => $product_id))->row()->cover_image;
			$remove_path = FCPATH . $old;
			unlink($remove_path);
    		
		    $array        = [     
                                  'name'       => $name,
                                  'cat_id'     => $category_id,
                                  'prep_time'  => $pre_time,
                                  'item_code'  => $code,
                                  'description'=> $description,
                                  'cover_image'=> $path1,
                                  'thumbnail'  => $filename,
                                  'date'       => date('Y-m-d')
                            ];
        }
		else
		{
		    $array        = [     
                              'name'       => $name,
                              'cat_id'     => $category_id,
                              'prep_time'  => $pre_time,
                              'item_code'  => $code,
                              'description'=> $description,
                              'date'       => date('Y-m-d')
                            ];
		}
		
		if($this->Common->update('p_id',$product_id,'products',$array))
		{   
		    if($size =='single')
            {   
                $s_price     = $_POST['single_price'];
    			$pr_id       = $_POST['singleprice_id'];
             
    			$m = 0;
    			foreach ($s_price as $s_pr) 
    			{
    		        $price_id	 = isset($pr_id[$m]) ? $pr_id[$m] : '';
    			    $price_array = [
    									'price'          => $s_pr,
    								];
    							    
    				$this->Common->update('price_id',$price_id,'product_price',$price_array);
    			    $m++;
			   }
            }
            else if($size=='multi')
            {
    		    $unit     = $_POST['unit'];
    			$price    = $_POST['price'];
    			$pr_id    = $_POST['price_id'];
             
    			$m = 0;
    			foreach ($unit as $u) 
    			{
    		        $price_id	 = isset($pr_id[$m]) ? $pr_id[$m] : '';
    			    $price_array = [
    									'unit'           => $u,
    									'price'          => $price[$m],
    									'product_id'     => $product_id,
    									'timestamp'      => $timestamp
    								];
    				if($price_id=='')
    				{
    					$this->Common->insert('product_price',$price_array);
    				}
    				else
    				{					    
    				   $this->Common->update('price_id',$price_id,'product_price',$price_array);
    			    }
    			 $m++;
			   }
            }
    // // // 		$this->Common->delete('product_choice_categories',array('product_id' => $product_id));
    // // // 		$this->Common->delete('product_choices',array('product_id' => $product_id));
    		
    // 		$vals  = $_POST['values'];
    		if(isset($_POST['values']))
    		{
    		    $values    = $_POST['values'];
        		$count     = sizeof($values);
                for ($i=1;$i <=$count; $i++) 
                {
                  $cat_names = $_POST['cat_name'.$i];
                  $cat_types = $_POST['type'.$i];
                  $sel_types = $_POST['selection_type'.$i];
                  $cat_values= $_POST['cat_value'.$i];
                  $cat_prices= $_POST['value_price'.$i];
                  $c_type    = $_POST['c_type'.$i];
                  $categ_id     = $_POST['categ_id'.$i];
                  $cat_value_id = $_POST['prod_id'.$i];
                  
                  $j=0;
                  foreach($cat_names as $cat)
                  {
                      $cat_id	 = isset($categ_id[$j]) ? $categ_id[$j] : '';
                      $cat_array = [   
                                      'product_id'     => $product_id,
                                      'cat_name'       => $cat,
                                      'required'       => $sel_types[$j],
        		                      'type'           => $cat_types[$j],
        		                      'cat_type'       => $c_type[$j],
                                  ];
                      
                      if($cat_id=='')
        			  {
        					if($c_id = $this->Common->insert('product_choice_categories',$cat_array))
                            {
                                  $k=0;
                                  foreach($cat_values as $val)
                                  {
                                      $val_array  = [    
                                                         'pcat_id'    => $c_id,
                                                         'product_id' => $product_id,
                                                         'name'       => $val,
                        		                         'price'      => $cat_prices[$k]
                                                    ];
                                      $this->Common->insert('product_choices',$val_array);                 
                                      $k++;
                                  }
                            }
        			  }
    			 	  else
    				  {					    
    				        if($this->Common->update('pcat_id',$cat_id,'product_choice_categories',$cat_array))
                            {
                                  $k=0;
                                  foreach($cat_values as $val)
                                  {   
                                      $val_id	  = isset($cat_value_id[$k]) ? $cat_value_id[$k] : '';
                                      $val_array  = [    
                                                         'pcat_id'    => $cat_id,
                                                         'product_id' => $product_id,
                                                         'name'       => $val,
                        		                         'price'      => $cat_prices[$k]
                                                    ];
                                      if($val_id=='')
                                      {
                                         $this->Common->insert('product_choices',$val_array);    
                                      }
                                      else
                                      {
                                         $this->Common->update('pchoice_id',$val_id,'product_choices',$val_array); 
                                      }
                                      $k++;
                                  }
                            }
    			      }
                      $j++;
                  }
                }
    		}
            // print_r($vals); 
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('restaurant/products/index/all');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update product..!');
			redirect('restaurant/products/edit/'.$rest_id);
		}
	}

//**************************************************** DISABLE ****************************************************************************************************//
	public function disable()
	{
	    $id    = $this->input->post('product_id');
		$array = [
			       'status' => 'blocked'
		         ];
	
		if ($this->Common->update('p_id',$id,'products',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product blocked successfully..!');
			redirect('restaurant/products/index/all');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block product..!');
			redirect('restaurant/products/index/all');
		}
	}

//************************************************************* ENABLE *******************************************************************************************//
	public function enable()
	{
	    $id    = $this->input->post('product_id');
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('p_id',$id,'products',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product activated successfully..');
			redirect('restaurant/products/index/all');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate product..!');
			redirect('restaurant/products/index/all');
	    }		
	}

//**************************************************** DELETE ****************************************************************************************************//
	public function delete()
	{
	    $id    = $this->input->post('product_id');
		$array = [
			       'status' => 'deleted'
		         ];
	
		if ($this->Common->update('p_id',$id,'products',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product deleted successfully..!');
			redirect('restaurant/products/index/all');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to delete product..!');
			redirect('restaurant/products/index/all');
		}
	}

    public function images($param)
	{
		$check          = $this->Common->get_details('product_images',array('p_id' => $param));
		$data['images']  = $check->result();
		$data['product'] = $this->Common->get_details('products',array('p_id' => $param))->row()->name;
		$data['p_id']    = $param;
		$this->load->view('restaurant/products/gallery',$data);
	}

	public function gallery($id)
	{
		$data['product_id'] = $id;
		$this->load->view('restaurant/products/image',$data);
	}

	public function addImage()
	{
		$product_id = $this->input->post('product_id');
		// $file       = $_FILES['image'];
		// $tar        = "uploads/restaurant/products/";
		// $rand       = date('Ymd').mt_rand(1001,9999);
		// $tar_file   = $tar . $rand.'.png';
		// if(move_uploaded_file($file['tmp_name'], $tar_file))
		$image    = $this->input->post('image');
		$img      = substr($image, strpos($image, ",") + 1);

		$url      = FCPATH.'uploads/restaurant/products/';
		$rand     = date('Ymd').mt_rand(1001,9999);
		$userpath = $url.$rand.'.png';
		$path     = "uploads/restaurant/products/".$rand.'.png';
		if(file_put_contents($userpath,base64_decode($img)))
		{
			$array = [
						'image'      => $path,
						'p_id'       => $product_id
					 ];
			$this->Common->insert('product_images',$array);
		}
		$this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'Image added successfully..');
		redirect('restaurant/products/images/'.$product_id);
	}

	public function deleteImage()
	{
		$param = $_POST['delete_id'];
		$check = $this->Common->get_details('product_images',array('pi_id' => $param));
		if ($check->num_rows() == 1) 
		{      
				$old         = $this->Common->get_details('product_images',array('pi_id' => $param))->row()->image;
				$remove_path = FCPATH . $old;
				unlink($remove_path);

				$this->Common->delete('product_images',array('pi_id' => $param));

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Image deleted successfully..');
				redirect('restaurant/products/images/'.$check->row()->p_id);
		}
		else 
		{
				redirect('restaurant/products/index/all');
		}
	}

//************************************************** DETAILS *****************************************************************************************************//
    public function details($id)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$check = $this->Common->get_details('products',array('p_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['pro'] = $check->row();
			
			$menu = $this->Common->get_details('menu',array('menu_id'=>$check->row()->cat_id));
             if($menu->num_rows()>0)
             {
             	$data['menu'] = $menu->row()->name;
             }
             else
             {
             	$data['menu'] = 'None';
             }

            $categories         = $this->Common->get_details('product_choice_categories',array('product_id'=>$id,'status'=>'1'))->result();
			foreach($categories as $cat)
			{
			    $cat->choices   = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id,'status'=>'1'))->result();
			}
            $data['categories'] = $categories;
            
            $prices        = $this->Common->get_details('product_price',array('product_id'=>$id,'status'=>'1'))->result();
			$data['prices']= $prices;
            
			$this->load->view('restaurant/products/details',$data);
		}
		else 
		{
			redirect('restaurant/products/index/al');
		}
	}

//*************************************************************** GET PRODUCT CHOICE ******************************************************************************//    
    public function getProductChoices()
    {
          $list=array();
          $inputJSON = file_get_contents('php://input');
          $input     = json_decode($inputJSON, TRUE); 
    
          $ProductIDE = $input['CategoryIDE'];
          $categories = $this->Common->get_details('product_choice_categories',array('product_id'=>$ProductIDE))->result();
          
          
          $i=1;
          $Scene='<div id="image'.$i.'"> 
                      <div class="form-row">
                         <div class="col-md-12">
                              <label>Product Choice Category<span style="color: red;">*</span></label>
                              <div class="">
                                <div class="form-group m-b-25">';
          
                                      foreach($categories as $cat)
                                      {    
                                            $Scene .=' <div class="col-md-12">
                                                            <table>
                                                              <thead>
                                                                <tr>
                                                                  <td width="35%">Category Name</td>
                                                                  <td width="20%">Type</td>
                                                                  <td width="30%">Selection Type</td>
                                                                  <td width="30%">Quantity</td>
                                                                  <td width="20%"></td>
                                                                </tr>
                                                              </thead>
                                                              <tr>
                                                                <input type="hidden" name="values[]" value="'.$i.'" >
                                                                <td><input type="text" class="form-control quantity" value="'.$cat->cat_name.'" placeholder="Category Name" name="cat_name'.$i.'[]"></td>
                                                                <td>
                                                                  <select class="form-control" name="c_type'.$i.'[]">
                                                                      <option value="">--Select Type--</option>
                                                                      <option value="add" ' . ($cat->cat_type == 'add' ? 'selected' : '') . '>Add</option>
                                                                      <option value="remove" ' . ($cat->cat_type == 'remove' ? 'selected' : '') . '>Remove</option>
                                                                  </select>
                                                                </td>
                                                                <td>
                                                                  <select class="form-control" name="selection_type'.$i.'[]">
                                                                      <option value="">---Select Type---</option>
                                                                      <option value="1" ' . ($cat->required == '1' ? 'selected' : '') . '>Required</option>
                                                                      <option value="0" ' . ($cat->required == '0' ? 'selected' : '') . '>Not Required</option>
                                                                  </select>
                                                                </td>
                                                                <td><input type="number" min="0" step="any" class="form-control quantity" placeholder="Quantity" value="'.$cat->type.'" name="type'.$i.'[]" required></td>
                                                                <td style="text-align:center;">-</td>
                                                              </tr>
                                                            </table>
                                                            <br>
                                                            
                                                            <table id="price'.$i.'">
                                                              <thead>
                                                                <tr>
                                                                  <td width="60%">Category Value</td>
                                                                  <td width="40%">Price</td>
                                                                  <td width="20%">Delete</td>
                                                                </tr>
                                                              </thead>';
                                                              
                                                              $choices    = $this->Common->get_details('product_choices',array('product_id'=>$ProductIDE,'pcat_id'=>$cat->pcat_id))->result();
                                                              $m=0; foreach($choices as $choice) 
                                                              {
                                                                    $Scene .= '<tr>
                                                                                <td><input type="text" class="form-control" placeholder="Category Value" value="'.$choice->name.'" name="cat_value'.$i.'[]"></td>
                                                                                <td><input type="number" min="0" step="any" class="form-control" value="'.$choice->price.'" name="value_price'.$i.'[]"  placeholder="Price"></td>
                                                                                '. ($m=='0' ? '<td style="text-align:center;"> - </td>' : '') .'
                                                                                '. ($m>'0' ? '<td style="text-align:center;"> <a class="btn btn-link" onclick="deleteRow(this);"><i style="font-size:25px; color:red;" class="fa fa-trash"></i></a> </td>' : '') .'
                                                                              </tr>';
                                                              $m ++ ; }
                                                              $Scene .= '</table>
                                                           
                                                            <p><button type="button" class="btn btn-link" onclick="addRow2('.$i.')" >Add more values</button></p>
                                                            <!--<div class="text-center">-->
                                                            <!--  <button type="button" class="btn btn-link" onclick="addRow()"><i style="font-size:25px;" class="fa fa-plus-circle"></i></button>-->
                                                            <!--</div>-->
                                                          </div>';
                                                          $i++;
                                     };
                $Scene .='</div>
                            </div>
                              </div>
                                </div>
                                  </div>
                                  <div id="add-more">
        
                                  </div>
                              
                                  <div class="form-row">
                                       <button type="button" class="btn btn-primary" style="color: blue;" onclick="addRoww('.$i.')" >Add Product Choice</button>
                                  </div> ';
                $tempData = $Scene;
                $cleanData =  json_encode($tempData);
                print_r($cleanData);
  
    }

//******************************************************** CHECK PRODUCT ****************************************************************************************//
	public function checkProduct() 
	{
        $code     = $this->input->post('code');
        $check    = $this->Common->get_details('products', array('item_code' => $code));
        if($check->num_rows() > 0) 
        {
            $data = '1';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }

//****************************************************************************************************************************************************************//    
    public function updateSizeStatus()
	{
		$price_id      = $_POST['price_id'];
		$array        = [
                			'status'   => '0'
                		];
        
		if ($this->Common->update('price_id',$price_id,'product_price',$array)) 
		    {
			  echo "1";
		    }
		else 
		   {  
			  echo "0";
		   }
	}
	
	public function updateProductStatus()
	{
		$prod_id      = $_POST['prod'];
		$array        = [
                			'status'   => '0'
                		];
        
		if ($this->Common->update('pchoice_id',$prod_id,'product_choices',$array)) 
		    {
			  echo "1";
		    }
		else 
		   {  
			  echo "0";
		   }
	}
	
	public function updateCategoryStatus()
	{
		$cat_id       = $_POST['category'];
		$array        = [
                			'status'   => '0'
                		];
        
		if ($this->Common->update('pcat_id',$cat_id,'product_choice_categories',$array)) 
		    {
			  echo "1";
		    }
		else 
		   {  
			  echo "0";
		   }
	}
}
?>
