<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('restaurant/M_orders','orders');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
//************************************** NEW ***************************************************************************************************************************************//	
	public function new()
    {
        $this->load->view('restaurant/orders/new');
    }
    public function get_new()
	{
        $result = $this->orders->make_new_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            
            $this->Common->update('order_id',$res->order_id,'orders',array('read_status'=>'1'));
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Order Placed';
			$sub_array[]      = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="approve('.$res->order_id.')">Approve</a><br><br><a class="btn btn-danger btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="reject('.$res->order_id.')">Reject</a>';
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_new_all_data(),
							    "recordsFiltered" => $this->orders->get_new_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//****************************************** SCHEDULED *****************************************************************************************************************************//
	public function scheduled()
    {
        $this->load->view('restaurant/orders/scheduled');
    }
    public function get_scheduled()
	{
        $result = $this->orders->make_scheduled_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Order Placed';
			$sub_array[]      = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="approve('.$res->order_id.')">Approve</a><br><br><a class="btn btn-danger btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="reject('.$res->order_id.')">Reject</a>';
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_scheduled_all_data(),
							    "recordsFiltered" => $this->orders->get_scheduled_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//************************************ APPROVED ***************************************************************************************************************************************//	
    public function approved()
    {
        $data['drivers']  = $this->Common->get_details('drivers',array('status'=>'1'))->result();
        $this->load->view('restaurant/orders/approved',$data);
    }
    public function get_approved()
	{
        $result = $this->orders->make_approved_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Approved';
			$sub_array[]      = '<button type="button" class="btn btn-primary" style="font-size:12px;" onclick="add('.$res->order_id.')">Assign</button></a>';
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_approved_all_data(),
							    "recordsFiltered" => $this->orders->get_approved_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	} 
	
//************************************ CANCELLED **********************************************************************************************************************************//	
   public function cancelled()
   {	
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];

	    $orders  = $this->orders->getCancelledOrders($restaurant_id);
		foreach($orders as $order)
		{
			$order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
    	    if($order->type=='guest')
    	    {
    	        if($address_check->num_rows()>0)
    		    {
    		       $address           = $address_check->row();
    	           $order->username   = $address->name;
                   $order->userphone  = $address->mobile;
                   $order->useremail  = '';
    		    }
    		    else
    		    {
    		        $order->username  = '';
                    $order->userphone = '';
                    $order->useremail = '';
    		    }
    	    }
    	    else
    	    {
    	        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    	        $order->username  = $user->firstname.' '.$user->lastname;
                $order->userphone = $user->mobile;
                $order->useremail = $user->email;
    	    }
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
    		    $order->flat       = $address->flat;
    			$order->road_no    = $address->road_no;
    			$order->building   = $address->building_no;
                $order->block      = $address->block;
                $order->landmark   = $address->landmark;
                $order->area       = $address->area;
                $order->mobile     = $address->mobile;
			}
			else
			{
			    $order->area       = '';
    			$order->floor      = '';
    			$order->block      = '';
    			$order->building   = '';
                $order->road_no    = '';
                $order->mobile     = '';
                $order->flat       = '';
			}
            $cancel_check       = $this->Common->get_details('cancelled_orders',array('order_id'=>$order->order_id));
            if($cancel_check->num_rows()>0)
            {  
                $c_order             = $cancel_check->row();
                $order->cancelled_by = $c_order->cancelled_by;
            }
            else
            {
               $order->cancelled_by  = '';
            }
		}
		$data['orders']  = $orders;
		$this->load->view('restaurant/orders/cancelled',$data);
	}    
	
//************************************ ACTIVE *************************************************************************************************************************************//	
	public function active()
    {
        $this->load->view('restaurant/orders/active');
    }
    public function get_active()
	{
        $result = $this->orders->make_active_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            $driver_check     = $this->Common->get_details('driver_orders',array('order_id'=>$res->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order       = $driver_check->row();
                $driver_detail = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $driver        = $driver_detail->name;
                $vehicle       = $driver_detail->vehicle_number;
            }
            else
            {
                $driver = '';
                $vehicle= ''; 
            }
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Active';
            $sub_array[]      = $driver.'<br>'.$vehicle;
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
	     	$sub_array[]      = '<button type="button" class="btn btn-primary" style="font-size:12px;" onclick="dispatch('.$res->order_id.')">Dispatch</button></a>';
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_active_all_data(),
							    "recordsFiltered" => $this->orders->get_active_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//****************************************** DISPATCHED **************************************************************************************************************************//	
	public function dispatched()
    {
        $this->load->view('restaurant/orders/dispatched');
    }
    public function get_dispatched()
	{
        $result = $this->orders->make_dispatched_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Dispatched';
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_dispatched_all_data(),
							    "recordsFiltered" => $this->orders->get_dispatched_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	} 
	
//************************************** COMPLETED ********************************************************************************************************************************//	
	public function completed()
    {
        $this->load->view('restaurant/orders/completed');
    }
    public function get_completed()
	{
        $result = $this->orders->make_completed_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
		    
            $driver_check     = $this->Common->get_details('driver_orders',array('order_id'=>$res->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order       = $driver_check->row();
                $driver_detail = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $driver        = $driver_detail->name;
                $vehicle       = $driver_detail->vehicle_number;
            }
            else
            {
                $driver = '';
                $vehicle= ''; 
            }
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Active';
            $sub_array[]      = $driver.'<br>'.$vehicle;
            $sub_array[]      = date('d M Y',strtotime($res->completed_date)).'<br>'.$res->completed_time;
			$sub_array[]      = '<a href="'.site_url('restaurant/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_completed_all_data(),
							    "recordsFiltered" => $this->orders->get_completed_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//**************************************** ORDER DETAILS ***************************************************************************************************************************//
    public function details($id)
    {
	 	$order            = $this->Common->get_details('orders',array('order_id'=>$id))->row();
 	    $order->rest      = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
		$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
	    if($order->type=='guest')
	    {
	        if($address_check->num_rows()>0)
		    {
		       $address           = $address_check->row();
	           $order->username   = $address->name;
               $order->userphone  = $address->mobile;
               $order->useremail  = '';
		    }
		    else
		    {
		        $order->username  = '';
                $order->userphone = '';
                $order->useremail = '';
		    }
	    }
	    else
	    {
	        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
	        $order->username  = $user->firstname.' '.$user->lastname;
            $order->userphone = $user->mobile;
            $order->useremail = $user->email;
	    }
		$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
		if($address_check->num_rows()>0)
		{
		    $address           = $address_check->row();
		    $order->flat       = $address->flat;
			$order->road_no    = $address->road_no;
			$order->building   = $address->building_no;
            $order->block      = $address->block;
            $order->landmark   = $address->landmark;
            $order->area       = $address->area;
            $order->mobile     = $address->mobile;
		}
		else
		{
		    $order->flat       = '';
			$order->road_no    = '';
			$order->building   = '';
            $order->block      = '';
            $order->landmark   = ''; 
            $order->area       = '';
            $order->mobile     = '';
		}
	 	$order->products   = $this->Common->get_details('ordered_products',array('order_id'=>$id))->result();
        foreach($order->products as $product)
        {
          $extra_check     = $this->Common->get_details('ordered_extras',array('product_id'=>$product->product_id,'order_id'=>$id,'cart_id'=>$product->cart_id));
          $product->extras = $extra_check->result();    
          if($product->type=='p')
             {
                 $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
                //  $product->image        = $p_details->cover_image;
                 $extras                = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
    	         $product->extras       =  $extras;
    	         $sub_total             = 0;
    	         foreach($extras as $extra)
    	         {
    	             $sub_total  = $sub_total+$extra->total;
    	         }
                 $product->total_price  = $product->total+$sub_total;
             }
             else
             {
                 $p_details             = $this->Common->get_details('extras',array('extra_id'=>$product->product_id))->row();
                //  $product->image        = $p_details->image;
                 $product->prep_time    = '0';
                 $product->extras       = array();
                 $product->total_price  = $product->total;
             }
        }
	 	$data['order']      = $order;
// 	 	$data['address']    = $address;
	 	$data['extra_check']= $extra_check;
	 	$this->load->view('restaurant/orders/details',$data);
    }

//************************************* APPROVE *************************************************************************************************************************************//
    public function approve()
    {
        $id    = $this->input->post('order_id');
		$array = [
		             'status' => 'approved'
	             ];
	    if ($this->Common->update('order_id',$id,'orders',$array))
		{   
		    $order         = $this->Common->get_details('orders',array('order_id'=>$id))->row();
		    if($order->type!='guest')
		    {
		        $user          = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    		    $customer_name = $user->firstname.' '.$user->lastname;
    		    $customer_phone= $user->mobile;
    		  //  $address       = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
    		  //  $area          = $address->area;
    		  //  $building      = $address->building_no;
    		  //  $house         = $address->flat.', '.$address->block;
    		    $date          = date('d-M-Y');
    		    $time          = date('h:i A');
    		    $body          = 'Your Order has been approved on '.$date.' at '.$time; 
    		    $this->sendApproveNotification($user->fcm,$body);
		    }
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Order approved..');
			redirect('restaurant/orders/approved');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
			redirect('restaurant/orders/new');
	    }	         
    }
 
//****************************************** REJECT *******************************************************************************************************************************//    
    public function reject()
    {
        // date_default_timezone_set("Asia/Bahrain");
		// date_default_timezone_set('Asia/Kolkata');

        $id    = $this->input->post('order_id');
    	$array = [
		             'status'       => 'cancelled',
					 'cancelled_date'  => date('Y-m-d'),
					 'cancelled_time'  => date('h:i A'),
	             ];
	    if ($this->Common->update('order_id',$id,'orders',$array))
		{   
			$cancel_array   = [
			                        'order_id'        => $id,
			                        'cancelled_date'  => date('Y-m-d'),
			                        'cancelled_time'  => date('h:i A'),
			                        'cancelled_by'    => 'restaurant',
			                        'timestamp'       => date('Y-m-d H:i:s')
			                  ];
			if($this->Common->insert('cancelled_orders',$cancel_array)){
				$order    = $this->Common->get_details('orders',array('order_id'=>$id))->row();

				if($order->type!='guest')
				{
					$user          = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
					$customer_name = $user->firstname.' '.$user->lastname;
					$customer_phone= $user->mobile;
					$date          = date('d-M-Y');
					$time          = date('h:i A');
					$body          = 'Your Order has been cancelled on '.$date.' at '.$time; 
					$title			='Order Cancelled';
					if($this->sendCancelNotification($user->fcm,$body))
						{
							$not_array = [
										'user_id' => $order->user_id,
										'order_id' => $id,
										'title'    => $title,
										'message'  => $body,
										'date'     => date('Y-m-d'),
										'time'     => date('h:i A'),
										'timestamp'=> date('Y-m-d H:i:s')
									];
							$this->Common->insert('notifications',$not_array);
						}	
				}
			}                 
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Order cancelled..');
			redirect('restaurant/orders/cancelled');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to cancel the order..!');
			redirect('restaurant/orders/new');
	    }	   
    }

//*************************************** DISPATCH ********************************************************************************************************************************//    
    public function dispatch()
    {
        // date_default_timezone_set("Asia/Bahrain");
        
        $id    = $this->input->post('order_id');
        $array = [
    		        'status' => 'dispatched'
    	         ];
	    if ($this->Common->update('order_id',$id,'orders',$array))
		{   
		    $status   = [
		                   'dispatched_time'  => date('Y-m-d H:i:s')
		                ];
		    $this->Common->update('order_id',$id,'driver_orders',$status);
		    
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Order dispatched..');
			redirect('restaurant/orders/dispatched');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
			redirect('restaurant/orders/new');
	    }	      
    }

//********************************************* STATUS ****************************************************************************************************************************//
    public function status($param,$id)
	{
		if($param=='1')
		{
			$array = [
			             'status' => 'approved'
		             ];
		    if ($this->Common->update('order_id',$id,'orders',$array))
			{   
			    $order         = $this->Common->get_details('orders',array('order_id'=>$id))->row();
			    $user          = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
			    $customer_name = $user->firstname.' '.$user->lastname;
			    $customer_phone= $user->mobile;
			    $address       = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
			    $area          = $address->area;
			    $building      = $address->building_no;
			    $house         = $address->flat.', '.$address->block;
			    $date          = date('d-M-Y');
			    $time          = date('h:i A');
			    $body          = 'Your Order has been approved on '.$date.' at '.$time; 
			    $this->sendApproveNotification($user->fcm,$body);
			    
			    $date1   = date('Y-m-d');
			    $drivers = $this->orders->getDrivers($address->latitude,$address->longitude,$date1,$time);
                foreach($drivers as $driver)
                {
                    $driver_check_check = $this->Common->get_details('drivers',array('dr_id'=>$driver->driver_id));
                    if($driver_check_check->num_rows()>0)
                    {
                       $device_token  = $driver_check_check->row()->fcm;  
                    }
                    else
                    {
                       $device_token = ''; 
                    }
                    $content       = $customer_name.'('.$customer_phone.') ,'.$building.','.$house.','.$area;
                    $this->sendDrivernotification($device_token,$content);
                }
			 //   print_r($content);
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Order approved..');
				redirect('restaurant/orders/approved');
			}
			else 
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
				redirect('restaurant/orders/new');
		    }	         
		}
		else if($param=='2')
		{
			$array = [
			             'status' => 'dispatched'
		             ];
		    if ($this->Common->update('order_id',$id,'orders',$array))
			{   
			    $status   = [
			                   'dispatched_time'  => date('Y-m-d H:i:s')
			                ];
			    $this->Common->update('order_id',$id,'driver_orders',$status);
			    
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Order dispatched..');
				redirect('restaurant/orders/dispatched');
			}
			else 
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
				redirect('restaurant/orders/new');
		    }	         
		}
		else
		{
			$array = [
			             'status' => 'cancelled',
			             'cancelled_by' => 'restaurant'
		             ];
		    if ($this->Common->update('order_id',$id,'orders',$array))
			{   
				// $cancel  = [
				// 	         'canc'
				//            ]

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Order cancelled..');
				redirect('restaurant/orders/cancelled');
			}
			else 
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to cancel the order..!');
				redirect('restaurant/orders/new');
		    }	          
		}			
	}

//***************************************** ASSIGN DRIVER *************************************************************************************************************************//	
	public function assignDriver()
	{
	    $order_id   = $this->input->post('order_id');
	    $driver_id  = $this->input->post('driver_id');
		$array      = [
		                 'status' => 'processing'
	                  ];
	    if ($this->Common->update('order_id',$order_id,'orders',$array))
		{   
		    $order         = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
		    if($order->type!='guest')
		    {
		        $user          = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    		    $customer_name = $user->firstname.' '.$user->lastname;
    		    $customer_phone= $user->mobile;
    		    $address       = $this->Common->get_details('ordered_address',array('order_id'=>$order_id))->row();
    		    $area          = $address->area;
    		    $building      = $address->landmark;
    		    $house         = $address->flat.', '.$address->building_no.', '.$address->road_no ;
    		    $date          = date('d-M-Y');
    		    $time          = date('h:i A');
    		    $body          = 'Your Order has been approved on '.$date.' at '.$time; 
		    }
		    
		  //  $this->sendApproveNotification($user->fcm,$body);
		    else
		    {
		        $address_check = $this->Common->get_details('ordered_address',array('order_id'=>$order_id));
		        if($address_check->num_rows()>0)
		        {
		            $address       = $address_check->row();
		            $customer_name = $address->name;
    		        $customer_phone= $address->mobile; 
    		        $area          = $address->area;
    		        $building      = $address->landmark;
    		        $house         = $address->flat.', '.$address->building_no.', '.$address->road_no ;
		        }
		        else
		        {
		            $customer_name = '';
    		        $customer_phone= ''; 
    		        $area          = '';
    		        $building      = '';
    		        $house         = '' ;
		        }
		    }
		    $date1         = date('Y-m-d');
		    $driver        = $this->Common->get_details('drivers',array('dr_id'=>$driver_id));
            $device_token  = $driver->row()->fcm;  
            $content       = $customer_name.'('.$customer_phone.'), '.$house.', '.$building.', '.$area;
            $driver_array  = [
        		                'order_id'      => $order_id,
        		                'driver_id'     => $driver_id,
        		                'r_id'          => $order->r_id,
        		                'status'        => 'assigned',
        		                'assigned_time' => date('Y-m-d H:i:s'),
        		                'timestamp'     => date('Y-m-d H:i:s')
        		              ];
        	if($this->Common->insert('driver_orders',$driver_array))
        	{
                // $this->sendDrivernotification($device_token,$content);
				$order        = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
				if($order){
					if($order ->type =='user')
					{
						$customer        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
						$title = 'New Order!...';
						$body   ='Your have a new order from '.$customer->firstname.' '.$customer->lastname.' with ID:'.$order_id;
						if($this->sendDrivernotification($device_token,$body))
						{
							$not_array = [
										'driver_id' => $driver_id,
										'order_id' => $order_id,
										'title'    => $title,
										'message'  => $body,
										'date'     => date('Y-m-d'),
										'time'     => date('h:i A'),
										'timestamp'=> date('Y-m-d H:i:s')
									];
							$this->Common->insert('notifications',$not_array);
						}
					}else{
						$title = 'New Order!...';
						$body   ='Your have a new order with ID:'.$order_id;
						if($this->sendDrivernotification($device_token,$body))
						{
							$not_array = [
										'driver_id' => $driver_id,
										'order_id' => $order_id,
										'title'    => $title,
										'message'  => $body,
										'date'     => date('Y-m-d'),
										'time'     => date('h:i A'),
										'timestamp'=> date('Y-m-d H:i:s')
									];
							$this->Common->insert('notifications',$not_array);
						}	
					}
				}else{
					$title = 'New Order!...';
					$body   ='Your have a new order!....';
					if($this->sendDrivernotification($device_token,$content))
					{
						$not_array = [
									'driver_id' => $driver_id,
									 'order_id' => $order_id,
									 'title'    => $title,
									 'message'  => $body,
									 'date'     => date('Y-m-d'),
									 'time'     => date('h:i A'),
									 'timestamp'=> date('Y-m-d H:i:s')
								 ];
						$this->Common->insert('notifications',$not_array);
					}
				}
        	}
        	
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Order assigned to driver successfully..');
			redirect('restaurant/orders/active');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to assign the driver..!');
			redirect('restaurant/orders/new');
	    }	         
	}

//************************************************************* DRIVER NOTIFICATION ************************************************************************************************//
    public function sendDrivernotification($id,$content)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => 'New Order',
    		'body'  => $content
    	];
    	
    	$notification = [
    		'title'             => 'New Order',
    		'body'              => $content,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $id,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}

//************************************************************ APPROVE NOTIFICATION ***********************************************************************************************//	
	public function sendApproveNotification($id,$content)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => 'New Order',
    		'body'  => $content
    	];
    	
    	$notification = [
    		'title'             => 'New Order',
    		'body'              => $content,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $id,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
//************************************************************ CANCEL NOTIFICATION ***********************************************************************************************//	
public function sendCancelNotification($id,$content)
{
	$SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
	$header = [
		'Authorization: key='. $SERVER_API_KEY,
		'Content-Type: Application/json'
	];
	$msg = [
		'title' => 'Order Cancelled',
		'body'  => $content
	];
	
	$notification = [
		'title'             => 'Order Cancelled',
		'body'              => $content,
		'content_available' => true
	];
	
	$payload = [
		'data'         => $msg,
		'notification' => $notification,
		'to'           => $id,
		'priority'     => 10
	];
	$url = 'https://fcm.googleapis.com/fcm/send';

	$curl = curl_init();

	curl_setopt_array($curl, array(
		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
		 CURLOPT_RETURNTRANSFER => true,
		 CURLOPT_CUSTOMREQUEST  => "POST",
		 CURLOPT_POSTFIELDS     => json_encode($payload),
		 CURLOPT_HTTPHEADER     => $header,
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);
	
	return true;
}

	
}
?>
