<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Offers extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('restaurant/M_offers','offer');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	
//coupons//	
	public function coupons()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$coupons  = $this->offer->getCoupons($restaurant_id);
		foreach($coupons as $coup)
		{
			$coup->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$coup->r_id))->row()->rest_name;
		}
		$data['coupons'] = $coupons;
		$this->load->view('restaurant/offers/view_coupon',$data);
	}

//promotions//
   	public function promotions()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$promotions    = $this->offer->getPromotions($restaurant_id);
		foreach($promotions as $pro)
		{
			$pro->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$pro->r_id))->row()->rest_name;
		}
		$data['promotions'] = $promotions;

		$this->load->view('restaurant/offers/view_promotions',$data);
	}

	public function addPromotion()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$title        = $this->security->xss_clean($this->input->post('title'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$price        = $this->security->xss_clean($this->input->post('price'));
		
        $file       = $_FILES['image'];
		if($file['name']!='')
		{
            $tar1        = "uploads/restaurant/promotion/";
			$rand1       = date('Ymd').mt_rand(1001,9999);
			$tar_file1   = $tar1 . $rand1.'.png';
			move_uploaded_file($file['tmp_name'], $tar_file1);
		}
		else
		{
			$tar_file1  = '';
		}
		$data         = [
			              'r_id'            => $restaurant_id,
			              'description'     => $description,
			              'title'           => $title,
			              'price'           => $price,
			              'image'           => $tar_file1,
			              'status'          => 'requested',
			              'added_date'      => date('Y-m-d'),
			              'timestamp'       => date('Y-m-d H:i:s')
		                ];
		
		if ($this->Common->insert('promotions',$data)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion added successfully..!');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add promotion..!');
		}
		redirect('restaurant/offers/promotions');
	}

	public function editPromotion()
	{   
		$promotion_id = $this->security->xss_clean($this->input->post('promotion_id'));
		$title        = $this->security->xss_clean($this->input->post('title'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$price        = $this->security->xss_clean($this->input->post('price'));
        
        $file         = $_FILES['image'];
		if($file['name']!='')
		{
            $tar1        = "uploads/restaurant/promotion/";
			$rand1       = date('Ymd').mt_rand(1001,9999);
			$tar_file1   = $tar1 . $rand1.'.png';
			move_uploaded_file($file['tmp_name'], $tar_file1);
            
            $data         = [
				              'description'     => $description,
				              'title'           => $title,
				              'price'           => $price,
				              'image'           => $tar_file1
			                ]; 

		}
		else
		{
			$data         = [
				              'description'     => $description,
				              'title'           => $title,
				              'price'           => $price
			                ]; 
		}

		if ($this->Common->update('pr_id',$promotion_id,'promotions',$data)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion updated successfully..!');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to edit promotion..!');
		}
		redirect('restaurant/offers/promotions');
	}

	public function disable_promotion($id)
	{
		$array = [
			       'status' => 'blocked'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion blocked successfully..!');
			redirect('restaurant/offers/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block promotion..!');
			redirect('restaurant/offers/promotions');
		}
	}
	
	public function enable_promotion($id)
	{
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Coupon activated successfully..');
			redirect('restaurant/offers/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate coupon..!');
			redirect('restaurant/offers/promotions');
	    }		
	}

	public function getPromotionDetails()
	{
		$promotion_id    = $_POST['id'];
		$promotion          = $this->Common->get_details('promotions',array('pr_id'=>$promotion_id))->row();
		$data  = $promotion;
	    print_r(json_encode($data));
	}
    
    public function checkCoupon()
    {
    	$code = $this->input->post('code');
    	$check= $this->Common->get_details('promotions',array('offer_code'=>$code));
    	if($check->num_rows()>0)
    	{
    		$data = '1';
    	}
        else
        {
        	$data = '0';
        }
        print_r($data);
    }

    public function checkCouponById()
    {
    	$code = $this->input->post('code');
    	$id   = $this->input->post('id');
    	$check= $this->Common->get_details('promotions',array('offer_code'=>$code,'pr_id!='=>$id));
    	if($check->num_rows()>0)
    	{
    		$data = '1';
    	}
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
    
    
//Product Offers//
   public function product_offers()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$offers  = $this->offer->getOffers($restaurant_id);
		foreach($offers as $off)
		{
			$off->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$off->r_id))->row()->rest_name;
			$product         =$this->Common->get_details('products',array('p_id'=>$off->product_id))->row(); 
			$off->product    = $product->name;
		}
		$data['offers'] = $offers;
		$products       = $this->Common->get_details('products',array('r_id'=>$restaurant_id,'status'=>'active'))->result();
		$data['products']= $products;
		$this->load->view('restaurant/offers/view_offers',$data);
	}
 
	public function addOffer()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$product_id   = $this->security->xss_clean($this->input->post('product_id'));
		$percentage   = $this->security->xss_clean($this->input->post('percentage'));
		$start_date   = $this->security->xss_clean($this->input->post('start_date'));
		$end_date     = $this->security->xss_clean($this->input->post('end_date'));
		$code         = $this->security->xss_clean($this->input->post('code'));
// 		$start_time   = $this->security->xss_clean($this->input->post('start_time'));
// 		$end_time     = $this->security->xss_clean($this->input->post('end_time'));

		$data         = [
			              'r_id'            => $restaurant_id,
			              'product_id'      => $product_id,
			              'percentage'      => $percentage,
			              'start_date'      => $start_date,
			              'end_date'        => $end_date,
			              'offer_code'      => $code,
			             // 'start_time'      => $start_time,
			             // 'end_time'        => $end_time,
			              'added_date'      => date('Y-m-d'),
			              'timestamp'       => date('Y-m-d H:i:s')
		                ];
		
		if ($this->Common->insert('offers',$data)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Offer added successfully..!');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add offer..!');
		}
		redirect('restaurant/offers/product_offers');
	}

	public function editOffer()
	{   
		$offer_id     = $this->security->xss_clean($this->input->post('offer_id'));
		$product_id   = $this->security->xss_clean($this->input->post('product_id'));
		$percentage   = $this->security->xss_clean($this->input->post('percentage'));
		$cart         = $this->security->xss_clean($this->input->post('cart'));
		$start_date   = $this->security->xss_clean($this->input->post('start_date'));
		$end_date     = $this->security->xss_clean($this->input->post('end_date'));
		$code         = $this->security->xss_clean($this->input->post('code'));
// 		$start_time   = $this->security->xss_clean($this->input->post('start_time'));
// 		$end_time     = $this->security->xss_clean($this->input->post('end_time'));
        
        $offer_check  = $this->offer->checkofferById($product_id,$offer_id,$start_date);
        $check_code   = $this->Common->get_details('offers',array('offer_code'=>$code,'offer_id!='=>$offer_id));
        if($offer_check->num_rows()>0)
        {
            $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Offer already exists..!');
        }
        elseif($check_code->num_rows()>0)
        {
            $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Offer Code already exists..!');
        }
        else
        {
        	$data         = [
    			              'product_id'      => $product_id,
    			              'percentage'      => $percentage,
    			              'start_date'      => $start_date,
    			              'end_date'        => $end_date,
    			              'offer_code'      => $code,
    			             // 'start_time'      => $start_time,
    			             // 'end_time'        => $end_time
    		                ];
		
			if ($this->Common->update('offer_id',$offer_id,'offers',$data)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Offer updated successfully..!');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to edit offer..!');
			}
        }	
		redirect('restaurant/offers/product_offers');
	}

	public function disable_offer()
	{
	    $id    =  $this->input->post('offer_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('offer_id',$id,'offers',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Offer blocked successfully..!');
			redirect('restaurant/offers/product_offers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block offer..!');
			redirect('restaurant/offers/product_offers');
		}
	}
	
	public function enable_offer()
	{   
	    $id    =  $this->input->post('offer_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('offer_id',$id,'offers',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Offer activated successfully..');
			redirect('restaurant/offers/product_offers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate offer..!');
			redirect('restaurant/offers/product_offers');
	    }		
	}

	public function getOfferDetails()
	{  
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		
		$offer_id       = $_POST['id'];
		$offer          = $this->Common->get_details('offers',array('offer_id'=>$offer_id))->row();
		$data['offer']  = $offer;
		$products     = $this->Common->get_details('products',array('r_id'=>$restaurant_id,'status' =>'active'))->result();
		$options = '<option value="">-- Choose Product ---</option>';
         foreach ($products as $pr) 
         {
            if ($pr->p_id == $offer->product_id) 
            {
                $options = $options . '<option value="' . $pr->p_id . '" selected>' . $pr->name . '</option>';
            }
            else 
            {
                $options = $options . '<option value="' . $pr->p_id . '">' . $pr->name . '</option>';
            }
        }
        $data['products'] = $options;
		print_r(json_encode($data));
	}
    
    public function checkOffer()
    {
        $date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');

	    $product_id  = $this->input->post('product_id');
	    $start_date  = $this->security->xss_clean($this->input->post('start_date'));
        $end_date    = $this->security->xss_clean($this->input->post('end_date '));
        $code        = $this->security->xss_clean($this->input->post('code'));
        $check_code  = $this->Common->get_details('offers',array('offer_code'=>$code));
        $start_check = $this->offer->checkOfferStart($product_id,$start_date);
        if($start_check->num_rows()>0)
        {   
        	$data  = '1';
        }
        elseif($check_code->num_rows()>0)
        {
            $data  ='2';
        }
        else
        {
        	$data  = '0';
        }

        print_r($data);
       
    }

	
}
?>
