<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_menu','menu');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function getMenu()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$data['menu']  = $this->menu->getMenu($restaurant_id);
		$this->load->view('restaurant/menu/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('menu',array('menu_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('menu',array('name' => $name,'r_id'=>$restaurant_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Category already exists..!');
			redirect('restaurant/menu/getMenu');
		}
		else
		{
			$array = [
				        'r_id'       => $restaurant_id,
						'name'       => $name,
						'status'     => '1',
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('menu',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New category style added..!');
				redirect('restaurant/menu/getMenu');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add category style...!');
				redirect('restaurant/menu/getMenu');
			}
		}
	}
	public function editData()
	{
		$menu_id  = $this->input->post('menu_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('menu',array('name' => $name, 'menu_id!=' => $menu_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Category already exists..!');
			redirect('restaurant/menu/getMenu');
		}
		else {
				$array = [
							'name'  => $name,
					    ];			
			if ($this->Common->update('menu_id',$menu_id,'menu',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('restaurant/menu/getMenu');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update menu..!');
				redirect('restaurant/menu/getMenu');
			}
		}
	}

	public function disable($id)
	{
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('menu_id',$id,'menu',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Menu blocked successfully..!');
			redirect('restaurant/menu/getMenu');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block menu..!');
			redirect('restaurant/menu/getMenu');
		}
	}

	public function enable($id)
	{
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('menu_id',$id,'menu',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Menu activated successfully..');
			redirect('restaurant/menu/getMenu');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate menu..!');
			redirect('restaurant/restaurants/getMenu');
	    }		
	}
}
?>
