<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Extras extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_extras','extras');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function index()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$data['extras']= $this->extras->getExtras($restaurant_id);
		$this->load->view('restaurant/extras/view',$data);
	}

	public function add()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
		$this->load->view('restaurant/extras/add');
	}

	public function edit($id)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
		$check = $this->Common->get_details('extras',array('extra_id' => $id));
		if ($check->num_rows() > 0) 
		{   
			$extras         = $check->row();
			$data['extra']  = $extras;
			$this->load->view('restaurant/extras/edit',$data);
		}
		else 
		{
			redirect('restaurant/extras');
		}
	}
	
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$name       = $this->security->xss_clean($this->input->post('name'));
		$code       = $this->security->xss_clean($this->input->post('code'));
		$price      = $this->security->xss_clean($this->input->post('price'));
		$description= $this->security->xss_clean($this->input->post('description'));
		$check      = $this->extras->checkString($name,$restaurant_id);
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Extra name already exists..!');
			redirect('restaurant/extras');
		}
		else
		{   
            $image1       = $this->input->post('image');
        
            $img1       = substr($image1, strpos($image1, ",") + 1);
    		$url1       = FCPATH.'uploads/restaurant/extras';
    		$rand11     = date('Ymd').mt_rand(1001,9999);
    		$userpath1  = $url1.$rand11.'.png';
    		$path1      = "uploads/restaurant/extras".$rand11.'.png';
    		file_put_contents($userpath1,base64_decode($img1));
        
			$array = [
				        'r_id'       => $restaurant_id,
						'name'       => $name,
						'description'=> $description,
						'price'      => $price,
						'image'      => $path1,
						'status'     => '1',
						'item_code'  => $code,
						'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('extras',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New extra added..!');
				redirect('restaurant/extras');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add extras...!');
				redirect('restaurant/extras/add');
			}
		}
	}
	public function editData()
	{
		$extra_id   = $this->input->post('extra_id');
		$name       = $this->security->xss_clean($this->input->post('name'));
		$code       = $this->security->xss_clean($this->input->post('code'));
		$description= $this->security->xss_clean($this->input->post('description'));
		$price      = $this->security->xss_clean($this->input->post('price'));
		$check      = $this->extras->checkStringById($name,$extra_id);
		$check_code = $this->Common->get_details('extras',array('item_code'=>$code,'extra_id!='=>$extra_id));
		if($check > 0)
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Extra name already exists..!');
			redirect('restaurant/extras/edit/'.$extra_id);
		}
		elseif($check_code->num_rows()>0)
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Item code already exists..!');
			redirect('restaurant/extras/edit/'.$extra_id);
		}
		else
		{
		     $image1       = $this->input->post('image');
             if($image1!='')
             {
                $img1       = substr($image1, strpos($image1, ",") + 1);
        		$url1       = FCPATH.'uploads/restaurant/extras';
        		$rand11     = date('Ymd').mt_rand(1001,9999);
        		$userpath1  = $url1.$rand11.'.png';
        		$path1      = "uploads/restaurant/extras".$rand11.'.png';
    		    file_put_contents($userpath1,base64_decode($img1));
		     
    			$array    = [
        						'name'       => $name,
        						'description'=> $description,
        						'price'      => $price,
        						'item_code'  => $code,
        						'image'      => $path1
        					 ];
             }
    		 else
    		 {
    		     $array  =  [
        						'name'       => $name,
        						'description'=> $description,
        						'price'      => $price,
        						'item_code'  => $code,
        					 ];
    		 }
        		
    		if ($this->Common->update('extra_id',$extra_id,'extras',$array)) 
    		{
    			$this->session->set_flashdata('alert_type', 'success');
    			$this->session->set_flashdata('alert_title', 'Success');
    			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
    			redirect('restaurant/extras');
    		}
    		else
    		{
    			$this->session->set_flashdata('alert_type', 'error');
    			$this->session->set_flashdata('alert_title', 'Failed');
    			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
    			redirect('restaurant/extras');
    		}
		}
		
	}

	public function disable()
	{
	    $id    = $this->input->post('extra_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('extra_id',$id,'extras',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Item blocked successfully..!');
			redirect('restaurant/extras');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block item..!');
			redirect('restaurant/extras');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('extra_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('extra_id',$id,'extras',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Item activated successfully..');
			redirect('restaurant/extras');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate item..!');
			redirect('restaurant/extras');
	    }		
	}
	
	public function checkExtra() 
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
		
        $code        = $this->input->post('code');
        $name        = $this->input->post('name');
        $check_code  = $this->Common->get_details('extras', array('item_code'  => $code));
        $check_name  = $this->extras->checkString($name,$restaurant_id);
        if($check_name > 0) 
        {
            $data = '1';
        }
        elseif($check_code->num_rows() > 0)
        {
            $data = '2';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
}
?>
