<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_dashboard','dash');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	
	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
        
        $branch_check  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id,'branch_type'=>'2'));
        if($branch_check->num_rows()>0) {
            $branch_id = $branch_check->row()->b_id;
        } else {
            $branch_id = 0;
        }
        
        $products      = $this->dash->getProducts($restaurant_id);
        foreach($products as $product)
        {
            $product->prices = $this->Common->get_details('product_price',array('product_id'=>$product->p_id,'status'=>'1'))->result();
        }
        $data['products']    = $products;
        $data['orders']      = $this->dash->getOrders($restaurant_id);
        $data['categories']  = $this->dash->getCategories($restaurant_id);

        $data['product']     = $this->Common->get_details('products',array('r_id'=>$restaurant_id,'status'=>'active'))->num_rows();
        $data['category']    = $this->Common->get_details('menu',array('r_id'=>$restaurant_id,'status'=>'1'))->num_rows();
        $data['cuisine']     = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$restaurant_id))->num_rows();
        $data['order']       = $this->dash->getOrderCount($restaurant_id);
        $data['cancelled_today'] = $this->dash->getTodaysCancelledOrderCount($restaurant_id);
        
        $data['new_orders']  = $this->Common->get_details('orders',array('r_id'=>$restaurant_id,'read_status'=>'0'))->num_rows();
        $data['new_ratings'] = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id,'read_status'=>'0'))->num_rows();

		$this->load->view('restaurant/dashboard/dashboard',$data);
	}
	
//************************************* CHANGE PASSWORD ************************************************************************************************************//	
	public function changePassword()
    {
        $rest_id   = $this->security->xss_clean($this->input->post('rest_id'));
        $password  = $this->security->xss_clean($this->input->post('password'));

        $array = [
		            'rest_password' => md5($password),
		            'password'      => $password
		         ];

        $this->Common->update('r_id',$rest_id,'restaurants',$array);
        $this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'Password changed successfully...!');
        redirect('restaurant/dashboard');
    }
    
}
?>
