<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('admin/M_customers','customer');
			if (!admin()) {
				redirect('app');
			}
	}
	public function index()
	{
		$this->load->view('admin/customers/view');
	}
	public function get()
	{
		$result = $this->customer->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-danger" style="font-size:12px;" href="' . site_url('admin/customers/disable/'.$res->user_id) . '" >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success" style="font-size:12px;" href="' . site_url('admin/customers/enable/'.$res->user_id) . '" >Enable</a>';
			}
			$sub_array   = array();
			$sub_array[] = $res->firstname.' '.$res->lastname;;
			$sub_array[] = $res->mobile;
			$sub_array[] = $res->email;
			$sub_array[] = $status.'<br>'.$action;
			$data[]      = $sub_array;
		}

		$output = array(
			"draw"   => intval($_POST['draw']),
			"recordsTotal" => $this->customer->get_all_data(),
			"recordsFiltered" => $this->customer->get_filtered_data(),
			"data" => $data
		);
		echo json_encode($output);
	}

	//Block member//
	public function disable($id)
	{
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member blocked successfully..!');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block member..!');
			redirect('admin/customers');
		}
	}

  //Activate user//	
	public function enable($id)
	{
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member activated successfully..');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate member..!');
			redirect('admin/customers');
	    }		
	}

}
?>
