<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cuisines extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_cuisines','cuisines');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$cuisines      = $this->cuisines->getCusines($restaurant_id);
		foreach($cuisines as $cu)
		{
			$cuisine    = $this->Common->get_details('cuisines',array('c_id'=>$cu->c_id))->row();    
			$cu->name   = $cuisine->name;
            $cu->stat   = $cuisine->status;
		}
		$data['cuisines']  = $cuisines;

		$types           = $this->cuisines->getRestCuisines();
		foreach($types as $type)
		{   
			$stat_check  = $this->cuisines->getRestCuisineStat($type->c_id,$restaurant_id);
			if($stat_check>0)
			{
				$type->stat  = '1';
			}
			else
			{
				$type->stat  = '0';
			}
		}
		$data['types']  = $types;
		$this->load->view('restaurant/cuisines/view',$data);
	}
	
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$cuisines      = $this->input->post('cuisines');
		
		$this->Common->delete('restaurant_cuisines',array('r_id'=>$restaurant_id));
        foreach($cuisines as $cuisine)
		{ 
		    	$array  = [
    			             'r_id'  => $restaurant_id,
    			             'c_id'  => $cuisine
    		              ];
		        $this->Common->insert('restaurant_cuisines',$array);
		}

		$this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'New cuisine added..!');
		redirect('restaurant/cuisines');
			// print_r($styles);
	}
	
	public function delete()
	{  
	    $id            = $this->input->post('c_id');
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		if($this->Common->delete('restaurant_cuisines',array('r_id'=>$restaurant_id,'rc_id'=>$id)))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Cuisine removed successfully..');
			redirect('restaurant/cuisines');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove cuisine..!');
			redirect('admin/restaurants');
	    }		
	}
}
?>
