<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Categories extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model('restaurant/Model_categories', 'category');
        if (!restaurant()) {
            redirect('users/restaurant');
        }
    }
    public function active() {
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$data['menu']  = $this->category->getMenu($restaurant_id);
        $this->load->view('restaurant/categories/view',$data);
    }
    public function blocked() {
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$data['menu']  = $this->category->getBlockedMenu($restaurant_id);
        $this->load->view('restaurant/categories/blocked',$data);
    }
    public function getDetails() {
        $id = $this->input->post('id');
        $check = $this->category->get_details('menu', array('menu_id' => $id));
        if ($check->num_rows() > 0) {
            $data = $check->row();
        } else {
            $data = '';
        }
        print_r(json_encode($data));
    }
    public function addData() {
        $restaurant = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        $name = $this->security->xss_clean($this->input->post('name'));
        $check = $this->category->get_details('menu', array('name' => $name, 'r_id' => $restaurant_id))->num_rows();
        if ($check > 0) {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Category already exists..!');
            redirect('restaurant/categories');
        } else {
            $array = ['r_id' => $restaurant_id, 'name' => $name, 'status' => '1', 'timestamp' => date('Y-m-d H:i:s') ];
            if ($this->category->insert('menu', $array)) {
                $this->session->set_flashdata('alert_type', 'success');
                $this->session->set_flashdata('alert_title', 'Success');
                $this->session->set_flashdata('alert_message', 'New category added..!');
                redirect('restaurant/categories/active');
            } else {
                $this->session->set_flashdata('alert_type', 'error');
                $this->session->set_flashdata('alert_title', 'Failed');
                $this->session->set_flashdata('alert_message', 'Failed to add category...!');
                redirect('restaurant/categories/active');
            }
        }
    }
    public function editData() {
        $menu_id = $this->input->post('menu_id');
        $name = $this->security->xss_clean($this->input->post('name'));
        $check = $this->category->get_details('menu', array('name' => $name, 'menu_id!=' => $menu_id))->num_rows();
        if ($check > 0) {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Category already exists..!');
            redirect('restaurant/categories/active');
        } else {
            $array = ['name' => $name, ];
            if ($this->category->update('menu_id', $menu_id, 'menu', $array)) {
                $this->session->set_flashdata('alert_type', 'success');
                $this->session->set_flashdata('alert_title', 'Success');
                $this->session->set_flashdata('alert_message', 'Catgeory updated successfully..!');
                redirect('restaurant/categories/active');
            } else {
                $this->session->set_flashdata('alert_type', 'error');
                $this->session->set_flashdata('alert_title', 'Failed');
                $this->session->set_flashdata('alert_message', 'Failed to update category..!');
                redirect('restaurant/categories/active');
            }
        }
    }
    public function disable()
    {
        $id    = $this->input->post('cat_id');
        $array = ['status' => '0'];
        if ($this->category->update('menu_id', $id, 'menu', $array)) {
            $this->session->set_flashdata('alert_type', 'success');
            $this->session->set_flashdata('alert_title', 'Success');
            $this->session->set_flashdata('alert_message', 'Category blocked successfully..!');
            redirect('restaurant/categories/blocked');
        } else {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Failed to block category..!');
            redirect('restaurant/categories/active');
        }
    }
    public function enable() 
    {
        $id    = $this->input->post('cat_id');
        $array = ['status' => '1'];
        if ($this->category->update('menu_id', $id, 'menu', $array)) {
            $this->session->set_flashdata('alert_type', 'success');
            $this->session->set_flashdata('alert_title', 'Success');
            $this->session->set_flashdata('alert_message', 'Menu activated successfully..');
            redirect('restaurant/categories/active');
        } else {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Failed to activate menu..!');
            redirect('restaurant/categories/blocked');
        }
    }
    
    public function delete() 
    {
        $id    = $this->input->post('cat_id');
        $array = ['status' => '2'];
        if ($this->category->update('menu_id', $id, 'menu', $array)) {
            $this->session->set_flashdata('alert_type', 'success');
            $this->session->set_flashdata('alert_title', 'Success');
            $this->session->set_flashdata('alert_message', 'Menu deleted successfully..');
            redirect('restaurant/categories/active');
        } else {
            $this->session->set_flashdata('alert_type', 'error');
            $this->session->set_flashdata('alert_title', 'Failed');
            $this->session->set_flashdata('alert_message', 'Failed to delete menu..!');
            redirect('restaurant/categories/active');
        }
    }
}
?>
