<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Branches extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_branches','branches');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}
	public function index()
	{   
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$data['branches']  = $this->branches->getBranches($restaurant_id);
		$this->load->view('restaurant/branches/view',$data);
	}

	public function add()
	{   
	    $data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
		$this->load->view('restaurant/branches/add',$data);
	}
	
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$branch_name  = $this->security->xss_clean($this->input->post('branch_name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
		$password  = $this->security->xss_clean($this->input->post('password'));
		$code      = $this->security->xss_clean($this->input->post('code'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		
		$city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
		
		$check      = $this->Common->get_details('branches',array('email' => $email,'phone'=>$phone))->num_rows();
		$check_email= $this->Common->get_details('restaurants',array('rest_email' => $email))->num_rows();
		$code_check = $this->Common->get_details('branches',array('branch_code' => $code))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Branch already exists..!');
			redirect('restaurant/branches/add');
		}
		else if ($check_email > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email address already registered for a store..!');
			redirect('restaurant/branches/add');
		}
		else if ($code_check > 0) 
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Branch Code already exists..!');
			redirect('restaurant/branches/add');
		}
		else 
		{
			$array = [  
				        'r_id'       => $restaurant_id,
				        'branch_name'=> $branch_name,
				        'branch_code'=> $code,
						'phone'      => $phone,
						'email'      => $email,
						'city_id'    => $city_id,
						'city'       => $city,
						'address'    => $address_1,
						'location'   => $landmark,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
						'pincode'    => $pincode,
						'country'    => $country,
						'password'   => md5($password),
						'pass'       => $password,
						'open_time'  => $open_time,
						'close_time' => $close_time,
						'status'     => '1',
                        'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($id=$this->Common->insert('branches',$array))
			{
			    $products   = $this->Common->get_details('products',array('r_id'=>$restaurant_id,'status'=>'active'))->result();
			    foreach($products as $prod)
			    {
			        $p_array =  [
			                        'branch_id'    => $id,
			                        'r_id'         => $restaurant_id,
			                        'product_id'   => $prod->p_id,
			                        'date'         => date('Y-m-d'),
			                        'timestamp'    => date('Y-m-d H:i:s')
			                    ];
			        $this->Common->insert('branch_products',$p_array);            
			    }
			    
			    $promotions   = $this->Common->get_details('promotions',array('r_id'=>$restaurant_id))->result();
			    foreach($promotions as $promo)
			    {
			        $promotion_array    = [
			                                 'r_id'       => $restaurant_id,
			                                 'branch_id'  => $id,
			                                 'promo_id'   => $promo->pr_id,
			                                 'status'     => '1',
			                                 'timestamp'  => date('Y-m-d H:i:s')
			                              ];
    			   $this->Common->insert('branch_promotions',$promotion_array);  
			    }
			    
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New branch added..!');
				redirect('restaurant/branches');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add branch...!');
				redirect('restaurant/branches/add');
			}
		}
	}
//Branch edit//
	public function edit($id)
	{
		$data['branch'] = $this->Common->get_details('branches',array('b_id'=>$id))->row();
		$data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
		$this->load->view('restaurant/branches/edit',$data);
	}

	public function editData()
	{
		$branch_id   = $this->input->post('branch_id');
		$branch_name  = $this->security->xss_clean($this->input->post('branch_name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
		$code      = $this->security->xss_clean($this->input->post('code'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		
		$city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
		
		
		$check     = $this->Common->get_details('branches',array('email' => $email,'phone'=>$phone, 'b_id!=' => $branch_id))->num_rows();
		$check_email= $this->Common->get_details('restaurants',array('rest_email' => $email))->num_rows();
		$code_check= $this->Common->get_details('branches',array('branch_code' => $code,'b_id!=' => $branch_id))->num_rows();
		
		$check_phone = $this->Common->get_details('branches',array('phone'=>$phone, 'b_id!=' => $branch_id))->num_rows();
		$check_mail  = $this->Common->get_details('branches',array('email'=>$email, 'b_id!=' => $branch_id))->num_rows();
		if($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
			redirect('restaurant/branches/edit/'.$branch_id);
		}
		else if ($check_email > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email address already registered for a store..!');
			redirect('restaurant/branches/edit/'.$branch_id);
		}
		elseif($check_phone > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number already exists..!');
			redirect('restaurant/branches/edit/'.$branch_id);
		}
		elseif($check_mail > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email already exists..!');
			redirect('restaurant/branches/edit/'.$branch_id);
		}
		else if ($code_check > 0) 
		{
		    $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Branch Code already exists..!');
			redirect('restaurant/branches/edit/'.$branch_id);
		}
		else {
			    $array = [ 
						'branch_name'=> $branch_name,
						'phone'      => $phone,
						'email'      => $email,
						'city_id'    => $city_id,
						'city'       => $city,
						'address'    => $address_1,
						'location'   => $landmark,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
						'pincode'    => $pincode,
						'country'    => $country,
						'branch_code'=> $code,
						'open_time'  => $open_time,
						'close_time' => $close_time,
					 ];
			
			if ($this->Common->update('b_id',$branch_id,'branches',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('restaurant/branches');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update branch..!');
				redirect('restaurant/branches/edit/'.$branch_id);
			}
		}
	}

	public function disable()
	{
	    $id    = $this->input->post('branch_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('b_id',$id,'branches',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Branch blocked successfully..!');
			redirect('restaurant/branches');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block branch..!');
			redirect('restaurant/branches');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('branch_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('b_id',$id,'branches',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Branch activated successfully..');
			redirect('restaurant/branches');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate branch..!');
			redirect('restaurant/branches');
	    }		
	}
	
	public function details($id)
	{   
		$data['rest']  = $this->Common->get_details('branches',array('b_id'=>$id))->row();
// 		$types         = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$restaurant_id))->result();
// 		foreach($types as $type)
// 		{
// 			$type->name = $this->Common->get_details('cuisines',array('c_id'=>$type->c_id))->row()->name;
// 		}
// 		$data['types'] = $types;
		$this->load->view('restaurant/branches/details',$data);
	}

	public function checkBranch() 
	{
        $phone = $this->input->post('phone');
        $email = $this->input->post('email');
        $code  = $this->input->post('code');
        $check_phone = $this->Common->get_details('branches', array('phone' => $phone));
        $check_mail  = $this->Common->get_details('branches', array('email' => $email));
        $code_check  = $this->Common->get_details('branches', array('branch_code' => $code));
        if($check_phone->num_rows() > 0) 
        {
            $data = '1';
        } 
        elseif($check_mail->num_rows() > 0) 
        {
            $data = '2';
        }
        elseif($code_check->num_rows() > 0) 
        {
            $data = '3';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }

//change password//
    public function changePassword()
    {
        $branch_id = $this->security->xss_clean($this->input->post('branch_id'));
        $password  = $this->security->xss_clean($this->input->post('password'));

        $array = [
		            'password' => md5($password),
		            'pass'     => $password
		        ];

        $this->Common->update('b_id',$branch_id,'branches',$array);

        $this->session->set_flashdata('alert_type', 'success');
        $this->session->set_flashdata('alert_title', 'Success');
        $this->session->set_flashdata('alert_message', 'Password updated..!');
        redirect('restaurant/branches');
    }    
}
?>
