<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Blocks extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('restaurant/M_blocks','blocks');
			$this->load->model('Common');
			if (!restaurant()) {
				redirect('users/restaurant');
			}
	}

/*Get Branch selected blocks*/	
	public function index()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
        
        $branch_check  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id,'branch_type'=>'2'));
        if($branch_check->num_rows()>0)
        {
            $branch_id  = $branch_check->row()->b_id;
            $blocks     = $this->blocks->getBlocks($branch_id);
        }
		else
		{
		    $blocks     = '';
		}
        $data['blocks'] = $blocks;
		$this->load->view('restaurant/blocks/view',$data);
	}
	
	public function manage()
	{
	    $restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
        
        $branch_check  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id,'branch_type'=>'2'));
        if($branch_check->num_rows()>0)
        {
            $branch_id  = $branch_check->row()->b_id;
            $blocks     = $this->blocks->getAllBlocks();
            foreach($blocks as $block)
    		{   
    			$stat_check  = $this->blocks->getBranchBlockStat($block->block_id,$branch_id);
    			if($stat_check>0)
    			{
    				$block->stat  = '1';
    			}
    			else
    			{
    				$block->stat  = '0';
    			}
    		}
        }
        else
        {
            $blocks     = $this->blocks->getAllBlocks();
			foreach($blocks as $block)
    		{   
    			$block->stat  = '0';
    		}
        }
        $data['blocks'] = $blocks;
        $this->load->view('restaurant/blocks/manage',$data);
	}
	
	public function addData()
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];
        
        $branch_check  = $this->Common->get_details('branches',array('r_id'=>$restaurant_id,'branch_type'=>'2'));
        if($branch_check->num_rows()>0)
        {
            $branch_id  = $branch_check->row()->b_id;
    		$blocks     = $this->input->post('blocks');
    		$this->Common->delete('branch_delivery_blocks',array('branch_id'=>$branch_id));
            foreach($blocks as $block)
    		{ 
    		    	$array  = [
        			             'branch_id'  => $branch_id,
        			             'block_id'   => $block
        		              ];
    		        $this->Common->insert('branch_delivery_blocks',$array);
    		}
    		$this->session->set_flashdata('alert_type', 'success');
    		$this->session->set_flashdata('alert_title', 'Success');
    		$this->session->set_flashdata('alert_message', 'Block added..!');
        } 
        else
        {
            $this->session->set_flashdata('alert_type', 'success');
    		$this->session->set_flashdata('alert_title', 'Success');
    		$this->session->set_flashdata('alert_message', 'Failed to add block..!');
        }
		redirect('restaurant/blocks');
	}
	
	public function delete()
	{  
	    $id            = $this->input->post('block_id');
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		if($this->Common->delete('branch_delivery_blocks',array('bdb_id'=>$id)))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Block removed successfully..');
			redirect('restaurant/blocks');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove block..!');
			redirect('restaurant/blocks');
	    }		
	}
}
?>
