<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Status extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('android/driver/M_status','status');
			$this->load->model('android/driver/M_order','orders');
			$this->load->model('Common');
	}

	public function index_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $status    = $this->security->xss_clean($this->input->post('status'));
        	    $total_sale = 0;
        	    $payment_list = [];

        	    if($status=='today')
        	    {
        		   $total_sale    = $this->status->getTodaysTotalSale($user_id);
        		   $payment_list  = $this->status->getTodaysTotalPaymentList($user_id);
        		   foreach($payment_list as $list)
        		   {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
                            $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		   }
        	    }
        	    elseif($status=='week')
        	    {
        	        $total_sale    = $this->status->getWeeksTotalSale($user_id);
        	        $payment_list  = $this->status->getWeeksTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	             $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    elseif($status=='month')
        	    {
        	        $total_sale    = $this->status->getMonthTotalSale($user_id);
        	        $payment_list  = $this->status->getMonthTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	            $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    elseif($status=='lifetime')
        	    {
        	        $total_sale    = $this->status->getTotalSale($user_id);
        	        $payment_list  = $this->status->getTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	           $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    
        	   	$this->response(array(
                        "status"  => 1,
                       	"message" => "Success",
                        "data"    => [
                    					'payments'  => $total_sale,
                    					'orders'    => $payment_list
                    	            ]  
                ), REST_Controller::HTTP_OK);             
    		}	
            else 
    		{
    			   $this->response(array(
                    	"status"  => 0,
                    	"message" => "Your session has expired, please login again"
                    ), REST_Controller::HTTP_UNAUTHORIZED);
    		}              
	    }
	    else
	    {
	        $this->response(array(
                   "status"  => 0,
                    "message" => "Your session has expired, please login again"
            ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

	public function dashboard_get()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $status    = $this->security->xss_clean($this->input->post('status'));
        	    $total_sale = 0;
        	    $payment_list = [];

        	    $todays_cash    = $this->status->getTodaysTotalSale($user_id);
        	    $todays_pending = $this->status->getTodaysPendingOrders($user_id);
        	    $todays_started = $this->status->getTodaysStartedOrders($user_id);
        	    $todays_completed = $this->status->getTodaysCompletedOrders($user_id);
        		
        	    $monthly_cash    = $this->status->getMonthTotalSale($user_id);
        	    $monthly_pending = $this->status->getMonthlyPendingOrders($user_id);
        	    $monthly_started = $this->status->getMonthlyStartedOrders($user_id);
        	    $monthly_completed = $this->status->getMonthlyCompletedOrders($user_id);

        	    $lifetime_cash    = $this->status->getTotalSale($user_id);
        	    $lifetime_pending = $this->status->getTotalPendingOrders($user_id);
        	    $lifetime_started = $this->status->getTotalStartedOrders($user_id);
        	    $lifetime_completed = $this->status->getTotalCompletedOrders($user_id);
        	    
        	   	$this->response(array(
                        "status"  => 1,
                       	"message" => "Success",
                        "data"    => [
                    			'todays_cash'  => $todays_cash,
                    			'todays_pending' => $todays_pending,
                    			'todays_started' => $todays_started,
                    			'todays_completed' => $todays_completed,
                    			'monthly_cash'    => $monthly_cash,
                    			'monthly_pending' => $monthly_pending,
                    			'monthly_started' => $monthly_started,
                    			'monthly_completed' => $monthly_completed,
                    			'lifetime_cash' => $lifetime_cash,
                    			'lifetime_pending' => $lifetime_pending,
                    			'lifetime_started' => $lifetime_started,
                    			'lifetime_completed' => $lifetime_completed,
                    	            ]  
                ), REST_Controller::HTTP_OK);             
    		}	
            else 
    		{
    			   $this->response(array(
                    	"status"  => 0,
                    	"message" => "Your session has expired, please login again"
                    ), REST_Controller::HTTP_UNAUTHORIZED);
    		}              
	    }
	    else
	    {
	        $this->response(array(
                   "status"  => 0,
                    "message" => "Your session has expired, please login again"
            ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h6';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
}
?>
