<?php
  defined('BASEPATH') OR exit('No direct script access allowed');
  require APPPATH.'libraries/REST_Controller.php';
  require APPPATH.'/libraries/JWT.php';
  class Password extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
	
	public function change_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $old         = md5($this->security->xss_clean($this->input->post('old_password')));
        	    $new         = md5($this->security->xss_clean($this->input->post('new_password')));
        	    
        		$checkPassword = $this->Common->get_details('drivers',array('dr_id' => $user_id,'password'=>$old));
        		if($checkPassword->num_rows()>0)
        		{
        		    $array   = [
        		                'password'  => $new
        		              ];
        		    if($this->Common->update('dr_id',$user_id,'drivers',$array))
        		    {
            		    $this->response(array(
                        		               "status"  => 1,
                        		               "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
        		    }
        		    else
        		    {
        		        $this->response(array(
                        		              "status"  => 0,
                        		              "message" => "Failed"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        		    }
        		}
                else
                {
                    $this->response(array(
                        		              "status"  => 0,
                        		              "message" => "Old password is not correct"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                }
    		}
    		else
    		{
    		    $this->response(array(
                    			        "status"  => 0,
                    			        "message" => "Your session has expired, please login again"
                    			     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function check_driver_post()
	{
	    $mobile      = $this->security->xss_clean($this->input->post('mobile'));
	    $check       = $this->Common->get_details('drivers',array('phone'=>$mobile));
	    if($check->num_rows()>0)
	    {   
	        $driver_id = $check->row()->dr_id;
            $this->response(array(
                		              "status"  => 1,
                		              "message" => "Success",
                		              "data"    => [
            	                                       'driver_id'   => $driver_id
            	                                    ]
                		            ), REST_Controller::HTTP_OK);
	    }
	    else
	    {
	        $this->response(array(
                		              "status" => 0,
                		              "message" => "Not found the driver"
                		            ), REST_Controller::HTTP_NOT_FOUND);
	    }
	}
	
	public function reset_password_post()
	{   
	    $password    = md5($this->security->xss_clean($this->input->post('password')));
	    $user_id     = md5($this->security->xss_clean($this->input->post('driver_id')));
	    
	    $array       = [
		                'password'  => $password
		              ];
	    if($this->Common->update('dr_id',$user_id,'drivers',$array))
	    {
		    $this->response(array(
                		              "status"  => 1,
                		              "message" => "Success"
                		            ), REST_Controller::HTTP_OK);
	    }
	    else
	    {
	        $this->response(array(
                		              "status" => 0,
                		              "message" => "Failed to update password"
                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
	    }
			
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h6';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

}
