<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Orders extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
			$this->load->model('android/driver/M_order','orders');
	}
	
	public function accept_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        		$order_id  = $this->security->xss_clean($this->input->post('order_id'));
                $r_id      = $this->Common->get_details('orders',array('order_id'=>$order_id))->row()->r_id;
        		$status    = [
        			             'status'          => 'processing'
        		              ];
        		if ($this->Common->update('order_id',$order_id,'orders',$status)) 
        		{   
        		    $orders = [
        		                'order_id'      => $order_id,
        		                'driver_id'     => $user_id,
        		                'r_id'          => $r_id,
        		                'status'        => 'assigned',
        		                'assigned_time' => date('Y-m-d H:i:s'),
        		                'timestamp'     => date('Y-m-d H:i:s')
        		              ];
        		    $this->Common->insert('driver_orders',$orders);
        		    
        			$this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
        		}
        		else 
        		{
        				$this->response(array(
                        		              "status" => 0,
                        		              "message" => "Failed to accept orders"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        		}
    	    }
    	    else 
    		{
    			   $this->response(array(
                            			    "status"  => 0,
                            			    "message" => "Your session has expired, please login again"
                            			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

	public function allRequests_get()
	{   
	    $date      = date('Y-m-d');
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    		$orders = [];
            	    
            	    $orders     = $this->orders->getAllOrders($user_id);
            	    foreach($orders as $order)
            	    {   
            	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
            	        if($user) {
	            	        $order->user_firstname = $user->firstname;
	            	        $order->lastname       = $user->lastname;
	            	        $order->user_mobile    = $user->mobile;
	            	        $order->user_email     = $user->email;
	            	    } else {
	            	    	$order->user_firstname = "Guest";
	            	        $order->lastname       = "Guest";
	            	        $order->user_mobile    = "Guest";
	            	        $order->user_email     = "Guest";
	            	    }
            	        
            	        $status_check    = $this->Common->get_details('driver_rejected_orders',array('order_id'=>$order->order_id,'driver_id'=>$user_id));
            	        if($status_check->num_rows()>0)
            	        {
            	            $order->reject_status = true;
            	        }
            	        else
            	        {
            	            $order->reject_status = false;
            	        }
      
            	        $order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
            	               	   // print_r($orders);
            	    }        	    
        	    
        	    $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $orders
                        		            ), REST_Controller::HTTP_OK);
    		}
    	    else 
    		{
    			  $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	// public function newRequests_get()
	// {   
	//     $date      = date('Y-m-d');
	//     $header = $this->input->get_request_header('Authorization');
	//     if ($header != '') 
	//     {
	// 		$user_id = $this->decodeToken($header);
	// 		if ($user_id) 
	// 		{ 
 //        	    $locations = $this->orders->getLatestLocation($user_id);
 //        	    if($locations!='')
 //        	    {
 //            	    $latitude  = $locations->latitude;
 //            	    $longitude = $locations->longitude;
            	    
 //            	    $orders     = $this->orders->getNewRequests($latitude,$longitude,$date);
 //            	    foreach($orders as $order)
 //            	    {   
 //            	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
 //            	        $order->user_firstname = $user->firstname;
 //            	        $order->lastname       = $user->lastname;
 //            	        $order->user_mobile    = $user->mobile;
 //            	        $order->user_email     = $user->email;
            	        
 //            	        $status_check    = $this->Common->get_details('driver_rejected_orders',array('order_id'=>$order->order_id,'driver_id'=>$user_id));
 //            	        if($status_check->num_rows()>0)
 //            	        {
 //            	            $order->reject_status = true;
 //            	        }
 //            	        else
 //            	        {
 //            	            $order->reject_status = false;
 //            	        }
      
 //            	        $order->products = $this->orders->getOrderedProducts($order->order_id);
 //            	        foreach($order->products as $product)
 //            	        {
 //            	            $product->extras = $this->orders->getOrderedExtras($order->order_id,$product->product_id);
 //            	        }
 //            	        $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
 //            	               	   // print_r($orders);
 //            	    }
 //        	    }
 //        	    else
 //        	    {
 //        	        $orders = [];
 //        	    }
        	    
 //        	    $this->response(array(
 //                        		              "status"  => 1,
 //                        		              "message" => "Success",
 //                        		              "data"    => $orders
 //                        		            ), REST_Controller::HTTP_OK);
 //    		}
 //    	    else 
 //    		{
 //    			  $this->response(array(
 //                    			    "status"  => 0,
 //                    			    "message" => "Your session has expired, please login again"
 //                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
 //    		}
	//     }
	//     else
	//     {
	//         $this->response(array(
 //                    			    "status"  => 0,
 //                    			    "message" => "Your session has expired, please login again"
 //                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	//     }
	// }

	public function newRequests_get()
	{   
	    $date      = date('Y-m-d');
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    		$orders = [];
            	    
            	    $orders     = $this->orders->getPendingOrders($user_id);
            	    foreach($orders as $order)
            	    {   
            	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();

            	        if($user) {
	            	        $order->user_firstname = $user->firstname;
	            	        $order->lastname       = $user->lastname;
	            	        $order->user_mobile    = $user->mobile;
	            	        $order->user_email     = $user->email;

	            	    } else {
	            	    	$order->user_firstname = "Guest";
	            	        $order->lastname       = "Guest";
	            	        $order->user_mobile    = "Guest";
	            	        $order->user_email     = "Guest";
	            	    }
            	        
            	        $status_check    = $this->Common->get_details('driver_rejected_orders',array('order_id'=>$order->order_id,'driver_id'=>$user_id));
            	        if($status_check->num_rows()>0)
            	        {
            	            $order->reject_status = true;
            	        }
            	        else
            	        {
            	            $order->reject_status = false;
            	        }
      
            	        $order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
            	               	   // print_r($orders);
            	    }        	    
        	    
        	    	$this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $orders
                        		            ), REST_Controller::HTTP_OK);
    		}
    	    else 
    		{
    			  $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

	public function start_post()
	{   
	   $header = $this->input->get_request_header('Authorization');
	   if ($header != '') 
	   {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
				$check =$this->orders->CheckStartOrders($user_id);
				if($check->num_rows()>0)
			    {
        			$this->response(array(
                        		"status" => 0,
                        		"message" => "Failed to start order, Another order is in Progress, Please complete the Started one"
               					), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
				}else{
						$order_id  = $this->security->xss_clean($this->input->post('order_id'));

					$status    = [
									'status'          => 'dispatched'
								];
					if ($this->Common->update('order_id',$order_id,'orders',$status)) 
					{   
						
					$status   = [
								'dispatched_time'  => date('Y-m-d H:i:s')
								];
						$this->Common->update('order_id',$order_id,'driver_orders',$status);
						$this->response(array(
									"status"  => 1,
									"message" => "Order started"
								), REST_Controller::HTTP_OK);
					}else {
							$this->response(array(
										"status" => 0,
										"message" => "Failed to start order"
							), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
						}
				}
    	    }
    	    else 
    		{
    			   $this->response(array(
                            	"status"  => 0,
                            	"message" => "Your session has expired, please login again"
               ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	   }
	   else
	   {
	      $this->response(array(
               "status"  => 0,
               "message" => "Your session has expired, please login again"
         ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

	public function startedRequests_get()
	{   
	    $date      = date('Y-m-d');
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    		$orders = [];
            	    
            	    $orders     = $this->orders->getStartedOrders($user_id);
            	    foreach($orders as $order)
            	    {   
            	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
            	        if($user) {
	            	        $order->user_firstname = $user->firstname;
	            	        $order->lastname       = $user->lastname;
	            	        $order->user_mobile    = $user->mobile;
	            	        $order->user_email     = $user->email;
	            	    }  else {
	            	    	$order->user_firstname = "Guest";
	            	        $order->lastname       = "Guest";
	            	        $order->user_mobile    = "Guest";
	            	        $order->user_email     = "Guest";
	            	    }          	        
            	        
      
            	        $order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
            	               	   // print_r($orders);
            	    }        	    
        	    
        	    		$this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $orders
                        		            ), REST_Controller::HTTP_OK);
    		}
    	    else 
    		{
    			  $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function approvedRequests_get()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $orders    = $this->orders->getApprovedRequests($user_id);
        	    foreach($orders as $order)
        	    {   
        	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();

        	        if($user) {
	        	        $order->user_firstname = $user->firstname;
	        	        $order->lastname       = $user->lastname;
	        	        $order->user_mobile    = $user->mobile;
	        	        $order->user_email     = $user->email;
	        	      } else {
	            	    	$order->user_firstname = "Guest";
	            	        $order->lastname       = "Guest";
	            	        $order->user_mobile    = "Guest";
	            	        $order->user_email     = "Guest";
	            	    }
        	        // $order->products       = $this->orders->getOrderedProducts($order->order_id);
        	        // $prep_time             = '0';
        	        // foreach($order->products as $product)
        	        // {   
        	        //     if($product->type=='p')
        	        //     {   
        	        //         $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
        	        //         $product->prep_time    = $p_details->prep_time;
        	        //     }
        	        //     else
        	        //     {
        	        //         $product->prep_time    ='0';
        	        //     }
        	        //     $prep_time                 = $prep_time+$product->prep_time;
        	        //     $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
        	        // }
        	        
        	        
        	        // $order->address           = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
        	        //$order->preperation_time  = $prep_time;

	        	     $order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        	    }
        	    $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $orders
                        		            ), REST_Controller::HTTP_OK);
    		}
    		else 
    		{
    			   $this->response(array(
                    			           "status"  => 0,
                    			            "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			           "status"  => 0,
                    			            "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function completedRequests_get()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $orders    = $this->orders->getCompletedRequests($user_id);
        	    foreach($orders as $order)
        	    {   

        	    	$user = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();

        	        if($user) {
	        	        $order->firstname = $user->firstname;
	        	        $order->lastname  = $user->lastname;
	        	        $order->mobile    = $user->mobile;
	        	        $order->email     = $user->email;
	        	    } else {
	            	    	$order->user_firstname = "Guest";
	            	        $order->lastname       = "Guest";
	            	        $order->user_mobile    = "Guest";
	            	        $order->user_email     = "Guest";
	            	}
        	        // $order->products = $this->orders->getOrderedProducts($order->order_id);
        	        // foreach($order->products as $product)
        	        // {
        	        //     $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
        	        // }
        	        // $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
        	    	$order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        	    }
        	    
        	    $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $orders
                        		            ), REST_Controller::HTTP_OK);
    		}
    		else 
    		{
    			   $this->response(array(
                    			           "status"  => 0,
                    			            "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}                
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function getOrderDetails_post()
	{
	   $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   
        	    $order_id        = $this->security->xss_clean($this->input->post('order_id'));
        	    $order           = $this->orders->getOrderDetails($order_id);
        	    $user            = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();

        	    if($user) {
	        	        $order->firstname = $user->firstname;
	        	        $order->lastname  = $user->lastname;
	        	        $order->mobile    = $user->mobile;
	        	        $order->email     = $user->email;
	        	} else {
	            	   	$order->firstname = "Guest";
	            	    $order->lastname  = "Guest";
	            	    $order->mobile    = "Guest";
	            	    $order->email     = "Guest";
	           	}
	           	
        	    $order->products = $this->orders->getOrderedProducts($order->order_id);
                foreach($order->products as $product)
                {
                      $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
                }
                // $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
                $order->address  = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        	    
        	    $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => $order
                        		            ), REST_Controller::HTTP_OK);
    	   }
    	   else 
    	   {
    			   $this->response(array(
                    			           "status"  => 0,
                    			           "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}                       
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function rejectOrder_post()
	{
	   date_default_timezone_set('Asia/Kolkata');
	   if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   	
        	   $order_id        = $this->security->xss_clean($this->input->post('order_id'));
    
        	   $array           = [
        	                         'driver_id'  => $user_id,
        	                         'order_id'   => $order_id,
        	                         'timestamp'  => date('Y-m-d H:i:s')
        	                      ];
        	   if($this->Common->insert('driver_rejected_orders',$array))
        	   {
        	      $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
        	   }
        	   else
        	   {
        	      $this->response(array(
                        		              "status" => 0,
                        		              "message" => "Failed to add location"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        	   }
    	   }
    	   else 
    	   {
    			   $this->response(array(
                    			            "status"  => 0,
                    			            "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}    
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function completeOrder_post()
	{
	   date_default_timezone_set('Asia/Kolkata');
	   $time   = date('h:i A');
	   
	   $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 	
        	   $order_id        = $this->security->xss_clean($this->input->post('order_id'));
    
        	   $order           = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
        	   $driver_order    = $this->Common->get_details('driver_orders',array('order_id'=>$order_id,'driver_id'=>$user_id))->row()->do_id;
        	   $customer_id     = $order->user_id;
        	   $restaurant      = $order->r_id;
        	   $total           = $order->total;
        	   
        	   $order_status    = [
        	                         'status'          => 'delivered',
        	                         'payment'         => '1',
        	                         'completed_date'  => date('Y-m-d'),
        	                         'completed_time'  => $time
        	                      ];
        	                      
        	   $driver_status   = [
        	                         'status'          => 'completed',
        	                         'completed_time'  => date('Y-m-d H:i:s')        
        	                      ];     
        	                      
        	   if($this->Common->update('order_id',$order_id,'orders',$order_status))
        	   {  
        	       $this->Common->update('do_id',$driver_order,'driver_orders',$driver_status);
    
                   $payment  = [
    	                         'user_id'      => $customer_id,
    	                         'amount'       => $total,
    	                         'driver_id'    => $user_id,
    	                         'r_id'         => $restaurant,
    	                         'date'         => date('Y-m-d'),
    	                         'time'         => date('h:i A'),
    	                         'timestamp'    => date('Y-m-d H:i:s')
    	                       ];
                   $this->Common->insert('user_payments',$payment); 
					   if($order ->type =='user')
					   {	
						   $customer        = $this->Common->get_details('users',array('user_id'=>$customer_id))->row();
						   $device_token = $customer->fcm;
						   $title = 'Order Completed!...';
						   $body   ='Your order with ID:'.$order_id.' has been completed successfully';
						   if($this->sendNotification($device_token,$body))
						   {
							   $not_array = [
									'user_id'  => $customer_id,
									'order_id' => $order_id,
									'title'    => $title,
									'message'  => $body,
									'date'     => date('Y-m-d'),
									'time'     => date('h:i A'),
									'timestamp'=> date('Y-m-d H:i:s')
									   ];
							   $this->Common->insert('notifications',$not_array);
						   }
					   }
					   $driver        = $this->Common->get_details('drivers',array('dr_id'=>$user_id))->row();
						   $device_token2 = $driver->fcm;
						   $title = 'Order Completed!...';
						   $body   ='Your order with ID:'.$order_id.' has been completed successfully';
					   if($this->sendNotification($device_token2,$body))
						{
							$not_array = [
										'driver_id' => $user_id,
										'order_id' => $order_id,
										'title'    => $title,
										'message'  => $body,
										'date'     => date('Y-m-d'),
										'time'     => date('h:i A'),
										'timestamp'=> date('Y-m-d H:i:s')
									];
							$this->Common->insert('notifications',$not_array);
						}


                    $this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
        	   }
        	   else
        	   {
        	       $this->response(array(
                        		              "status" => 0,
                        		              "message" => "Failed"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        	   }
    	   }
    	   else 
    	   {
    			   $this->response(array(
                    			           "status"  => 0,
                    			           "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}   
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	

	public function addPayment()
	{
		date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date('Y-m-d H:i:s');
        
        $customer_id     = $this->security->xss_clean($this->input->post('customer_id'));
        $agency_id       = $this->security->xss_clean($this->input->post('agency_id'));
// 		$payment_id      = $this->security->xss_clean($this->input->post('payment_id'));
        $amount_received = $this->security->xss_clean($this->input->post('amount_received'));
        $current_amount  = $this->security->xss_clean($this->input->post('current_amount'));
        $customer        = $this->Common->get_details('customers',array('customer_id'=>$customer_id))->row();
        $customer_name   = $customer->name_english;
        $customer_phone  = $customer->customer_phone;
        $balance         = $current_amount-$amount_received;
        $pending         = $this->Common->get_details('customer_pending_payments',array('customer_id'=>$customer_id,'type'=>'agency','payment_type'=>'credit','agency_id'=>$agency_id))->row();
	    $payment_id      = $pending->cpp_id;
	    $array           = [
							'amount'        => $balance,
							'updated_on'    => $timestamp
				           ];
	    			           
		if ($this->Common->update('cpp_id',$payment_id,'customer_pending_payments',$array)) 
		{   
			$payment    = [
                            'customer_id'    => $customer_id,
                            'customer_name'  => $customer_name,
                            'customer_phone' => $customer_phone,
                            'amount_paid'    => $amount_received,
                            'balance_amount' => $balance,
                            'type'           => 'agency',
                            'agency_id'      => $agency_id,
                            'date'           => date('Y-m-d'),
                            'timestamp'      => $timestamp
			              ];
			if($id=$this->Common->insert('payment_history',$payment))
			{
	            $wallet_check = $this->Common->get_details('customer_wallet',array('customer_id'=>$customer_id,'type'=>'credit'));
	        	if($wallet_check->num_rows()>0)
	        	{
	        		$amount     = $wallet_check->row()->amount;
	        		$new_amount = $amount-$amount_received;
	        		$wallet_id  = $wallet_check->row()->wallet_id;
	        		$wallet_array = [
	        			               'amount' => $new_amount 
	        		                ];
	        		$this->Common->update('wallet_id',$wallet_id,'customer_wallet',$wallet_array);   
	        	}
			    $return  = [
			                  'message' => 'success'
			               ];    
            }
            else
            {
                $return  = [
                              'message' => 'failed'
                           ];
            }
            
            $return = [
                          'message' => 'success'
                      ];
		}
		else 
		{
			$return = [
			              'message'  => 'failed'
			          ];
		}
		print_r(json_encode($return));
	}
	
	public function resendNewRequest()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
	    $order_id = $this->input->post('order_id');
	    $order   = $this->Common->get_details('customer_orders',array('order_id'=>$order_id))->row();
        $address = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        if($order->sale_type=='call')
        {
            $drivers = $this->Common->get_details('agencies',array('agency_status'=>'1'))->result();
            foreach($drivers as $driver)
            {
                $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                $this->send_notification($driver->device_token,$content);
            }
        }
        else
        {
           $drivers = $this->orders->getDrivers($order->latitude,$order->longitude,$date,$time);
           foreach($drivers as $driver)
            {
                $agency_check = $this->Common->get_details('agencies',array('agency_id'=>$driver->agency_id));
                if($agency_check->num_rows()>0)
                {
                   $device_token  = $agency_check->row()->fcm_token;  
                }
                else
                {
                   $device_token = ''; 
                }
                $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                $this->send_notification($device_token,$content);
            }
        }

	    $return  = [
	                  'message' => 'Success'
	               ];  
	    print_r(json_encode($return));            
	        
	}
	
	public function resendPendingRequest()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
	    $order_id = $this->input->post('order_id');
	    $agency_id= $this->input->post('agency_id');
	    
	    $order   = $this->Common->get_details('customer_orders',array('order_id'=>$order_id))->row();
        $address = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        $array   = [
                      'agency_assigned' =>'0',
                      'status'          =>'pending'
                   ];
        if($this->Common->update('order_id',$order_id,'customer_orders',$array))
        {   
            $this->Common->delete('agency_orders',array('agency_id'=>$agency_id,'order_id'=>$order_id));
            $rejected      = [
                                'agency_id'  => $agency_id,
                                'order_id'   => $order_id,
                                'timestamp'  => date('Y-m-d H:i:s')
                             ];
            $this->Common->insert('agency_rejected_orders',$rejected);
            
            if($order->sale_type=='call')
            {
                $drivers = $this->Common->get_details('agencies',array('agency_status'=>'1','agency_id!='=>$agency_id))->result();
                foreach($drivers as $driver)
                {
                    $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                    $this->send_notification($driver->device_token,$content);
                }
            }
            else
            {
               $drivers = $this->orders->getPendingDrivers($order->latitude,$order->longitude,$date,$time,$agency_id);
               foreach($drivers as $driver)
                {
                    $agency_check = $this->Common->get_details('agencies',array('agency_id'=>$driver->agency_id));
                    if($agency_check->num_rows()>0)
                    {
                       $device_token  = $agency_check->row()->fcm_token;  
                    }
                    else
                    {
                       $device_token = ''; 
                    }
                    $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                    $this->send_notification($device_token,$content);
                }
            }
             $return  = [
	                  'message' => 'Success'
	               ];  
        }
	    else
	    {
	         $return  = [
	                  'message' => 'Failed'
	               ];  
	    }
	    print_r(json_encode($return));            
	        
	}
	
	public function send_notification($id,$content)
	{
	    $SERVER_API_KEY = "AAAADKiRWxs:APA91bFm8ulvZBQZX7VNnbBsk9f2QCKJIpzuPXKnE3qZYHuZIeE_YnM3TzhtUxdY_p4XeZzKGez9VNEhxWkdGpdLSrYO_ZN4QtVCG4vp8_S2vxuMWVHRVOCJnv0P1iB9nXvOvuqD6OzH";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => 'New Order',
    		'body'  => $content
    	];
    	
    	$notification = [
    		'title'             => 'New Order',
    		'body'              => $content,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $id,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h6';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	//************************************************************* NOTIFICATION ************************************************************************************************//
    public function sendNotification($id,$content)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => 'Order Completed',
    		'body'  => $content
    	];
    	
    	$notification = [
    		'title'             => 'Order Completed',
    		'body'              => $content,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $id,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}

	
	
}
