<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Location extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
	
    public function add_post()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        		$lat        = $this->security->xss_clean($this->input->post('lat'));
        		$lon        = $this->security->xss_clean($this->input->post('long'));
        		
        		date_default_timezone_set("Asia/Calcutta"); 
        		$date       = date('Y-m-d');
        		$time       = date('h:i A');
        
        		$array = [
                			'driver_id' => $user_id,
                			'latitude'  => $lat,
                			'longitude' => $lon,
                			'date'      => $date,
                			'time'      => $time,
                			'timestamp' => date('Y-m-d H:i:s')
                		 ];
        
        		if ($this->Common->insert('locations',$array)) 
        		{
        			$this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
        		}
        		else 
        		{
        			$this->response(array(
                        		              "status" => 0,
                        		              "message" => "Failed to add location"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        		}
    		}	
            else 
    		{
    			   $this->response(array(
                        			      "status"  => 0,
                        			      "message" => "Your session has expired, please login again"
                        			    ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h6';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

}
