<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expense extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
			$this->load->model('android/M_expense','expense');
	}
	
	public function index()
	{
	    $agency_id      = $this->security->xss_clean($this->input->post('agency_id'));
	    $expenses       = $this->expense->getExpense($agency_id);
	    foreach($expenses as $expense)
	    {
	        $expense->category = $this->Common->get_details('expense_category',array('expcat_id'=>$expense->cat_id))->row()->category_name;
	    }
	    $return         = [
	                        'message'  => 'Success',
	                        'expense'  => $expenses
	                      ];
	    print_r(json_encode($return));                    
	}
	
    public function add()
	{   
	    date_default_timezone_set("Asia/Calcutta");
	    $timestamp  = date('Y-m-d H:i:s');
	    
	    $agency_id      = $this->security->xss_clean($this->input->post('agency_id'));
	    $category_id    = $this->security->xss_clean($this->input->post('category_id'));
		$expense_name   = $this->security->xss_clean($this->input->post('expense_name'));
		$expense_amount = $this->security->xss_clean($this->input->post('expense_amount'));
		$date           = $this->security->xss_clean($this->input->post('date'));
		$time           = $this->security->xss_clean($this->input->post('time'));
		$notes          = $this->security->xss_clean($this->input->post('notes'));
		$agency_name    = $this->Common->get_details('agencies',array('agency_id'=>$agency_id))->row()->agency_name;
		
		$array          = [
		                    'agency_id'     => $agency_id,
		                    'cat_id'        => $category_id,
		                    'agency_name'   => $agency_name,
		                    'expense_name'  => $expense_name,
		                    'expense_amount'=> $expense_amount,
		                    'notes'         => $notes,
		                    'date'          => $date,
		                    'time'          => $time,
		                    'timestamp'     => $timestamp
		                  ];

       if($this->Common->insert('agency_expense',$array))
       {
          $check  = $this->Common->get_details('agency_pending_payments',array('agency_id'=>$agency_id));
          if($check->num_rows()>0)
          {
              $payment_id = $check->row()->app_id;
              $current    = $check->row()->amount;
              $new        = $current+$expense_amount;
              
              $array      = [
                               'amount' => $new
                            ];
              $this->Common->update('app_id',$payment_id,'agency_pending_payments',$array);                
          }
          else
          {
              $array      = [
                               'agency_id' => $agency_id,
                               'amount'    => $expense_amount,
                               'timestamp' => $timestamp
                            ];
               $this->Common->insert('agency_pending_payments',$array);                
          }
          $message   = 'success';
       }
       else
       {
           $message = 'failed';
       }
        $return     = [
                         'message'  => $message
                      ];
		print_r(json_encode($return));
	}
	
	public function category()
	{
	    $category = $this->Common->get_details('expense_category',array('status'=>'1'))->result();
	    $data['category'] = $category;
	    
	    $return = [
	                 'message'  => 'success',
	                 'category' => $category
	              ];
	   print_r(json_encode($return));           
	}

}
