<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Sliders extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_home','home');
	}
	public function index_get()
	{   
	    $latitude    = $this->security->xss_clean($this->input->get('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->get('longitude'));
	    
	    $radius     = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	    // $radius     = $radius/1.609;
	    
		$sliders  = $this->Common->get_details('banners',array('status'=>'1'));
		if($sliders->num_rows() > 0)
		{  
		    $rest         = $this->home->getRestaurantSliders($latitude,$longitude,$radius);
		    foreach($rest as $re)
		    {
		        $re->branch_id = '0';
		    }
		    $branches     = $this->home->getBranchSliders($latitude,$longitude,$radius);
		    $array        = array_merge($rest, $branches);
		    
		    $result1              = array_merge($rest, $branches);
			$temp                 = array_unique(array_column($result1, 'r_id'));
            $array1               = array_merge($rest, $temp);
            $array2               = array_unique(array_column($array1, 'r_id'));
            $array                = array_intersect_key($array1, $array2);
            
		    if(!function_exists('array2_multi_subsort')) 
		    { 
        		function array_multi_subsort($array, $subkey)
                {
                    $b = array(); $c = array();
                
                    foreach ($array as $k => $v)
                    {
                        $b[$k] = strtolower($v->$subkey);
                    }
                
                    asort($b);
                    foreach ($b as $key => $val)
                    {
                        $c[] = $array[$key];
                    }
                
                    return $c;
                }
		    }
            $result1 = array_multi_subsort($array, 'distance');
            foreach($result1 as $res)
            {
                if($res->branch_id=='0')
                {
                    $rest                   = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row(); 
                    if($rest->latitude!='' || $rest->longitude!='')
    		         {
    		             $distance               = GetDrivingDistance($latitude, $rest->latitude, $longitude, $rest->longitude);
                         $town_distance          = $distance['distance'];
                         $town_time_taken        = $distance['time'];
                         $res->travel_time       = $town_time_taken;
                         $res->travel_distance   = $town_distance;
    		         }
    		         else
    		         {
    		              $res->travel_time       = 0;
    		              $res->travel_distance   = 0;
    		         }
                }
                else
                {
                    $branch                  = $this->Common->get_details('branches',array('b_id'=>$res->branch_id))->row();
                    if($branch->latitude!='' || $branch->longitude!='')
    		         {
    		             $distance              = GetDrivingDistance($latitude, $branch->latitude, $longitude, $branch->longitude);
                         $town_distance         = $distance['distance'];
                         $town_time_taken       = $distance['time'];
                         $res->travel_time      = $town_time_taken;
                         $res->travel_distance  = $town_distance;
    		         }
    		         else
    		         {
    		              $res->travel_time      = 0;
    		              $res->travel_distance  = 0;
    		         }
                }
            }
		  //  $result   = $this->home->getSliders($latitude,$longitude,$radius);
		  // $temp   = array_unique(array_column($result1, 'name'));
    //       $result = array_intersect_key($result1, $temp);
		  
	    	
		  	$this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              "data"    => $result1,
                    		            ), REST_Controller::HTTP_OK);
		}
		else 
		{
			$this->response(array(
            		              "status"  => false,
            		              "message" => "Failed"
            		            ), REST_Controller::HTTP_NOT_FOUND);
		}
	}
	
//******************************************************************* GET DRIVING DISTANCE ************************************************************************//	
	// function GetDrivingDistance($lat1, $lat2, $long1,$long2)
 //    {
 //        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2."%2C".$long2."&mode=driving&language=pl-PL&key=" . GOOGLE_MAP_KEY;
 //        $ch = curl_init();
 //        curl_setopt($ch, CURLOPT_URL, $url);
 //        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
 //        curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
 //        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
 //        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
 //        $response = curl_exec($ch);
 //        curl_close($ch);
 //        $response_a = json_decode($response, true);
 //        $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
 //        $time = $response_a['rows'][0]['elements'][0]['duration']['text'];
    
 //        return array('distance' => $dist, 'time' => $time);
 //        // return $response_a;
 //    }	
	
}
?>
