<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Profile extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
	}
//************************************* PROFILE *************************************//	
	public function index_get()
	{   
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $profile   = $this->Common->get_details('users',array('user_id'=>$user_id))->row();
    				if ($profile) 
    				{
    					$this->response(array(
                            		              "status"  => true,
                            					  "data"    => $profile,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);
    				}
    				else 
    				{
    					$this->response(array(
                            					  "status" => false,
                            					  "message" => "Profile not found"
                            					), REST_Controller::HTTP_NOT_FOUND);
    				}
			    }
				else
				{
				    $this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
				}
			}
			else 
			{
				$this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
		}
	}

//************************************** UPDATE ***************************************//	
	public function update_post()
	{   
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
    				$firstname= $this->security->xss_clean($this->input->post('firstname'));
        		    $lastname = $this->security->xss_clean($this->input->post('lastname'));
        		    $dob      = $this->security->xss_clean($this->input->post('dob'));
        		    $gender   = $this->security->xss_clean($this->input->post('gender'));
        		    $mobile   = $this->security->xss_clean($this->input->post('mobile'));
    				
    			    $array    = [ 
                                   'firstname'   => $firstname,
                                   'lastname'    => $lastname,
                                   'dob'         => $dob,
                                   'gender'      => $gender,
								   'mobile'      => $mobile
                                ];
    	            if($this->Common->update('user_id',$user_id,'users',$array))
    				{
    					$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Profile updated successfully"
                            		            ), REST_Controller::HTTP_OK);
    				}
    				else 
    				{
    					$this->response(array(
    		                                    "status" => false,
    		                                    "message" => "Failed"
    		                                 ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
    				}
			    }
			    else
			    {
			        $this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
		}
	}

//****************************************** CHANGE EMAIL ***************************//	
	public function changeEmail_post()
	{   
	    $uid      = $this->security->xss_clean($this->input->post('uid')); 
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1) 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
    				$current_password = $this->security->xss_clean($this->input->post('password'));
        			$check1           = $this->Common->get_details('users',array('user_id' => $user_id , 'password' => md5($current_password)))->num_rows();
        			if($check1 > 0)
        			{ 
            		    $email      = $this->security->xss_clean($this->input->post('email'));
            		    $check      = $this->Common->get_details('users',array('email'=>$email,'user_id!='=>$user_id));
            		    if($check->num_rows()>0)
            		    {
            		        $this->response(array(
                                	                "status" => false,
                                	                "message" => 'Email already exists'
                                	             ), REST_Controller::HTTP_CONFLICT);
            		    }
            		    else
            		    {
            		        $array  = [
            		                     'email'  => $email
            		                  ];
            		        if($this->Common->update('user_id',$user_id,'users',$array))
            		        {
            		            $this->response(array(
                            		                    "status"  => true,
                            		                    "message" => "Success"
                            		                  ), REST_Controller::HTTP_OK);
            		        }
            		        else
            		        {
            		            $this->response(array(
    		                                             "status" => false,
    		                                             "message" => "Failed"
    		                                          ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		        }
            		    }
        			}
        			else
        			{
        				$this->response(array(
    						                    "status" => false,
    						                    "message" => "Incorrect password"
    						                  ), REST_Controller::HTTP_UNAUTHORIZED);
        			}   
			    }
			    else
			    {
			       $this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED); 
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$this->response(array(
                        			  "status"  =>false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
		}
	} 

//**************************************************** CHANGE PASSWORD *************************************************************************************************************//
    public function changePassword_post()
	{   
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
    				$current_password = $this->security->xss_clean($this->input->post('current_password'));
        			$check1           = $this->Common->get_details('users',array('user_id' => $user_id , 'password' => md5($current_password)))->num_rows();
        			if($check1 > 0)
        			{ 
            		        $password = $this->security->xss_clean($this->input->post('new_password'));
            	    		$array    = [
            	    		        	    'password' => md5($password)
            	    		            ];
            				
            		        if($this->Common->update('user_id',$user_id,'users',$array))
            		        {
            		            $this->response(array(
                            		                    "status"  => true,
                            		                    "message" => "Success"
                            		                  ), REST_Controller::HTTP_OK);
            		        }
            		        else
            		        {
            		            $this->response(array(
    		                                             "status" => false,
    		                                             "message" => "Failed"
    		                                          ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		        }
        			}
        			else
        			{
        				$this->response(array(
    						                    "status" => false,
    						                    "message" => "The current password is incorrect. Please try again"
    						                  ), REST_Controller::HTTP_UNAUTHORIZED);
        			}   
			    }
			    else
			    {
			        $this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
		}
	}

//****************************************** CHECK EMAIL ***************************************************************************************************************************//	
	public function checkEmail_post()
	{
	    $email      = $this->security->xss_clean($this->input->post('email'));
	    $check      = $this->Common->get_details('users',array('email'=>$email));
	    if($check->num_rows()>0)
	    {
	        $this->response(array(
        		                    "status"  => true,
        		                    "message" => "Success"
        		                  ), REST_Controller::HTTP_OK);
	    }
	    else
	    {
            $this->response(array(
                                     "status" => false,
                                     "message" => "The email id is not registered"
                                  ), REST_Controller::HTTP_OK);
	    }
		
	}

	/************************************** UPDATE ***************************************/
	public function delete_post()
	{   
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {    				
    				$user = $uid_check->row();
    			    $array    = [ 
								   'mobile'      => intval(strval($user->mobile) . '00000'),
								   'email' => 'D',
								   'uid' => '',
								   'fcm' => '',
								   'auth' => '',
								   'status' => '2',
                                ];
    	            if($this->Common->update('user_id',$user_id,'users',$array))
    				{
    					$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);
    				}
    				else 
    				{
    					$this->response(array(
    		                                    "status" => false,
    		                                    "message" => "Failed"
    		                                 ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
    				}
			    }
			    else
			    {
			        $this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status"  => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
		}
	}
	
//******************************************** DECODE TOKEN ************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
}
?>
