<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Products extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_products','products');
		$this->load->model('android/M_restaurant','restaurant');
	}

	public function search_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    $uid        = $this->security->xss_clean($this->input->post('uid'));
	    $token      = $this->security->xss_clean($this->input->post('device_token'));
	    $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id     = $this->decodeToken($header);
    	    $rest_id     = $this->security->xss_clean($this->input->post('restaurant_id'));
    	    $key         = $this->security->xss_clean($this->input->post('key'));
    		$keyword     = str_replace(" ", "%", $key);
    		if($user_id)
    		{
    		    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            		if($key=='')
            		{
            	        $products    = $this->products->getAllProducts($rest_id);
            	        foreach($products as $product)
            		    {
            		      $product->price          = $this->products->get_smallest_price($product->p_id);  
            		      $fav_check  = $this->Common->get_details('favourites',array('product_id'=>$product->p_id,'user_id'=>$user_id));
            		      if($fav_check->num_rows()>0)
            		      {
            		          $product->fav_status = true;
            		          $product->fav_id     = $fav_check->row()->fav_id;
            		      }
            		      else
            		      {
            		          $product->fav_status = false;
            		          $product->fav_id     = '0';
            		      }  
            		      
            		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $fav_check  = $this->Common->get_details('favourites',array('product_id'=>$product->p_id,'user_id'=>$user_id));
                		      if($fav_check->num_rows()>0)
                		      {
                		          $product->fav_status = true;
                		          $product->fav_id     = $fav_check->row()->fav_id;
                		      }
                		      else
                		      {
                		          $product->fav_status = false;
                		          $product->fav_id     = '0';
                		      } 
                		      
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price      = $product->price*$percentage/100;
            		          $product->offer_price      = number_format($product->price-$price,'2');
            		          $product->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $product->offer_price     = '';
            		           $product->offer_percentage= '';
            		      }
            		    }   
            		}
            		else
            		{
            		 	$products    = $this->products->searchProduct($keyword,$rest_id);
            		 	foreach($products as $product)
            		    {
            		       $product->price          = $this->products->get_smallest_price($product->p_id); 
            		       $fav_check  = $this->Common->get_details('favourites',array('product_id'=>$product->p_id,'user_id'=>$user_id));
            		       if($fav_check->num_rows()>0)
            		       {
            		          $product->fav_status = true;
            		          $product->fav_id     = $fav_check->row()->fav_id;
            		       }
            		       else
            		       {
            		          $product->fav_status = false;
            		          $product->fav_id     = '0';
            		       }
            		       
            		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price      = $product->price*$percentage/100;
            		          $product->offer_price      = number_format($product->price-$price,'2');
            		          $product->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $product->offer_price     = '';
            		           $product->offer_percentage= '';
            		      }
            		    }   
            		}
			    }
			    else
			    {
			        $this->response(array(
                                			  "status"  => false,
                                			  "message" => "Your session has expired, please login again"
                                			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    		    if($key=='')
        		{
        	        $products    = $this->products->getAllProducts($rest_id);
        	        foreach($products as $product)
        		    {
        		      $product->price          = $this->products->get_smallest_price($product->p_id);  
        		      $product->fav_status = false;
        		      $product->fav_id     = '0';  
        		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }   
        		}
        		else
        		{
        		 	$products    = $this->products->searchProduct($keyword,$rest_id);
        		 	foreach($products as $product)
        		    {
        		      $product->price          = $this->products->get_smallest_price($product->p_id);  
        		      $product->fav_status = false;
        		      $product->fav_id     = '0';  
        		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }   
        		}
    		}
    		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            					  'data'    => $products
            		            ), REST_Controller::HTTP_OK);
	    }
	    else
	    {   
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
    	        $rest_id     = $this->security->xss_clean($this->input->post('restaurant_id'));
        	    $key         = $this->security->xss_clean($this->input->post('key'));
        		$keyword     = str_replace(" ", "%", $key);
        		if($key=='')
        		{
        	        $products    = $this->products->getAllProducts($rest_id);
        	        foreach($products as $product)
        		    {
        		      $product->price          = $this->products->get_smallest_price($product->p_id);  
        		      $product->fav_status = false;
        		      $product->fav_id     = '0';  
        		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }   
        		}
        		else
        		{
        		 	$products    = $this->products->searchProduct($keyword,$rest_id);
        		 	foreach($products as $product)
        		    {
        		      $product->price          = $this->products->get_smallest_price($product->p_id);  
        		      $product->fav_status = false;
        		      $product->fav_id     = '0';  
        		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }   
        		}
        		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            					  'data'    => $products
            		            ), REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
	    }
	}

//********************************************* DETAILS ****************************************************************************************************************************//	
	public function details_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    $uid        = $this->security->xss_clean($this->input->post('uid'));
	    $token      = $this->security->xss_clean($this->input->post('device_token'));
	    $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            	    $product_id   = $this->security->xss_clean($this->input->post('product_id'));
            		$check           = $this->Common->get_details('products',array('p_id'=>$product_id));
            		if($check->num_rows()>0)
            		{
            		    $product                 = $check->row();
            		    $product->price          = $this->products->get_smallest_price($product_id);
            		    $product->prices         = $this->Common->get_details('product_price',array('status'=>'1','product_id'=>$product_id))->result();
            		    foreach($product->prices as $price)
            		    {
            		          $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
                		      if($offerCheck->num_rows()>0)
                		      {
                		          $offer      = $offerCheck->row();
                		          $percentage = $offer->percentage;
                		          $price1      = $price->price*$percentage/100;
                		          $price->offer_price      = number_format($price->price-$price1,'2');
                		          $price->offer_percentage = $percentage;
                		      }
                		      else
                		      {
                		           $price->offer_price     = '0';
                		           $price->offer_percentage= '0';
                		      };
            		    }
            		    $product->images         = $this->products->getProductImages($product->p_id);  
            		    $product->available_days = $this->products->getDays($product->p_id);
            		    $fav_check               = $this->Common->get_details('favourites',array('user_id'=>$user_id,'product_id'=>$product_id));
                        if($fav_check->num_rows()>0)
                        {
                            $favorite            = $fav_check->row();
                            $product->favorite_id= $favorite->fav_id;
                        }
                        else
                        {
                            $product->favorite_id= '';
                        }
                        
                        $categories  = $this->Common->get_details('product_choice_categories',array('product_id'=>$product_id))->result();
                        foreach($categories as $cat)
                        {
                            $cat->choice_values = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id))->result();
                        }
                        $product->choices  =  $categories;
                        
                          
            		}
            		else
            		{
            		    $product  = array();
            		}
			    }
			    else
			    {
			        $this->response(array(
                                			  "status"  => false,
                                			  "message" => "Your session has expired, please login again"
                                			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    		    $product_id      = $this->security->xss_clean($this->input->post('product_id'));
        		$check           = $this->Common->get_details('products',array('p_id'=>$product_id));
        		if($check->num_rows()>0)
        		{
        		    $product                 = $check->row();
        		    $product->price          = $this->products->get_smallest_price($product_id);
        		    $product->prices         = $this->Common->get_details('product_price',array('status'=>'1','product_id'=>$product_id))->result();
        		    foreach($product->prices as $price)
        		    {
                         $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price1      = $price->price*$percentage/100;
            		          $price->offer_price      = number_format($price->price-$price1,'2');
            		          $price->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $price->offer_price     = '0';
            		           $price->offer_percentage= '0';
            		      };
        		    }
        		    $product->images         = $this->products->getProductImages($product->p_id);  
        		    $product->available_days = $this->products->getDays($product->p_id);
        		    $product->favorite_id    = '';
        		    
        		    $categories  = $this->Common->get_details('product_choice_categories',array('product_id'=>$product_id))->result();
                    foreach($categories as $cat)
                    {
                        $cat->choice_values = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id))->result();
                    }
                    $product->choices  =  $categories;
        		}
        		else
        		{
        		    $product  = array();
        		}
    		}
    		
            $this->response(array(
                		              "status"  => true,
                		              "message" => "Success",
                					  "data"    => $product
                		            ), REST_Controller::HTTP_OK);
	    }
	    else
	    {
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                $product_id      = $this->security->xss_clean($this->input->post('product_id'));
        		$check           = $this->Common->get_details('products',array('p_id'=>$product_id));
        		if($check->num_rows()>0)
        		{
        		    $product                 = $check->row();
        		    $product->price          = $this->products->get_smallest_price($product_id);
        		    $product->prices         = $this->Common->get_details('product_price',array('status'=>'1','product_id'=>$product_id))->result();
        		    foreach($product->prices as $price)
        		    {
                         $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price1      = $price->price*$percentage/100;
            		          $price->offer_price      = number_format($price->price-$price1,'2');
            		          $price->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $price->offer_price     = '0';
            		           $price->offer_percentage= '0';
            		      };
        		    }
        		    $product->images         = $this->products->getProductImages($product->p_id);  
        		    $product->available_days = $this->products->getDays($product->p_id);
        		    $product->favorite_id    = '';
        		    
        		    $categories  = $this->Common->get_details('product_choice_categories',array('product_id'=>$product_id))->result();
                    foreach($categories as $cat)
                    {
                        $cat->choice_values = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id))->result();
                    }
                    $product->choices  =  $categories;
        		}
        		else
        		{
        		    $product  = array();
        		}
        		
        		$this->response(array(
                		              "status"  => true,
                		              "message" => "Success",
                					  "data"    => $product
                		            ), REST_Controller::HTTP_OK);
            }
            else
            {
	           $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }                        			
	    }
	}

//****************************************** DECODE TOKEN **************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
}
?>
