<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';

class Payment extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		//$this->load->model('android/M_about','about');
	}

	public function createCharge_post()
	{
	    $url = 'https://api.tap.company/v2/';
	    $secret_key = 'sk_test_eSDIq6TZCFhVnL3vr89xMap1';
	    $ch = curl_init();
        //TEST
        curl_setopt($ch, CURLOPT_URL, $url . 'charges');
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
         curl_setopt($ch, CURLOPT_HTTPHEADER,array('Authorization: Bearer '.$secret_key));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        
        $payload = array(
        	"amount" => 1,
  			"currency" => "BHD",
  			"threeDSecure" => true,
			"save_card" => false,
			"description" => "Test Description",
			"statement_descriptor" =>"Sample",
  
			"reference" => array(
			    "transaction" => "txn_0001",
			    "order" => "ord_0001"
			),
  			"receipt" => array(
    			"email" => false,
    			"sms" => true
  			),
  			"customer" => array(
    			"first_name" => "test",
    			"middle_name" => "test",
    			"last_name" => "test",
    			"email" => "test@test.com",
    			"phone" => array(
      				"country_code" => "965",
      				"number" => "50000000"
    			)
  			),
  			"source" => array(
    			"id" => "src_all"
  			),
  
		  	"post" => array(
		    	"url" => WEBSITE_BASE_URL . "payment"
		  	),
		  	"redirect" => array(
		    	"url" => site_url('flutter/payment/callback')
		  	)
        );
        
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
        $response = curl_exec($ch);
        // $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $response_info = curl_getinfo($ch);
        $response_code = $response_info['http_code'];
        curl_close($ch); 

        $this->response(array(
        		              	"status"  => true,
        		              	"message" => "",
        		              	'response_code' => $response_code,
            					'response'      => $response,
            					'response_info' => $response_info,
        		            ), REST_Controller::HTTP_OK); 
	}

	public function create_post()
	{
		$amount  = $this->security->xss_clean($this->input->post('amount'));
		$order_id  = $this->security->xss_clean($this->input->post('order_id'));

		$first_name  = "";
		$last_name  = "";
		$email  = "";
		$mobile  = "";

		$get_order  = $this->Common->get_details('orders',array('order_id'=>$order_id));

		if($get_order->num_rows() > 0) {

			$order = $get_order->row();

			if($order->type == 'user') {
				$get_user = $this->Common->get_details('users',array('user_id'=>$order->user_id));
				if($get_user->num_rows() > 0) {
					$user = $get_user->row();
					$first_name = $user->firstname;
					$last_name = $user->lastname;
					$email = $user->email;
					$mobile = $user->mobile;
				}
			} else {
				$get_address = $this->Common->get_details('guest_address',array('ga_id'=>$order->address_id));
				if($get_address->num_rows() > 0) {
					$address = $get_address->row();
					$first_name = $address->name;
					$mobile = $address->mobile;
				}
			}

		    $ch = curl_init();
	        //TEST
	        curl_setopt($ch, CURLOPT_URL, PAYMENT_BASE_URL . 'charges'); 
	        //PAYMENT_BASE_URL defined in config/constants.php

	        curl_setopt($ch, CURLOPT_HEADER, FALSE);

	         curl_setopt($ch, CURLOPT_HTTPHEADER,array('Authorization: Bearer '. PAYMENT_SECRET));
	         //PAYMENT_SECRET defined in config/constants.php

	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
	        
	        $payload = array(
	        	"amount" => $amount,
	  			"currency" => "BHD",
	  			"threeDSecure" => true,
				"save_card" => false,
				"description" => "Food Delivery",
				"statement_descriptor" =>"",
	  
				"reference" => array(
				    //"transaction" => $order_id,
				    "order" => $order_id
				),
	  			"receipt" => array(
	    			"email" => false,
	    			"sms" => true
	  			),
	  			"customer" => array(
	    			"first_name" => $first_name,
	    			"middle_name" => "",
	    			"last_name" => $last_name,
	    			"email" => $email,
	    			"phone" => array(
	      				"country_code" => "973",
	      				"number" => $mobile
	    			)
	  			),
	  			"source" => array(
	    			"id" => "src_all"
	  			),
	  
			  	"post" => array(
			    	"url" => site_url('flutter/Checkout/updatePaymentStatus')
			  	),

			  	"redirect" => array(
			    	"url" => WEBSITE_BASE_URL . "payment"
			  	)
	        );
	        
	        curl_setopt($ch, CURLOPT_POST, true);
	        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
	        $response = curl_exec($ch);
	        // $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	        $response_info = curl_getinfo($ch);
	        $response_code = $response_info['http_code'];
	        $data = json_decode($response);
	        curl_close($ch); 

	        if($response_code == 200) {
	        	
	        	$this->response(array(
	        		    "status"  => true,
	        		    "message" => "Success",
	            		"data"      => $data,
	            		//"response_info" => $response_info,
	        	), REST_Controller::HTTP_OK); 

	        } else {
	        	$this->response(array(
	        		    "status"  => false,
	        		    "message" => "Failed",
	        		    "data"    => $data,
	        	), REST_Controller::HTTP_INTERNAL_SERVER_ERROR); 
	        }
	    } else {
	    	$this->response(array(
	        		    "status"  => false,
	        		    "message" => "Failed",
	        	), REST_Controller::HTTP_NOT_FOUND); 
	    }
	}

	public function callback_get() {
		$tap_id  = $this->security->xss_clean($this->input->get('tap_id'));
		// echo $tap_id;

	    $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, PAYMENT_BASE_URL . 'charges/' . $tap_id); 
        //PAYMENT_BASE_URL defined in config/constants.php

        curl_setopt($ch, CURLOPT_HEADER, FALSE);

         curl_setopt($ch, CURLOPT_HTTPHEADER,array('Authorization: Bearer '. PAYMENT_SECRET));
         //PAYMENT_SECRET defined in config/constants.php

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);        
      
        $response = curl_exec($ch);
        // $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $response_info = curl_getinfo($ch);
        $response_code = $response_info['http_code'];
        curl_close($ch); 

        //print_r(json_decode($response));
	}
}
?>
