<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Orders extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_orders','orders');
	}
//************************************ GET ****************************************************************************************************************************************//	
	public function index_get()
	{
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $token    = $this->security->xss_clean($this->input->get('device_token'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
        		    $orders   = $this->orders->getOrders($user_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = '';
        		         }
        		         
        		         $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$user_id,'type'=>'user'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
			    }
			    else
			    {
			        $this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	                $orders   = $this->orders->getGuestOrders($guest_check->row()->guest_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      ='';
        		         }
            		     
            		     $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$guest_check->row()->guest_id,'type'=>'guest'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }   
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}

//********************************************* ORDER DETAILS ********************************************************************************************************************//	
    public function getOrderDetails_post()
	{
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $token    = $this->security->xss_clean($this->input->post('device_token'));
	    $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
			     $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			     if($uid_check->num_rows()>0)
			     {
			         $order_id   = $this->security->xss_clean($this->input->post('order_id'));
        		     $order      = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
        		    
        	         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        	         if($r_check->num_rows()>0)
        	         {   
        	             $order->restaurant= $r_check->row();
        	         }
        	         else
        	         {
        	             $order->restaurant= '';
        	         }
        	         
        	         $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order_id));
        	         if($address_check->num_rows()>0)
        	         {
        	             $order->address   = $address_check->row();
        	         }
        	         else
        	         {
        	             $order->address   = '';
        	         }
        	         
        	         $products         = $this->Common->get_details('ordered_products',array('order_id'=>$order->order_id))->result();
        	         foreach($products as $product)
        	         {   
        	             if($product->type=='p')
        	             {
        	                 $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
            	             $product->product_name = $p_details->name;
            	             $product->image        = $p_details->cover_image;
            	             $product->thumbnail    = $p_details->thumbnail;
            	             $product->prep_time    = $p_details->prep_time;
            	             $extras                = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
            		         $product->extras       =  $extras;
            		         $sub_total       = 0;
            		         foreach($extras as $extra)
            		         {
            		             $sub_total  = $sub_total+$extra->total;
            		         }
                             $product->total_price  = $product->total+$sub_total;
        	             }
        	             else
        	             {
        	                 $p_details             = $this->Common->get_details('extras',array('extra_id'=>$product->product_id))->row();
            	             $product->product_name = $p_details->name;
            	             $product->image        = $p_details->image;
            	             $product->prep_time    = '0';
            	             $product->extras       = array();
            	             $product->total_price  = $product->total;
        	             }
        	             
        	         }
        	         $order->products    = $products;
        	         
        	         
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $order,
                            		            ), REST_Controller::HTTP_OK);
			     }
    		     else
    		     {
    		         $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
    		     }
    		}
    		else
    		{
    			$this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	            	 $order_id   = $this->security->xss_clean($this->input->post('order_id'));
        		     $order      = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
        		    
        	         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        	         if($r_check->num_rows()>0)
        	         {   
        	             $order->restaurant= $r_check->row();
        	         }
        	         else
        	         {
        	             $order->restaurant= '';
        	         }
        	         
        	         $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order_id));
        	         if($address_check->num_rows()>0)
        	         {
        	             $order->address   = $address_check->row();
        	         }
        	         else
        	         {
        	             $order->address   = '';
        	         }
        	         
        	         $products         = $this->Common->get_details('ordered_products',array('order_id'=>$order->order_id))->result();
        	         foreach($products as $product)
        	         {   
        	             if($product->type=='p')
        	             {
        	                 $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
            	             $product->product_name = $p_details->name;
            	             $product->image        = $p_details->cover_image;
            	             $product->prep_time    = $p_details->prep_time;
            	             $extras                = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
            		         $product->extras       =  $extras;
            		         $sub_total       = 0;
            		         foreach($extras as $extra)
            		         {
            		             $sub_total  = $sub_total+$extra->total;
            		         }
                             $product->total_price  = $product->total+$sub_total;
        	             }
        	             else
        	             {
        	                 $p_details             = $this->Common->get_details('extras',array('extra_id'=>$product->product_id))->row();
            	             $product->product_name = $p_details->name;
            	             $product->image        = $p_details->image;
            	             $product->prep_time    = '0';
            	             $product->extras       = array();
            	             $product->total_price  = $product->total;
        	             }
        	             
        	         }
        	         $order->products    = $products;
        	         
        	         
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $order,
                            		            ), REST_Controller::HTTP_OK);
	        }
	        else
	        {
	            $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
		
	}

//********************************************** GET CANCEL REASON ****************************************************************************************************************//	
	public function getCancelReasons_get()
	{
	    $check = $this->Common->get_details('cancel_reasons',array('reason_for'=>'Customer','status'=>'1'));
	    if($check->num_rows()>0)
	    {
	        $reasons = $check->result();
	       
 	        $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'data'    => $reasons
                    		            ), REST_Controller::HTTP_OK);	             
	    }
	    else
	    {
	        $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
	    }
	    
	}

//****************************************** CANCEL ORDER ************************************************************************************************************************//	
	public function cancelOrder_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
		$uid        = $this->security->xss_clean($this->input->post('uid'));
		$token      = $this->security->xss_clean($this->input->post('device_token'));
		$order_id   = $this->security->xss_clean($this->input->post('order_id'));
	    $reason_id  = $this->security->xss_clean($this->input->post('reason_id'));
	    $comments   = $this->security->xss_clean($this->input->post('comments'));
            	    
	   	$header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1) 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            	    $cancel     = [
            	                        'status'         => 'cancelled',
            	                        'cancelled_date' => $date,
            	                        'cancelled_time' => $time
            	                  ];
            	   if($this->Common->update('order_id',$order_id,'orders',$cancel))
            	   {        
            	            $array  = [
            	                         'order_id'      => $order_id,
            	                         'user_id'       => $user_id,
            	                         'cancelled_by'  => 'customer',
            	                         'reason_id'     => $reason_id,
            	                         'cancelled_date'=> $date,
            	                         'cancelled_time'=> $time,
            	                         'comments'      => $comments,
            	                         'timestamp'     => $timestamp
            	                      ];
            	            $this->Common->insert('cancelled_orders',$array); 
            	            
            			    $this->response(array(
                            		                "status"  => true,
                            		                "message" => "Success"
                            		              ), REST_Controller::HTTP_OK);
            	   }
            	   else
            	   {
            	           $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to cancel order"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	   }
			    }
        	    else
        	    {
        	        $this->response(array(
                        			    "status"  => true,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
        	    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => true,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	               $cancel     = [
            	                        'status'         => 'cancelled',
            	                        'cancelled_date' => $date,
            	                        'cancelled_time' => $time
            	                  ];
            	   if($this->Common->update('order_id',$order_id,'orders',$cancel))
            	   {        
            	            $array  = [
            	                         'order_id'      => $order_id,
            	                         'user_id'       => $guest_check->row()->guest_id,
            	                         'cancelled_by'  => 'guest',
            	                         'reason_id'     => $reason_id,
            	                         'cancelled_date'=> $date,
            	                         'cancelled_time'=> $time,
            	                         'comments'      => $comments,
            	                         'timestamp'     => $timestamp
            	                      ];
            	            $this->Common->insert('cancelled_orders',$array); 
            	            
            			    $this->response(array(
                            		                "status"  => true,
                            		                "message" => "Success"
                            		              ), REST_Controller::HTTP_OK);
            	   }
            	   else
            	   {
            	           $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to cancel order"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	   }
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}

//*************************************** TRACK ORDER *****************************************************************************************************************************//	
	public function tracking_post()
	{
	    $order_id    = $this->security->xss_clean($this->input->post('order_id'));
	    $check       = $this->Common->get_details('orders',array('order_id'=>$order_id));
	    if($check->num_rows()>0)
	    {
	        $order        = $check->row();
            $driver_check = $this->Common->get_details('driver_orders',array('order_id'=>$order_id));
            if($driver_check->num_rows()>0)
            {
                $driver_order           = $driver_check->row();
                $order->driver[]          = $this->Common->get_details('drivers',array('dr_id'=>$driver_order->driver_id))->row();
				$location = $this->orders->getDriverLocation($driver_order->driver_id);
				if($order->status == 'dispatched'){
					if($location){
						$order->driver_location[] = $location;
					}else{
						$order->driver_location = [];
					}
				}else{
					$order->driver_location = [];
				}
                // $driver->latitude       = $driver_location->latitude;
                // $driver->longitude      = $driver_location->longitude;
            }
            else
            {
                $order->driver          = array();
                $order->driver_location = array();
            }
            $order_location               = $this->Common->get_details('ordered_address',array('order_id'=>$order_id))->row();
            $order->location              = $order_location;
            // $order->customer_latitude  = $order_location->latitude;
            // $order->customer_longitude = $order_location->longitude;
            $restaurant                   = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row();
            
            if($restaurant->latitude!='' || $restaurant->longitude!='')
	        {
	             $distance              = GetDrivingDistance($order_location->latitude, $restaurant->latitude, $order_location->longitude, $restaurant->longitude);
                 $town_distance         = $distance['distance'];
                 $town_time_taken       = $distance['time'];
                 $restaurant->travel_time      = $town_time_taken;
                 $restaurant->travel_distance  = $town_distance;
	        }
	        else
	        {
	              $town_time_taken               = '';
	              $town_distance                 = '';
	              $restaurant->travel_time       = 0;
	              $restaurant->travel_distance   = 0;
	        }
            $order->restaurant         = $restaurant;
            $ordered_products          = $this->Common->get_details('ordered_products',array('order_id'=>$order_id))->result();
            $total   = 0;
            foreach($ordered_products as $pro)
            {   
                if($pro->type=='p')
                {
                   $pro->preperation        = $this->Common->get_details('products',array('p_id'=>$pro->product_id))->row()->prep_time;
                   $total                   = $total+$pro->preperation; 
                }
                else
                {
                    $total                   = $total+0; 
                }
            }
            $formatted = date('H:i:s', strtotime(floor($total / 60).':'.($total -   floor($total / 60) * 60)));
            $order->prep_time               = $formatted;
            $order->travel_time             = $town_time_taken;
            $order->travel_distance         = $town_distance;
 	        $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'data'    => $order
                    		            ), REST_Controller::HTTP_OK);	             
	    }
	    else
	    {
	        $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_NOT_FOUND);
	    }
	}

//*************************************** DECODE TOKEN ***************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	//************************************ GET DRAFTORDERS****************************************************************************************************************************************//	
	public function draft_orders_get()
	{
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $token    = $this->security->xss_clean($this->input->get('device_token'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
        		    $orders   = $this->orders->getDraftOrders($user_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = '';
        		         }
        		         
        		         $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$user_id,'type'=>'user'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
			    }
			    else
			    {
			        $this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your sessions has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your sessions has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	                $orders   = $this->orders->getGuestDraftOrders($guest_check->row()->guest_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      ='';
        		         }
            		     
            		     $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$guest_check->row()->guest_id,'type'=>'guest'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }   
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}
	//************************************ GET COMPLETED ORDERS****************************************************************************************************************************************//	
	public function completed_orders_get()
	{
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $token    = $this->security->xss_clean($this->input->get('device_token'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
        		    $orders   = $this->orders->getCompletedOrders($user_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = '';
        		         }
        		         
        		         $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$user_id,'type'=>'user'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
			    }
			    else
			    {
			        $this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your sessions has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your sessions has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	                $orders   = $this->orders->getGuestCompletedOrders($guest_check->row()->guest_id);
        		    foreach($orders as $order)
        		    {   
        		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
        		         if($r_check->num_rows()>0)
        		         {   
        		             $details              = $r_check->row();
        		             $order->rest_name     = $details->rest_name;
        		             $order->image         = $details->rest_image;
        		             $order->rest_address  = $details->address1;
        		             $order->rest_latitude = $details->latitude;
        		             $order->rest_longitude= $details->longitude;
        		             $order->rest_city     = $details->city;
        		             $order->rest_landmark = $details->landmark;
        		             $order->rest_country  = $details->country;
        		             $order->service_charge= $details->service_charge;
        		             $order->delivery_charge='0';
        		             $order->thumbnail      = $details->thumbnail;
        		         }
        		         else
        		         {
        		             $order->rest_name     = '';
        		             $order->image         = '';
        		             $order->rest_address  = '';
        		             $order->rest_latitude = '';
        		             $order->rest_longitude= '';
        		             $order->rest_city     = '';
        		             $order->rest_landmark = '';
        		             $order->rest_country  = '';
        		             $order->service_charge= '';
        		             $order->delivery_charge='0';
        		             $order->thumbnail      ='';
        		         }
            		     
            		     $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$order->r_id,'user_id'=>$guest_check->row()->guest_id,'type'=>'guest'));
            		     if($review_check->num_rows()>0)
            		     {
            		         $order->review_added_status = true;
            		     }
            		     else
            		     {
            		         $order->review_added_status = false;
            		     }   
        		    }
        	    	$this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $orders,
                            		            ), REST_Controller::HTTP_OK);
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}
//******************************************************************* GET DRIVING DISTANCE ************************************************************************//	
	// function GetDrivingDistance($lat1, $lat2, $long1,$long2)
 //    {
 //        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2."%2C".$long2."&mode=driving&language=pl-PL&key=" . GOOGLE_MAP_KEY;
 //        $ch = curl_init();
 //        curl_setopt($ch, CURLOPT_URL, $url);
 //        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
 //        curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
 //        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
 //        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
 //        $response = curl_exec($ch);
 //        curl_close($ch);
 //        $response_a = json_decode($response, true);
 //        $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
 //        $time = $response_a['rows'][0]['elements'][0]['duration']['text'];
    
 //        return array('distance' => $dist, 'time' => $time);
 //        // return $response_a;
 //    }	
	
}
?>
