<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Notification extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_notification','notif');
	}
	public function index_get()
	{
	   $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
    		    $notifications = $this->notif->getNotifications($user_id);
            	$this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              "data"    => $notifications,
                    		            ), REST_Controller::HTTP_OK);
    		}
    		else
    		{
    			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                        			  "status"  => true,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
}
?>
