<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';

class Login extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_login','login');
	}
	public function index_post()
	{
      $username   = $this->security->xss_clean($this->input->post('username'));
		$pass       = $this->security->xss_clean($this->input->post('password'));
		$password   = md5($pass);
		$fcm        = $this->security->xss_clean($this->input->post('fcm'));
		$uid        = $this->security->xss_clean($this->input->post('uid'));
		
// 		$get       = $this->Common->get_details('users',array('email'=>$email,'password'=>$password));
        
      if(is_numeric($username))
      {
         $check_phone = $this->Common->get_details('users',array('mobile'=>$username));
         if($check_phone->num_rows()==0)
         {
            $this->response(array(
				   "status"  => false,
				   "message" => "There is no account associated with this mobile number",
				   "data"    => ''
				), REST_Controller::HTTP_UNAUTHORIZED);
         }
         else
         {
            $get = $this->login->authenticate($username,$password);
            	if($get->num_rows() > 0)
            	{
            		$user        = $get->row();
            	   $user->token = $this->generateToken($user->user_id);
            			
            		if ($user->status == '1') 
            		{  
            			$guest_check     = $this->Common->get_details('guest',array('token'=>$uid));
    	               if($guest_check->num_rows()>0)
    	               {
    	                  $guest_id       = $guest_check->row()->guest_id;
                    		$check_guestcart= $this->Common->get_details('guest_cart',array('guest_id'=>$guest_id));
                    		
                			if($check_guestcart->num_rows()>0)
                			{
                			   $guest_cart = $check_guestcart->result();
                			   foreach($guest_cart as $cart)
                			   {  
                			   	$cart_id = null;
                			      $check_cart= $this->Common->get_details('cart',array('product_id' => $cart->product_id, 'r_id' => $cart->r_id, 'branch_id' => $cart->branch_id, 'user_id' => $user->user_id));
                			      if($check_cart->num_rows() > 0) {
                			      	$cart_id = $check_cart->row()->cart_id;
                			      	$this->Common->update('cart_id',$cart_id,'cart',array('quantity' => $cart->quantity));

                			      } else {

	                			      $cart_array = [
	                    			      'user_id'      => $user->user_id,
	                    			      'r_id'         => $cart->r_id,
	                    			      'branch_id'    => $cart->branch_id,
	                    			      'type'         => $cart->type,
	                    			      'product_id'   => $cart->product_id,
	                    			      'price_id'     => $cart->price_id,
	                    			      'quantity'     => $cart->quantity,
	                    			      'date'         => $cart->date,
	                    			      'time'         => $cart->time
	                    			   ];

	                    			   $cart_id = $this->Common->insert('cart',$cart_array);
	                    			}

	                    			if($cart_id) {

                			      // if($cart_id=$this->Common->insert('cart',$cart_array))
                			      // {
                			         $subcart_check = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$cart->gcart_id))->result();
                			         foreach($subcart_check as $sub)
                			         {
                			         	$sub_check = $this->Common->get_details('sub_cart',array('cart_id'=>$cart_id, 'product_id' => $cart->product_id, 'cat_id' => $sub->cat_id,));
                			         	if($sub_check->num_rows() <= 0) {

	                			            $sub_array  =  [
	                			               'cart_id'     => $cart_id,
	                			               'product_id'  => $cart->product_id,
	                			               'price_id'    => $cart->price_id,
	                			               'cat_id'      => $sub->cat_id,
	                			               'val_id'      => $sub->val_id,
	                			               'quantity'    => $sub->quantity
	                			            ];
	                			            $this->Common->insert('sub_cart',$sub_array); 
	                			         }                  
                			         }
                			                 
                			         $this->Common->delete('guest_cart',array('gcart_id' => $cart->gcart_id));
                                 $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart->gcart_id));
                			      }
                			   }
                  		}
                    	}	
              			    
            			$this->Common->update('user_id',$user->user_id,'users',array('fcm'=>$fcm,'uid'=>$uid));		
            			    $user_details  = $this->Common->get_details('users',array('user_id'=>$user->user_id))->row();
            			$user_details->token  = $user->token;
            			$this->response(array(
            						                  "status"  => true,
            						                  "message" => "Success",
            						                  "data"    => $user_details
            						              ), REST_Controller::HTTP_OK);
            			}
            			else 
            			{
            					$this->response(array(
            					                        "status"  => false,
            					                        "message" => "Your account has been deactivated, please contact customer support centre for more details",
            					                        "data"    => ''
            					                      ), REST_Controller::HTTP_UNAUTHORIZED);
            			}
            		}
            		else 
            		{
            				$this->response(array(
            				                            "status"  => false,
            				                            "message" => "The password you entered is incorrect",
            				                            "data"    => ''
            				                      ), REST_Controller::HTTP_UNAUTHORIZED);
            		}  
              }
        }
        else
        {
           $check_email = $this->Common->get_details('users',array('email'=>$username));
           if($check_email->num_rows()==0)
           {
               $this->response(array(
				                        "status"  => false,
				                        "message" => "There is no account associated with this email id",
				                        "data"    => ''
				                      ), REST_Controller::HTTP_UNAUTHORIZED);
           }
           else
           {
                $get = $this->login->emailauthenticate($username,$password);
        		if($get->num_rows() > 0)
        		{
        			$user        = $get->row();
        	        $user->token = $this->generateToken($user->user_id);
        			
        			if ($user->status == '1') 
        			{  
        			      $guest_check     = $this->Common->get_details('guest',array('token'=>$uid));
	                      if($guest_check->num_rows()>0)
	                      {
    	                         $guest_id       = $guest_check->row()->guest_id;
                    			 $check_guestcart= $this->Common->get_details('guest_cart',array('guest_id'=>$guest_id));
                			     if($check_guestcart->num_rows()>0)
                			     {
                			        $guest_cart = $check_guestcart->result();
                			        foreach($guest_cart as $cart)
                			        {
                			             $cart_array = [
                    			                         'user_id'      => $user->user_id,
                    			                         'r_id'         => $cart->r_id,
                    			                         'branch_id'    => $cart->branch_id,
                    			                         'type'         => $cart->type,
                    			                         'product_id'   => $cart->product_id,
                    			                         'price_id'     => $cart->price_id,
                    			                         'quantity'     => $cart->quantity,
                    			                         'date'         => $cart->date,
                    			                         'time'         => $cart->time
                    			                      ];
                			             if($id=$this->Common->insert('cart',$cart_array))
                			             {
                			                 $subcart_check = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$cart->gcart_id))->result();
                			                 foreach($subcart_check as $sub)
                			                 {
                			                     $sub_array  =  [
                			                                       'cart_id'     => $id,
                			                                       'product_id'  => $cart->product_id,
                			                                       'price_id'    => $cart->price_id,
                			                                       'cat_id'      => $sub->cat_id,
                			                                       'val_id'      => $sub->val_id,
                			                                       'quantity'    => $sub->quantity
                			                                    ];
                			                    $this->Common->insert('sub_cart',$sub_array);                   
                			                 }
                			                 
                			                 $this->Common->delete('guest_cart',array('gcart_id' => $cart->gcart_id));
                                             $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart->gcart_id));
                			             }
                			        }
                  			     }
                	    }	
          			    
        			    $this->Common->update('user_id',$user->user_id,'users',array('fcm'=>$fcm,'uid'=>$uid));		
        			    $user_details  = $this->Common->get_details('users',array('user_id'=>$user->user_id))->row();
        			    $user_details->token  = $user->token;
        			    $this->response(array(
        						                  "status"  => true,
        						                  "message" => "Success",
        						                  "data"    => $user_details
        						              ), REST_Controller::HTTP_OK);
        			}
        			else 
        			{
        					$this->response(array(
        					                        "status"  => false,
        					                        "message" => "Your account has been deactivated, please contact customer support centre for more details",
        					                        "data"    => ''
        					                      ), REST_Controller::HTTP_UNAUTHORIZED);
        			}
        		}
        		else 
        		{
        				$this->response(array(
        				                            "status"  => false,
        				                            "message" => "The password you entered is incorrect",
        				                            "data"    => ''
        				                      ), REST_Controller::HTTP_UNAUTHORIZED);
        		}
           }
        }
        


	}

	public function logout_post()
	{
		$header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $this->Common->update('user_id', $user_id, 'users', array('uid' => '', 'fcm' => ''));
			}
		}
		$this->response(array(
                        "status"  => true,
                        "message" => "Success"
                    ), REST_Controller::HTTP_OK);
	}

	function getKey()
	{
		while (true) {
			$key = $this->key();
			$cond = [
				'auth' => $key
			];

			$check = $this->Common->get_details('users',$cond);

			if ($check->num_rows() == 0) {
				break;
			}
		}
		return $key;
    }

	function key()
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < 20; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
		return $randomString;
	}

//******************************************* GENERATE TOKEN ************************************************************************************************************************//	
	public function generateToken($user_id)
	{
		$key    = 'fA5eKhl2TNiG3vGxXvMScg';
        $secret = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
        $token  = array(
                           "iss" => $key,
				           "id"  => $user_id,
                       );
        $tok = JWT::encode( $token, $secret );
		return $tok;
	}

//*********************************************** DECODE TOKEN **********************************************************************************************************************//	
	public function decodeGuestToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'umM6RFZZVWxNyKFlVD2EUdxl4Rxn9ym5S6i8';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

}
?>
