<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Footer extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_footer','footer');
	}
	public function index_get()
	{   
        $get_restaurants      = $this->footer->getRestaurants();
        $restaurants = [];
        $cuisines = [];
        $areas = [];
        $facebook = "";
        $instagram = "";
        $twitter = "";

        if($get_restaurants->num_rows()>0){
            $restaurants = $get_restaurants->result();
            foreach($restaurants as $restaurant)
        	{
              $orders_no = $this->footer->getOrderNo($restaurant->r_id); 
              $restaurant->orders_no = $orders_no;
            }
            function array_multi_subsort($array, $subkey)
            {
                $b = array(); $c = array();
            
                foreach ($array as $k => $v)
                {
                    $b[$k] = strtolower($v->$subkey);
                }
            
                arsort($b);
                foreach ($b as $key => $val)
                {
                    $c[] = $array[$key];
                }
            
                return $c;
            }
            $restaurants = array_multi_subsort($restaurants,'orders_no');
        }
            $cuisines_array      = $this->footer->getCuisines();
            if($cuisines_array->num_rows()>0){
                $cuisines       =  $cuisines_array->result();
            }
            $get_areas  = $this->footer->getAreas();
            if($get_areas->num_rows()>0){
                $areas       =  $get_areas->result();
            }
            $get_facebook   = $this->Common->get_details('social_media',array('media'=>'Facebook'));
            if($get_facebook->num_rows()>0){
                $facebook       =  $get_facebook->row()->link;
            }
            $get_instagram   = $this->Common->get_details('social_media',array('media'=>'Instagram'));
            if($get_instagram->num_rows()>0){
                $instagram       =  $get_instagram->row()->link;
            }
            $get_twitter   = $this->Common->get_details('social_media',array('media'=>'Twitter'));
            if($get_instagram->num_rows()>0){
                $twitter       =  $get_twitter->row()->link;
            }
      
        $this->response(array(
            "status"  => true,
            "message" => "Success",
            'restaurants'    => $restaurants,
            'cuisines' => $cuisines,
            'areas'    => $areas,
            'facebook_link'  => $facebook,
            'instagram_link'  => $instagram,
            'twitter_link'  => $twitter
          ), REST_Controller::HTTP_OK);
         
	}
	
	
}
?>