<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Favourites extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('android/M_favourites','favourites');
        $this->load->model('Common');
        $this->load->model('android/M_products','products');
	}
//************************************* ADD ******************************************//	
	public function add_post()
	{
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
		$header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
        			$branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
                    $product_id    = $this->security->xss_clean($this->input->post('product_id')); 
        			
        			date_default_timezone_set('Asia/Kolkata');
                    $timestamp = date('Y-m-d H:i:s');
        			
        		    $check      = $this->Common->get_details('favourites',array('user_id'=>$user_id,'product_id'=>$product_id));
                    if($check->num_rows()=='0')
                    {       	            
                            $array  = [
                            	          'user_id'   => $user_id,
                            	          'r_id'      => $restaurant_id,
                            	          'branch_id' => $branch_id,
                            	          'product_id'=> $product_id, 
                            	          'date'      => date('Y-m-d'),
                            	          'timestamp' => $timestamp
                                      ];
                            $id=$this->Common->insert('favourites',$array);
        
                            $this->response(array(
                        		                   "status"  => true,
                        		                   "message" => "Success",
                        		                   'fav_status' => true,
                        					       "fav_id"   => $id
                        		                  ), REST_Controller::HTTP_OK);	           
        	        }
        		    else
        		    {
        		        $this->response(array(
                            		              "status" => false,
                            		              "message" => "Item already added to favourites.",
                            		              'fav_status' => false,
                            		              'fav_id' => '',
                            		            ), REST_Controller::HTTP_OK);
        		    }
			    }
    			else
    			{
    			    $this->response(array(
                        			     "status"  => false,
                        			     "message" => "Your session has expired, please login again."
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    			}
    		}		   
    		else 
    		{
    		    $this->response(array(
                        			     "status"  => false,
                        			     "message" => "Your session has expired, please login again.."
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	          $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again!"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

//*********************************** GET *********************************************//	
	public function get_get()
	{
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
		$header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1) 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
			   $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			   if($uid_check->num_rows()>0)
    		   {
    		       $check      = $this->favourites->getFavouriteProducts($user_id);
                   if($check->num_rows()>0)
                   {  
            		   $favourites =  $check->result();  
            		   foreach($favourites as $fav)
            		   {
            		       $product    = $this->Common->get_details('products',array('p_id'=>$fav->product_id))->row();
            		       $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$fav->r_id))->row();
            		       $fav->product_name = $product->name;
            		       $fav->description  = $product->description;
            		       $fav->price        = $this->products->get_smallest_price($fav->product_id); 
            		       $fav->product_image= $product->cover_image;
            		       $fav->thumbnail    = $product->thumbnail;
            		       $fav->rest_name    = $restaurant->rest_name;
            		       $fav->rest_image   = $restaurant->cover_image;
            		       $fav->rest_image   = $restaurant->cover_image;
            		   }
            		   $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $favourites,
                            		            ), REST_Controller::HTTP_OK);
                   }
                   else
                   {
                       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed",
                            		              'data'  => [],
                            		            ), REST_Controller::HTTP_OK);
                   }
    		   }
    		   else
    		   {
    		       $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        		     ), REST_Controller::HTTP_UNAUTHORIZED);
    		   }
    		}		   
    		else 
    		{
    		   $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        		     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	         $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

//***************************************** REMOVE ********************************************************************************************************************************//	
	public function remove_post()
	{
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
		$header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			   $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			   if($uid_check->num_rows()>0)
			   {
			       $fav_id     = $this->security->xss_clean($this->input->post('favourite_id'));
        		   $check      = $this->Common->get_details('favourites',array('fav_id'=>$fav_id));
                   if($check->num_rows()>0)
                   {  
            		   $this->Common->delete('favourites',array('fav_id'=>$fav_id));
            		   $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);
                   }
                   else
                   {
                       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_NOT_FOUND);
                   }
			   }
			   else
			   {
			       $this->response(array(
                        			       "status"  => false,
                        			       "message" => "Your session has expired, please login again"
                        			     ), REST_Controller::HTTP_UNAUTHORIZED);
			   }
    		}		   
    		else 
    		{
    			   $this->response(array(
                        			       "status"  => false,
                        			       "message" => "Your session has expired, please login again"
                        			     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

//**************************************** DECODE TOKEN ***************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
}
?>
